/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.List;
import org.elasticsearch.script.field.vectors.ByteKnnDenseVector;
import org.elasticsearch.script.field.vectors.DenseVector;

public class BitKnnDenseVector
extends ByteKnnDenseVector {
    public BitKnnDenseVector(byte[] vector) {
        super(vector);
    }

    @Override
    public void checkDimensions(int qvDims) {
        if (qvDims != this.docVector.length) {
            throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims * 8 + "] than the document vectors [" + this.docVector.length * 8 + "].");
        }
    }

    @Override
    public float getMagnitude() {
        if (!this.magnitudeCalculated) {
            this.magnitude = DenseVector.getBitMagnitude(this.docVector, this.docVector.length);
            this.magnitudeCalculated = true;
        }
        return this.magnitude;
    }

    @Override
    public int l1Norm(byte[] queryVector) {
        return this.hamming(queryVector);
    }

    @Override
    public double l1Norm(List<Number> queryVector) {
        return this.hamming(queryVector);
    }

    @Override
    public double l2Norm(byte[] queryVector) {
        return Math.sqrt(this.hamming(queryVector));
    }

    @Override
    public double l2Norm(List<Number> queryVector) {
        return Math.sqrt(this.hamming(queryVector));
    }

    @Override
    public int dotProduct(byte[] queryVector) {
        throw new UnsupportedOperationException("dotProduct is not supported for bit vectors.");
    }

    @Override
    public double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector) {
        throw new UnsupportedOperationException("cosineSimilarity is not supported for bit vectors.");
    }

    @Override
    public double dotProduct(List<Number> queryVector) {
        throw new UnsupportedOperationException("dotProduct is not supported for bit vectors.");
    }

    @Override
    public double cosineSimilarity(byte[] queryVector, float qvMagnitude) {
        throw new UnsupportedOperationException("cosineSimilarity is not supported for bit vectors.");
    }

    @Override
    public double cosineSimilarity(List<Number> queryVector) {
        throw new UnsupportedOperationException("cosineSimilarity is not supported for bit vectors.");
    }

    @Override
    public double dotProduct(float[] queryVector) {
        throw new UnsupportedOperationException("dotProduct is not supported for bit vectors.");
    }

    @Override
    public int getDims() {
        return this.docVector.length * 8;
    }
}

