/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestParser;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.IncrementalBulkService;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.transport.Transports;

@ServerlessScope(value=Scope.PUBLIC)
public class RestBulkAction
extends BaseRestHandler {
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in bulk requests is deprecated.";
    public static final String FAILURE_STORE_STATUS_CAPABILITY = "failure_store_status";
    private final boolean allowExplicitIndex;
    private final IncrementalBulkService bulkHandler;
    private final Set<String> capabilities;

    public RestBulkAction(Settings settings, IncrementalBulkService bulkHandler) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
        this.bulkHandler = bulkHandler;
        this.capabilities = DataStream.isFailureStoreFeatureFlagEnabled() ? Set.of(FAILURE_STORE_STATUS_CAPABILITY) : Set.of();
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_bulk"), new RestHandler.Route(RestRequest.Method.PUT, "/_bulk"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_bulk"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_bulk"), RestHandler.Route.builder(RestRequest.Method.POST, "/{index}/{type}/_bulk").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/{index}/{type}/_bulk").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build());
    }

    @Override
    public String getName() {
        return "bulk_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!request.isStreamedContent()) {
            if (request.getRestApiVersion() == RestApiVersion.V_7 && request.hasParam("type")) {
                request.param("type");
            }
            BulkRequest bulkRequest = new BulkRequest();
            String defaultIndex = request.param("index");
            String defaultRouting = request.param("routing");
            FetchSourceContext defaultFetchSourceContext = FetchSourceContext.parseFromRestRequest(request);
            String defaultPipeline = request.param("pipeline");
            boolean defaultListExecutedPipelines = request.paramAsBoolean("list_executed_pipelines", false);
            String waitForActiveShards = request.param("wait_for_active_shards");
            if (waitForActiveShards != null) {
                bulkRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
            }
            Boolean defaultRequireAlias = request.paramAsBoolean("require_alias", false);
            boolean defaultRequireDataStream = request.paramAsBoolean("require_data_stream", false);
            bulkRequest.timeout(request.paramAsTime("timeout", BulkShardRequest.DEFAULT_TIMEOUT));
            bulkRequest.setRefreshPolicy(request.param("refresh"));
            bulkRequest.add(request.requiredContent(), defaultIndex, defaultRouting, defaultFetchSourceContext, defaultPipeline, defaultRequireAlias, defaultRequireDataStream, defaultListExecutedPipelines, this.allowExplicitIndex, request.getXContentType(), request.getRestApiVersion());
            return channel -> client.bulk(bulkRequest, new RestRefCountedChunkedToXContentListener<BulkResponse>((RestChannel)channel));
        }
        if (request.getRestApiVersion() == RestApiVersion.V_7 && request.hasParam("type")) {
            request.param("type");
        }
        String waitForActiveShards = request.param("wait_for_active_shards");
        TimeValue timeout = request.paramAsTime("timeout", BulkShardRequest.DEFAULT_TIMEOUT);
        String refresh = request.param("refresh");
        return new ChunkHandler(this.allowExplicitIndex, request, () -> this.bulkHandler.newBulkRequest(waitForActiveShards, timeout, refresh));
    }

    @Override
    public boolean supportsBulkContent() {
        return true;
    }

    @Override
    public boolean allowsUnsafeBuffers() {
        return true;
    }

    @Override
    public Set<String> supportedCapabilities() {
        return this.capabilities;
    }

    static class ChunkHandler
    implements BaseRestHandler.RequestBodyChunkConsumer {
        private final boolean allowExplicitIndex;
        private final RestRequest request;
        private final Map<String, String> stringDeduplicator = new HashMap<String, String>();
        private final String defaultIndex;
        private final String defaultRouting;
        private final FetchSourceContext defaultFetchSourceContext;
        private final String defaultPipeline;
        private final boolean defaultListExecutedPipelines;
        private final Boolean defaultRequireAlias;
        private final boolean defaultRequireDataStream;
        private final BulkRequestParser parser;
        private final Supplier<IncrementalBulkService.Handler> handlerSupplier;
        private IncrementalBulkService.Handler handler;
        private volatile RestChannel restChannel;
        private boolean shortCircuited;
        private int bytesParsed = 0;
        private final ArrayDeque<ReleasableBytesReference> unParsedChunks = new ArrayDeque(4);
        private final ArrayList<DocWriteRequest<?>> items = new ArrayList(4);

        ChunkHandler(boolean allowExplicitIndex, RestRequest request, Supplier<IncrementalBulkService.Handler> handlerSupplier) {
            this.allowExplicitIndex = allowExplicitIndex;
            this.request = request;
            this.defaultIndex = request.param("index");
            this.defaultRouting = request.param("routing");
            this.defaultFetchSourceContext = FetchSourceContext.parseFromRestRequest(request);
            this.defaultPipeline = request.param("pipeline");
            this.defaultListExecutedPipelines = request.paramAsBoolean("list_executed_pipelines", false);
            this.defaultRequireAlias = request.paramAsBoolean("require_alias", false);
            this.defaultRequireDataStream = request.paramAsBoolean("require_data_stream", false);
            this.parser = new BulkRequestParser(false, request.getRestApiVersion());
            this.handlerSupplier = handlerSupplier;
        }

        public void accept(RestChannel restChannel) {
            this.restChannel = restChannel;
            this.handler = this.handlerSupplier.get();
            this.request.contentStream().next();
        }

        @Override
        public void handleChunk(RestChannel channel, ReleasableBytesReference chunk, boolean isLast) {
            int bytesConsumed;
            assert (this.handler != null);
            assert (channel == this.restChannel);
            if (this.shortCircuited) {
                chunk.close();
                return;
            }
            if (chunk.length() == 0) {
                chunk.close();
                bytesConsumed = 0;
            } else {
                try {
                    this.unParsedChunks.add(chunk);
                    BytesReference data = this.unParsedChunks.size() > 1 ? CompositeBytesReference.of(this.unParsedChunks.toArray(new ReleasableBytesReference[0])) : chunk;
                    bytesConsumed = this.parser.incrementalParse(data, this.defaultIndex, this.defaultRouting, this.defaultFetchSourceContext, this.defaultPipeline, this.defaultRequireAlias, this.defaultRequireDataStream, this.defaultListExecutedPipelines, this.allowExplicitIndex, this.request.getXContentType(), (request, type) -> this.items.add((DocWriteRequest<?>)request), this.items::add, this.items::add, !isLast, this.stringDeduplicator);
                    this.bytesParsed += bytesConsumed;
                }
                catch (Exception e) {
                    this.shortCircuit();
                    new RestToXContentListener(channel).onFailure(new ElasticsearchParseException("could not parse bulk request body", (Throwable)e, new Object[0]));
                    return;
                }
            }
            ArrayList<Releasable> releasables = this.accountParsing(bytesConsumed);
            if (isLast) {
                assert (this.unParsedChunks.isEmpty());
                if (this.bytesParsed == 0) {
                    this.shortCircuit();
                    new RestToXContentListener(channel).onFailure(new ElasticsearchParseException("request body is required", new Object[0]));
                } else {
                    assert (channel != null);
                    ArrayList toPass = new ArrayList(this.items);
                    this.items.clear();
                    this.handler.lastItems(toPass, () -> Releasables.close((Iterable)releasables), new RestRefCountedChunkedToXContentListener<BulkResponse>(channel));
                }
            } else if (!this.items.isEmpty()) {
                ArrayList toPass = new ArrayList(this.items);
                this.items.clear();
                this.handler.addItems(toPass, () -> Releasables.close((Iterable)releasables), () -> this.request.contentStream().next());
            } else {
                assert (releasables.isEmpty());
                this.request.contentStream().next();
            }
        }

        @Override
        public void streamClose() {
            assert (Transports.assertTransportThread());
            this.shortCircuit();
        }

        private void shortCircuit() {
            this.shortCircuited = true;
            Releasables.close((Releasable)this.handler);
            Releasables.close(this.unParsedChunks);
            this.unParsedChunks.clear();
        }

        private ArrayList<Releasable> accountParsing(int bytesConsumed) {
            ArrayList<Releasable> releasables = new ArrayList<Releasable>(this.unParsedChunks.size());
            while (bytesConsumed > 0) {
                ReleasableBytesReference reference = this.unParsedChunks.removeFirst();
                releasables.add(reference);
                if (bytesConsumed >= reference.length()) {
                    bytesConsumed -= reference.length();
                    continue;
                }
                this.unParsedChunks.addFirst(reference.retainedSlice(bytesConsumed, reference.length() - bytesConsumed));
                bytesConsumed = 0;
            }
            return releasables;
        }
    }
}

