/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class CompletionPersistentTaskAction
extends ActionType<PersistentTaskResponse> {
    public static final CompletionPersistentTaskAction INSTANCE = new CompletionPersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/completion";

    private CompletionPersistentTaskAction() {
        super(NAME);
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(CompletionPersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver, PersistentTaskResponse::new, threadPool.executor("generic"));
            this.persistentTasksClusterService = persistentTasksClusterService;
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void masterOperation(Task ignoredTask, Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            if (request.localAbortReason != null) {
                assert (request.exception == null) : "request has both exception " + request.exception + " and local abort reason " + request.localAbortReason;
                this.persistentTasksClusterService.unassignPersistentTask(request.taskId, request.allocationId, request.localAbortReason, listener.map(PersistentTaskResponse::new));
            } else {
                this.persistentTasksClusterService.completePersistentTask(request.taskId, request.allocationId, request.exception, listener.map(PersistentTaskResponse::new));
            }
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String taskId;
        private Exception exception;
        private long allocationId = -1L;
        private String localAbortReason;

        public Request() {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskId = in.readString();
            this.allocationId = in.readLong();
            this.exception = in.readException();
            this.localAbortReason = in.readOptionalString();
        }

        public Request(String taskId, long allocationId, Exception exception, String localAbortReason) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.taskId = taskId;
            this.exception = exception;
            this.allocationId = allocationId;
            this.localAbortReason = localAbortReason;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeLong(this.allocationId);
            out.writeException(this.exception);
            out.writeOptionalString(this.localAbortReason);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError("task id is missing", validationException);
            }
            if (this.allocationId < 0L) {
                validationException = ValidateActions.addValidationError("allocation id is negative or missing", validationException);
            }
            if (this.exception != null && this.localAbortReason != null) {
                validationException = ValidateActions.addValidationError("task cannot be both locally aborted and failed", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskId, request.taskId) && this.allocationId == request.allocationId && Objects.equals(this.exception, request.exception) && Objects.equals(this.localAbortReason, request.localAbortReason);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.allocationId, this.exception, this.localAbortReason);
        }
    }
}

