/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnparsedModel;

public interface InferenceService
extends Closeable {
    default public void init(Client client) {
    }

    public String name();

    public void parseRequestConfig(String var1, TaskType var2, Map<String, Object> var3, ActionListener<Model> var4);

    public Model parsePersistedConfigWithSecrets(String var1, TaskType var2, Map<String, Object> var3, Map<String, Object> var4);

    public Model parsePersistedConfig(String var1, TaskType var2, Map<String, Object> var3);

    public void infer(Model var1, @Nullable String var2, List<String> var3, boolean var4, Map<String, Object> var5, InputType var6, TimeValue var7, ActionListener<InferenceServiceResults> var8);

    public void chunkedInfer(Model var1, @Nullable String var2, List<String> var3, Map<String, Object> var4, InputType var5, ChunkingOptions var6, TimeValue var7, ActionListener<List<ChunkedInferenceServiceResults>> var8);

    public void start(Model var1, ActionListener<Boolean> var2);

    default public void stop(UnparsedModel unparsedModel, ActionListener<Boolean> listener) {
        listener.onResponse(true);
    }

    default public void putModel(Model modelVariant, ActionListener<Boolean> listener) {
        listener.onResponse(true);
    }

    default public void checkModelConfig(Model model, ActionListener<Model> listener) {
        listener.onResponse(model);
    }

    default public Model updateModelWithEmbeddingDetails(Model model, int embeddingSize) {
        return model;
    }

    public TransportVersion getMinimalSupportedVersion();

    default public Set<TaskType> supportedStreamingTasks() {
        return Set.of();
    }

    default public boolean canStream(TaskType taskType) {
        return this.supportedStreamingTasks().contains(taskType);
    }

    default public List<DefaultConfigId> defaultConfigIds() {
        return List.of();
    }

    default public void defaultConfigs(ActionListener<List<Model>> defaultsListener) {
        defaultsListener.onResponse(List.of());
    }

    default public void updateModelsWithDynamicFields(List<Model> model, ActionListener<List<Model>> listener) {
        listener.onResponse(model);
    }

    public record DefaultConfigId(String inferenceId, TaskType taskType, InferenceService service) {
    }
}

