/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class StringStoredFieldFieldLoader
implements SourceLoader.SyntheticFieldLoader {
    private final String storedFieldLoaderName;
    private final String fullName;
    private final String simpleName;
    private List<Object> values = Collections.emptyList();

    public StringStoredFieldFieldLoader(String fullName, String simpleName) {
        this(fullName, fullName, simpleName);
    }

    public StringStoredFieldFieldLoader(String storedFieldLoaderName, String fullName, String simpleName) {
        this.storedFieldLoaderName = storedFieldLoaderName;
        this.fullName = fullName;
        this.simpleName = simpleName;
    }

    @Override
    public final Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
        return Stream.of(Map.entry(this.storedFieldLoaderName, newValues -> {
            this.values = newValues;
        }));
    }

    @Override
    public final boolean hasValue() {
        return !this.values.isEmpty();
    }

    @Override
    public final void write(XContentBuilder b) throws IOException {
        switch (this.values.size()) {
            case 0: {
                return;
            }
            case 1: {
                b.field(this.simpleName);
                this.write(b, this.values.get(0));
                return;
            }
        }
        b.startArray(this.simpleName);
        for (Object value : this.values) {
            this.write(b, value);
        }
        b.endArray();
        this.reset();
    }

    @Override
    public void reset() {
        this.values = Collections.emptyList();
    }

    protected abstract void write(XContentBuilder var1, Object var2) throws IOException;

    @Override
    public final SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader reader, int[] docIdsInLeaf) throws IOException {
        return null;
    }

    @Override
    public String fieldName() {
        return this.fullName;
    }
}

