/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.plugins.internal.XContentMeteringParserDecorator;
import org.elasticsearch.xcontent.XContentType;

public class SourceToParse {
    private final BytesReference source;
    private final String id;
    @Nullable
    private final String routing;
    private final XContentType xContentType;
    private final Map<String, String> dynamicTemplates;
    private final XContentMeteringParserDecorator meteringParserDecorator;

    public SourceToParse(@Nullable String id, BytesReference source, XContentType xContentType, @Nullable String routing, Map<String, String> dynamicTemplates, XContentMeteringParserDecorator meteringParserDecorator) {
        this.id = id;
        this.source = source.hasArray() ? source : new BytesArray(source.toBytesRef());
        this.xContentType = Objects.requireNonNull(xContentType);
        this.routing = routing;
        this.dynamicTemplates = Objects.requireNonNull(dynamicTemplates);
        this.meteringParserDecorator = meteringParserDecorator;
    }

    public SourceToParse(String id, BytesReference source, XContentType xContentType) {
        this(id, source, xContentType, null, Map.of(), XContentMeteringParserDecorator.NOOP);
    }

    public SourceToParse(String id, BytesReference source, XContentType xContentType, String routing) {
        this(id, source, xContentType, routing, Map.of(), XContentMeteringParserDecorator.NOOP);
    }

    public BytesReference source() {
        return this.source;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    public Map<String, String> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public XContentMeteringParserDecorator getDocumentSizeObserver() {
        return this.meteringParserDecorator;
    }
}

