/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.net.InetAddress;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.IndexSettings;

public interface DocumentDimensions {
    public static DocumentDimensions fromIndexSettings(IndexSettings indexSettings) {
        return indexSettings.getMode().buildDocumentDimensions(indexSettings);
    }

    public DocumentDimensions addString(String var1, BytesRef var2);

    default public DocumentDimensions addString(String fieldName, String value) {
        return this.addString(fieldName, new BytesRef((CharSequence)value));
    }

    public DocumentDimensions addIp(String var1, InetAddress var2);

    public DocumentDimensions addLong(String var1, long var2);

    public DocumentDimensions addUnsignedLong(String var1, long var2);

    public DocumentDimensions addBoolean(String var1, boolean var2);

    public DocumentDimensions validate(IndexSettings var1);

    public static enum Noop implements DocumentDimensions
    {
        INSTANCE;


        @Override
        public DocumentDimensions addString(String fieldName, BytesRef utf8Value) {
            return this;
        }

        @Override
        public DocumentDimensions addString(String fieldName, String value) {
            return this;
        }

        @Override
        public DocumentDimensions addIp(String fieldName, InetAddress value) {
            return this;
        }

        @Override
        public DocumentDimensions addLong(String fieldName, long value) {
            return this;
        }

        @Override
        public DocumentDimensions addUnsignedLong(String fieldName, long value) {
            return this;
        }

        @Override
        public DocumentDimensions addBoolean(String fieldName, boolean value) {
            return this;
        }

        @Override
        public DocumentDimensions validate(IndexSettings settings) {
            return this;
        }
    }
}

