/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

public class BQSpaceUtils {
    public static final short B_QUERY = 4;
    private static final int B_QUERY_MASK = 15;

    public static void transposeBin(byte[] q, int dimensions, byte[] quantQueryByte) {
        int qOffset = 0;
        byte[] v1 = new byte[4];
        byte[] v = new byte[32];
        for (int i = 0; i < dimensions; i += 32) {
            int j;
            for (j = 0; j < v.length; j += 4) {
                v[j] = (byte)(q[qOffset + j] << 4 | q[qOffset + j] >>> 4 & 0xF);
                v[j + 1] = (byte)(q[qOffset + j + 1] << 4 | q[qOffset + j + 1] >>> 4 & 0xF);
                v[j + 2] = (byte)(q[qOffset + j + 2] << 4 | q[qOffset + j + 2] >>> 4 & 0xF);
                v[j + 3] = (byte)(q[qOffset + j + 3] << 4 | q[qOffset + j + 3] >>> 4 & 0xF);
            }
            for (j = 0; j < 4; ++j) {
                int k;
                BQSpaceUtils.moveMaskEpi8Byte(v, v1);
                for (k = 0; k < 4; ++k) {
                    quantQueryByte[(4 - j - 1) * (dimensions / 8) + i / 8 + k] = v1[k];
                    v1[k] = 0;
                }
                for (k = 0; k < v.length; k += 4) {
                    v[k] = (byte)(v[k] + v[k]);
                    v[k + 1] = (byte)(v[k + 1] + v[k + 1]);
                    v[k + 2] = (byte)(v[k + 2] + v[k + 2]);
                    v[k + 3] = (byte)(v[k + 3] + v[k + 3]);
                }
            }
            qOffset += 32;
        }
    }

    private static void moveMaskEpi8Byte(byte[] v, byte[] v1b) {
        int m = 0;
        for (int k = 0; k < v.length; ++k) {
            if ((v[k] & 0x80) == 128) {
                int n = m;
                v1b[n] = (byte)(v1b[n] | 1);
            }
            if (k % 8 == 7) {
                ++m;
                continue;
            }
            int n = m;
            v1b[n] = (byte)(v1b[n] << 1);
        }
    }
}

