/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;

public class ChunkedToXContentBuilder
implements Iterator<ToXContent> {
    private final ToXContent.Params params;
    private final Stream.Builder<ToXContent> builder = Stream.builder();
    private Iterator<ToXContent> iterator;

    public ChunkedToXContentBuilder(ToXContent.Params params) {
        this.params = params;
    }

    private void addChunk(ToXContent content) {
        assert (this.iterator == null) : "Builder has been read, cannot add any more chunks";
        this.builder.add(Objects.requireNonNull(content));
    }

    public ToXContent.Params params() {
        return this.params;
    }

    private void startObject() {
        this.addChunk((b, p) -> b.startObject());
    }

    private void startObject(String name) {
        this.addChunk((b, p) -> b.startObject(name));
    }

    private void endObject() {
        this.addChunk((b, p) -> b.endObject());
    }

    public ChunkedToXContentBuilder xContentObject(ToXContent contents) {
        this.addChunk((b, p) -> contents.toXContent(b.startObject(), p).endObject());
        return this;
    }

    public ChunkedToXContentBuilder xContentObject(String name, ToXContent contents) {
        this.addChunk((b, p) -> contents.toXContent(b.startObject(name), p).endObject());
        return this;
    }

    public ChunkedToXContentBuilder xContentObject(ChunkedToXContent contents) {
        this.startObject();
        this.append(contents);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder xContentObject(String name, ChunkedToXContent contents) {
        this.startObject(name);
        this.append(contents);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder xContentObject(Iterator<? extends ToXContent> contents) {
        this.startObject();
        this.append(contents);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder xContentObject(String name, Iterator<? extends ToXContent> contents) {
        this.startObject(name);
        this.append(contents);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder xContentObjectFields(Map<String, ? extends ToXContent> map) {
        this.startObject();
        map.forEach(this::field);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder xContentObjectFields(String name, Map<String, ? extends ToXContent> map) {
        this.startObject(name);
        map.forEach(this::field);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder xContentObjectFieldObjects(Map<String, ? extends ToXContent> map) {
        this.startObject();
        map.forEach(this::xContentObject);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder xContentObjectFieldObjects(String name, Map<String, ? extends ToXContent> map) {
        this.startObject(name);
        map.forEach(this::xContentObject);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder object(Consumer<ChunkedToXContentBuilder> contents) {
        this.startObject();
        this.execute(contents);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder object(String name, Consumer<ChunkedToXContentBuilder> contents) {
        this.startObject(name);
        this.execute(contents);
        this.endObject();
        return this;
    }

    public <T> ChunkedToXContentBuilder object(Iterator<T> items, BiConsumer<ChunkedToXContentBuilder, ? super T> create) {
        this.startObject();
        this.forEach(items, create);
        this.endObject();
        return this;
    }

    public <T> ChunkedToXContentBuilder object(Iterator<T> items, Function<? super T, ToXContent> create) {
        this.startObject();
        this.forEach(items, create);
        this.endObject();
        return this;
    }

    public <T> ChunkedToXContentBuilder object(String name, Iterator<T> items, BiConsumer<ChunkedToXContentBuilder, ? super T> create) {
        this.startObject(name);
        this.forEach(items, create);
        this.endObject();
        return this;
    }

    public <T> ChunkedToXContentBuilder object(String name, Iterator<T> items, Function<? super T, ToXContent> create) {
        this.startObject(name);
        this.forEach(items, create);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder object(Map<String, ?> map) {
        this.startObject();
        map.forEach(this::field);
        this.endObject();
        return this;
    }

    public ChunkedToXContentBuilder object(String name, Map<String, ?> map) {
        this.startObject(name);
        map.forEach(this::field);
        this.endObject();
        return this;
    }

    private void startArray() {
        this.addChunk((b, p) -> b.startArray());
    }

    private void startArray(String name) {
        this.addChunk((b, p) -> b.startArray(name));
    }

    private void endArray() {
        this.addChunk((b, p) -> b.endArray());
    }

    public ChunkedToXContentBuilder array(String name, String ... values) {
        this.addChunk((b, p) -> b.array(name, values));
        return this;
    }

    public <T> ChunkedToXContentBuilder array(Iterator<T> items, BiConsumer<ChunkedToXContentBuilder, ? super T> create) {
        this.startArray();
        this.forEach(items, create);
        this.endArray();
        return this;
    }

    public ChunkedToXContentBuilder array(Iterator<? extends ToXContent> items) {
        this.startArray();
        items.forEachRemaining(this::append);
        this.endArray();
        return this;
    }

    public <T> ChunkedToXContentBuilder array(Iterator<T> items, Function<? super T, ToXContent> create) {
        this.startArray();
        this.forEach(items, create);
        this.endArray();
        return this;
    }

    public <T> ChunkedToXContentBuilder array(String name, Iterator<T> items, BiConsumer<ChunkedToXContentBuilder, ? super T> create) {
        this.startArray(name);
        this.forEach(items, create);
        this.endArray();
        return this;
    }

    public ChunkedToXContentBuilder array(String name, Iterator<? extends ToXContent> items) {
        this.startArray(name);
        items.forEachRemaining(this::append);
        this.endArray();
        return this;
    }

    public <T> ChunkedToXContentBuilder array(String name, Iterator<T> items, Function<? super T, ToXContent> create) {
        this.startArray(name);
        this.forEach(items, create);
        this.endArray();
        return this;
    }

    public ChunkedToXContentBuilder field(String name) {
        this.addChunk((b, p) -> b.field(name));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, boolean value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, Boolean value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, int value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, Integer value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, long value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, Long value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, String value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, Enum<?> value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, ToXContent value) {
        this.addChunk((b, p) -> b.field(name, value, p));
        return this;
    }

    public ChunkedToXContentBuilder field(String name, ChunkedToXContent value) {
        this.addChunk((b, p) -> b.field(name));
        this.append(value);
        return this;
    }

    public ChunkedToXContentBuilder field(String name, Object value) {
        this.addChunk((b, p) -> b.field(name, value));
        return this;
    }

    public ChunkedToXContentBuilder execute(Consumer<ChunkedToXContentBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public <T> ChunkedToXContentBuilder forEach(Iterator<T> items, BiConsumer<ChunkedToXContentBuilder, ? super T> create) {
        items.forEachRemaining((? super E t) -> create.accept(this, (Object)t));
        return this;
    }

    public <T> ChunkedToXContentBuilder forEach(Iterator<T> items, Function<? super T, ToXContent> create) {
        items.forEachRemaining((? super E t) -> this.append((ToXContent)create.apply(t)));
        return this;
    }

    public ChunkedToXContentBuilder append(ToXContent xContent) {
        if (xContent != ToXContent.EMPTY) {
            this.addChunk(xContent);
        }
        return this;
    }

    public ChunkedToXContentBuilder append(ChunkedToXContent chunk) {
        if (chunk != ChunkedToXContent.EMPTY) {
            this.append(chunk.toXContentChunked(this.params));
        }
        return this;
    }

    public ChunkedToXContentBuilder append(Iterator<? extends ToXContent> xContents) {
        xContents.forEachRemaining(this::append);
        return this;
    }

    public ChunkedToXContentBuilder appendIfPresent(@Nullable ToXContent xContent) {
        if (xContent != null) {
            this.append(xContent);
        }
        return this;
    }

    public ChunkedToXContentBuilder appendIfPresent(@Nullable ChunkedToXContent chunk) {
        if (chunk != null) {
            this.append(chunk);
        }
        return this;
    }

    private Iterator<ToXContent> checkCreateIterator() {
        if (this.iterator == null) {
            this.iterator = this.builder.build().iterator();
        }
        return this.iterator;
    }

    @Override
    public boolean hasNext() {
        return this.checkCreateIterator().hasNext();
    }

    @Override
    public ToXContent next() {
        return this.checkCreateIterator().next();
    }

    @Override
    public void forEachRemaining(Consumer<? super ToXContent> action) {
        this.checkCreateIterator().forEachRemaining(action);
    }
}

