/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import com.carrotsearch.hppc.BitMixer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.AbstractHash;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class BytesRefHash
extends AbstractHash
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesRefHash.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    private final BytesRefArray bytesRefs;
    private final BytesRef spare;
    private IntArray hashes;

    public BytesRefHash(long capacity, BigArrays bigArrays) {
        this(capacity, 0.6f, bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesRefHash(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        boolean success = false;
        try {
            this.hashes = bigArrays.newIntArray(capacity, false);
            this.bytesRefs = new BytesRefArray(capacity, bigArrays);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
        this.spare = new BytesRef();
    }

    public BytesRefHash(BytesRefArray bytesRefArray, BigArrays bigArrays) {
        this(bytesRefArray, 0.6f, bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesRefHash(BytesRefArray bytesRefs, float maxLoadFactor, BigArrays bigArrays) {
        super(bytesRefs.size() + 1L, maxLoadFactor, bigArrays);
        boolean success = false;
        try {
            this.hashes = bigArrays.newIntArray(bytesRefs.size() + 1L, false);
            this.bytesRefs = BytesRefArray.takeOwnershipOf(bytesRefs);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
        this.spare = new BytesRef();
        int i = 0;
        while ((long)i < this.bytesRefs.size()) {
            this.bytesRefs.get(i, this.spare);
            this.reset(BytesRefHash.rehash(this.spare.hashCode()), i);
            ++i;
        }
        this.size = this.bytesRefs.size();
    }

    private static int rehash(int hash) {
        return BitMixer.mix32((int)hash);
    }

    public BytesRef get(long id, BytesRef dest) {
        return this.bytesRefs.get(id, dest);
    }

    public long find(BytesRef key, int code) {
        return this.find(key, code, this.spare);
    }

    private long find(BytesRef key, int code, BytesRef intermediate) {
        long slot;
        long index = slot = BytesRefHash.slot(BytesRefHash.rehash(code), this.mask);
        long id;
        while ((id = this.id(index)) != -1L && !key.bytesEquals(this.get(id, intermediate))) {
            index = BytesRefHash.nextSlot(index, this.mask);
        }
        return id;
    }

    public long find(BytesRef key) {
        return this.find(key, key.hashCode());
    }

    private long threadSafeFind(BytesRef key, BytesRef intermediate) {
        return this.find(key, key.hashCode(), intermediate);
    }

    private long set(BytesRef key, int code, long id) {
        long slot;
        assert (BytesRefHash.rehash(key.hashCode()) == code);
        assert (this.size < this.maxSize);
        long index = slot = BytesRefHash.slot(code, this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) {
                this.setId(index, id);
                this.append(id, key, code);
                ++this.size;
                return id;
            }
            if (key.bytesEquals(this.get(curId, this.spare))) {
                return -1L - curId;
            }
            index = BytesRefHash.nextSlot(index, this.mask);
        }
    }

    private void append(long id, BytesRef key, int code) {
        assert (this.size == id);
        this.bytesRefs.append(key);
        this.hashes = this.bigArrays.grow(this.hashes, id + 1L);
        this.hashes.set(id, code);
    }

    private boolean assertConsistent(long id, int code) {
        this.get(id, this.spare);
        return BytesRefHash.rehash(this.spare.hashCode()) == code;
    }

    private void reset(int code, long id) {
        long slot;
        assert (this.assertConsistent(id, code));
        long index = slot = BytesRefHash.slot(code, this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) break;
            index = BytesRefHash.nextSlot(index, this.mask);
        }
        this.setId(index, id);
    }

    public long add(BytesRef key, int code) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(key, BytesRefHash.rehash(code), this.size);
    }

    public long add(BytesRef key) {
        return this.add(key, key.hashCode());
    }

    @Override
    protected void removeAndAdd(long index) {
        long id = this.getAndSetId(index, -1L);
        assert (id >= 0L);
        int code = this.hashes.get(id);
        this.reset(code, id);
    }

    @Override
    public void close() {
        try (Releasable releasable = Releasables.wrap((Releasable[])new Releasable[]{this.bytesRefs, this.hashes});){
            super.close();
        }
    }

    public BytesRefArray getBytesRefs() {
        return this.bytesRefs;
    }

    public BytesRefArray takeBytesRefsOwnership() {
        try (Releasable releasable = Releasables.wrap((Releasable[])new Releasable[]{this});){
            BytesRefArray bytesRefArray = BytesRefArray.takeOwnershipOf(this.bytesRefs);
            return bytesRefArray;
        }
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.bytesRefs.ramBytesUsed() + this.ids.ramBytesUsed() + this.hashes.ramBytesUsed() + (long)this.spare.bytes.length;
    }

    public Finder newFinder() {
        return new Finder();
    }

    public class Finder {
        private final BytesRef intermediate = new BytesRef();

        public long find(BytesRef key) {
            return BytesRefHash.this.threadSafeFind(key, this.intermediate);
        }
    }
}

