/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.NoMergeScheduler;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.lucene.grouping.TopFieldGroups;
import org.elasticsearch.search.sort.ShardDocSortField;

public class Lucene {
    public static final String LATEST_CODEC = "Lucene912";
    public static final String SOFT_DELETES_FIELD = "__soft_deletes";
    public static final NamedAnalyzer STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, (Analyzer)new StandardAnalyzer());
    public static final NamedAnalyzer KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, (Analyzer)new KeywordAnalyzer());
    public static final NamedAnalyzer WHITESPACE_ANALYZER = new NamedAnalyzer("_whitespace", AnalyzerScope.GLOBAL, (Analyzer)new WhitespaceAnalyzer());
    public static final ScoreDoc[] EMPTY_SCORE_DOCS = new ScoreDoc[0];
    public static final TotalHits TOTAL_HITS_EQUAL_TO_ZERO = new TotalHits(0L, TotalHits.Relation.EQUAL_TO);
    public static final TotalHits TOTAL_HITS_GREATER_OR_EQUAL_TO_ZERO = new TotalHits(0L, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
    public static final TopDocs EMPTY_TOP_DOCS = new TopDocs(TOTAL_HITS_EQUAL_TO_ZERO, EMPTY_SCORE_DOCS);
    private static final Class<?> GEO_DISTANCE_SORT_TYPE_CLASS = LatLonDocValuesField.newDistanceSort((String)"some_geo_field", (double)0.0, (double)0.0).getClass();

    private Lucene() {
    }

    public static SegmentInfos readSegmentInfos(Directory directory) throws IOException {
        return SegmentInfos.readLatestCommit((Directory)directory);
    }

    public static Iterable<String> files(SegmentInfos infos) throws IOException {
        ArrayList<Collection> list = new ArrayList<Collection>();
        list.add(Collections.singleton(infos.getSegmentsFileName()));
        for (SegmentCommitInfo info : infos) {
            list.add(info.files());
        }
        return Iterables.flatten(list);
    }

    public static int getNumDocs(SegmentInfos info) {
        int numDocs = 0;
        for (SegmentCommitInfo si : info) {
            numDocs += si.info.maxDoc() - si.getDelCount() - si.getSoftDelCount();
        }
        return numDocs;
    }

    public static SegmentInfos readSegmentInfos(IndexCommit commit) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration((String)"segments", (String)"", (long)commit.getGeneration());
        return SegmentInfos.readCommit((Directory)commit.getDirectory(), (String)filename);
    }

    private static SegmentInfos readSegmentInfos(String segmentsFileName, Directory directory) throws IOException {
        return SegmentInfos.readCommit((Directory)directory, (String)segmentsFileName);
    }

    public static SegmentInfos pruneUnreferencedFiles(String segmentsFileName, Directory directory) throws IOException {
        SegmentInfos si = Lucene.readSegmentInfos(segmentsFileName, directory);
        try (Lock writeLock = directory.obtainLock("write.lock");){
            int foundSegmentFiles = 0;
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments")) continue;
                ++foundSegmentFiles;
                if (file.equals(si.getSegmentsFileName())) continue;
                directory.deleteFile(file);
            }
            assert (SegmentInfos.getLastCommitSegmentsFileName((Directory)directory).equals(segmentsFileName));
            if (foundSegmentFiles == 0) {
                throw new IllegalStateException("no commit found in the directory");
            }
        }
        IndexCommit cp = Lucene.getIndexCommit(si, directory);
        IndexWriter writer = new IndexWriter(directory, Lucene.indexWriterConfigWithNoMerging((Analyzer)STANDARD_ANALYZER).setSoftDeletesField(SOFT_DELETES_FIELD).setIndexCommit(cp).setCommitOnClose(false).setOpenMode(IndexWriterConfig.OpenMode.APPEND));
        writer.close();
        return si;
    }

    public static IndexCommit getIndexCommit(SegmentInfos si, Directory directory) throws IOException {
        return new CommitPoint(si, directory);
    }

    public static void cleanLuceneIndex(Directory directory) throws IOException {
        try (Lock writeLock = directory.obtainLock("write.lock");){
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments")) continue;
                directory.deleteFile(file);
            }
        }
        IndexWriter writer = new IndexWriter(directory, Lucene.indexWriterConfigWithNoMerging((Analyzer)STANDARD_ANALYZER).setSoftDeletesField(SOFT_DELETES_FIELD).setCommitOnClose(false).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        writer.close();
    }

    public static void checkSegmentInfoIntegrity(final Directory directory) throws IOException {
        new SegmentInfos.FindSegmentsFile<Object>(directory){

            protected Object doBody(String segmentFileName) throws IOException {
                try (IndexInput input = directory.openInput(segmentFileName, IOContext.READONCE);){
                    CodecUtil.checksumEntireFile((IndexInput)input);
                }
                return null;
            }
        }.run();
    }

    public static boolean exists(IndexSearcher searcher, Query query) throws IOException {
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            Scorer scorer = weight.scorer(context);
            if (scorer == null) continue;
            Bits liveDocs = context.reader().getLiveDocs();
            DocIdSetIterator iterator = scorer.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(doc)) {
                    return true;
                }
                doc = iterator.nextDoc();
            }
        }
        return false;
    }

    public static TotalHits readTotalHits(StreamInput in) throws IOException {
        long totalHits = in.readVLong();
        TotalHits.Relation totalHitsRelation = in.readEnum(TotalHits.Relation.class);
        return new TotalHits(totalHits, totalHitsRelation);
    }

    public static TopDocsAndMaxScore readTopDocs(StreamInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            ScoreDoc[] scoreDocs;
            TotalHits totalHits = Lucene.readTotalHits(in);
            float maxScore = in.readFloat();
            int scoreDocCount = in.readVInt();
            if (scoreDocCount == 0) {
                scoreDocs = EMPTY_SCORE_DOCS;
            } else {
                scoreDocs = new ScoreDoc[scoreDocCount];
                for (int i = 0; i < scoreDocs.length; ++i) {
                    scoreDocs[i] = new ScoreDoc(in.readVInt(), in.readFloat());
                }
            }
            return new TopDocsAndMaxScore(new TopDocs(totalHits, scoreDocs), maxScore);
        }
        if (type == 1) {
            TotalHits totalHits = Lucene.readTotalHits(in);
            float maxScore = in.readFloat();
            SortField[] fields = in.readArray(Lucene::readSortField, SortField[]::new);
            FieldDoc[] fieldDocs = new FieldDoc[in.readVInt()];
            for (int i = 0; i < fieldDocs.length; ++i) {
                fieldDocs[i] = Lucene.readFieldDoc(in);
            }
            return new TopDocsAndMaxScore((TopDocs)new TopFieldDocs(totalHits, (ScoreDoc[])fieldDocs, fields), maxScore);
        }
        if (type == 2) {
            TotalHits totalHits = Lucene.readTotalHits(in);
            float maxScore = in.readFloat();
            String field = in.readString();
            SortField[] fields = in.readArray(Lucene::readSortField, SortField[]::new);
            int size = in.readVInt();
            Object[] collapseValues = new Object[size];
            FieldDoc[] fieldDocs = new FieldDoc[size];
            for (int i = 0; i < fieldDocs.length; ++i) {
                fieldDocs[i] = Lucene.readFieldDoc(in);
                collapseValues[i] = Lucene.readSortValue(in);
            }
            return new TopDocsAndMaxScore((TopDocs)new TopFieldGroups(field, totalHits, (ScoreDoc[])fieldDocs, fields, collapseValues), maxScore);
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    public static FieldDoc readFieldDoc(StreamInput in) throws IOException {
        Object[] cFields = new Comparable[in.readVInt()];
        for (int j = 0; j < cFields.length; ++j) {
            byte type = in.readByte();
            if (type == 0) {
                cFields[j] = null;
                continue;
            }
            if (type == 1) {
                cFields[j] = in.readString();
                continue;
            }
            if (type == 2) {
                cFields[j] = in.readInt();
                continue;
            }
            if (type == 3) {
                cFields[j] = in.readLong();
                continue;
            }
            if (type == 4) {
                cFields[j] = Float.valueOf(in.readFloat());
                continue;
            }
            if (type == 5) {
                cFields[j] = in.readDouble();
                continue;
            }
            if (type == 6) {
                cFields[j] = in.readByte();
                continue;
            }
            if (type == 7) {
                cFields[j] = in.readShort();
                continue;
            }
            if (type == 8) {
                cFields[j] = in.readBoolean();
                continue;
            }
            if (type == 9) {
                cFields[j] = in.readBytesRef();
                continue;
            }
            if (type == 10) {
                cFields[j] = new BigInteger(in.readString());
                continue;
            }
            throw new IOException("Can't match type [" + type + "]");
        }
        return new FieldDoc(in.readVInt(), in.readFloat(), cFields);
    }

    public static Comparable<?> readSortValue(StreamInput in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return in.readString();
        }
        if (type == 2) {
            return in.readInt();
        }
        if (type == 3) {
            return in.readLong();
        }
        if (type == 4) {
            return Float.valueOf(in.readFloat());
        }
        if (type == 5) {
            return in.readDouble();
        }
        if (type == 6) {
            return in.readByte();
        }
        if (type == 7) {
            return in.readShort();
        }
        if (type == 8) {
            return in.readBoolean();
        }
        if (type == 9) {
            return in.readBytesRef();
        }
        if (type == 10) {
            return new BigInteger(in.readString());
        }
        throw new IOException("Can't match type [" + type + "]");
    }

    public static ScoreDoc readScoreDoc(StreamInput in) throws IOException {
        return new ScoreDoc(in.readVInt(), in.readFloat());
    }

    public static void writeTotalHits(StreamOutput out, TotalHits totalHits) throws IOException {
        out.writeVLong(totalHits.value);
        out.writeEnum(totalHits.relation);
    }

    public static void writeTopDocs(StreamOutput out, TopDocsAndMaxScore topDocs) throws IOException {
        TopDocs topDocs2 = topDocs.topDocs;
        if (topDocs2 instanceof TopFieldGroups) {
            TopFieldGroups topFieldGroups = (TopFieldGroups)topDocs2;
            out.writeByte((byte)2);
            Lucene.writeTotalHits(out, topDocs.topDocs.totalHits);
            out.writeFloat(topDocs.maxScore);
            out.writeString(topFieldGroups.field);
            out.writeArray(Lucene::writeSortField, topFieldGroups.fields);
            out.writeVInt(topDocs.topDocs.scoreDocs.length);
            for (int i = 0; i < topDocs.topDocs.scoreDocs.length; ++i) {
                ScoreDoc doc2 = topFieldGroups.scoreDocs[i];
                Lucene.writeFieldDoc(out, (FieldDoc)doc2);
                Lucene.writeSortValue(out, topFieldGroups.groupValues[i]);
            }
        } else {
            topDocs2 = topDocs.topDocs;
            if (topDocs2 instanceof TopFieldDocs) {
                TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs2;
                out.writeByte((byte)1);
                Lucene.writeTotalHits(out, topDocs.topDocs.totalHits);
                out.writeFloat(topDocs.maxScore);
                out.writeArray(Lucene::writeSortField, topFieldDocs.fields);
                out.writeArray((o, doc) -> Lucene.writeFieldDoc(o, (FieldDoc)doc), topFieldDocs.scoreDocs);
            } else {
                out.writeByte((byte)0);
                Lucene.writeTotalHits(out, topDocs.topDocs.totalHits);
                out.writeFloat(topDocs.maxScore);
                out.writeArray(Lucene::writeScoreDoc, topDocs.topDocs.scoreDocs);
            }
        }
    }

    private static void writeMissingValue(StreamOutput out, Object missingValue) throws IOException {
        if (missingValue == SortField.STRING_FIRST) {
            out.writeByte((byte)1);
        } else if (missingValue == SortField.STRING_LAST) {
            out.writeByte((byte)2);
        } else {
            out.writeByte((byte)0);
            out.writeGenericValue(missingValue);
        }
    }

    private static Object readMissingValue(StreamInput in) throws IOException {
        byte id = in.readByte();
        return switch (id) {
            case 0 -> in.readGenericValue();
            case 1 -> SortField.STRING_FIRST;
            case 2 -> SortField.STRING_LAST;
            default -> throw new IOException("Unknown missing value id: " + id);
        };
    }

    public static void writeSortValue(StreamOutput out, Object field) throws IOException {
        if (field == null) {
            out.writeByte((byte)0);
        } else {
            Class<?> type = field.getClass();
            if (type == String.class) {
                out.writeByte((byte)1);
                out.writeString((String)field);
            } else if (type == Integer.class) {
                out.writeByte((byte)2);
                out.writeInt((Integer)field);
            } else if (type == Long.class) {
                out.writeByte((byte)3);
                out.writeLong((Long)field);
            } else if (type == Float.class) {
                out.writeByte((byte)4);
                out.writeFloat(((Float)field).floatValue());
            } else if (type == Double.class) {
                out.writeByte((byte)5);
                out.writeDouble((Double)field);
            } else if (type == Byte.class) {
                out.writeByte((byte)6);
                out.writeByte((Byte)field);
            } else if (type == Short.class) {
                out.writeByte((byte)7);
                out.writeShort((Short)field);
            } else if (type == Boolean.class) {
                out.writeByte((byte)8);
                out.writeBoolean((Boolean)field);
            } else if (type == BytesRef.class) {
                out.writeByte((byte)9);
                out.writeBytesRef((BytesRef)field);
            } else if (type == BigInteger.class) {
                out.writeByte((byte)10);
                out.writeString(field.toString());
            } else {
                throw new IOException("Can't handle sort field value of type [" + type + "]");
            }
        }
    }

    public static void writeFieldDoc(StreamOutput out, FieldDoc fieldDoc) throws IOException {
        out.writeArray(Lucene::writeSortValue, fieldDoc.fields);
        out.writeVInt(fieldDoc.doc);
        out.writeFloat(fieldDoc.score);
    }

    public static void writeScoreDoc(StreamOutput out, ScoreDoc scoreDoc) throws IOException {
        if (!scoreDoc.getClass().equals(ScoreDoc.class)) {
            throw new IllegalArgumentException("This method can only be used to serialize a ScoreDoc, not a " + scoreDoc.getClass());
        }
        out.writeVInt(scoreDoc.doc);
        out.writeFloat(scoreDoc.score);
    }

    public static SortField.Type readSortType(StreamInput in) throws IOException {
        return SortField.Type.values()[in.readVInt()];
    }

    public static SortField readSortField(StreamInput in) throws IOException {
        String field = null;
        if (in.readBoolean()) {
            field = in.readString();
        }
        SortField.Type sortType = Lucene.readSortType(in);
        Object missingValue = Lucene.readMissingValue(in);
        boolean reverse = in.readBoolean();
        SortField sortField = new SortField(field, sortType, reverse);
        if (missingValue != null) {
            sortField.setMissingValue(missingValue);
        }
        return sortField;
    }

    public static void writeSortType(StreamOutput out, SortField.Type sortType) throws IOException {
        out.writeVInt(sortType.ordinal());
    }

    private static SortField rewriteMergeSortField(SortField sortField) {
        if (sortField.getClass() == GEO_DISTANCE_SORT_TYPE_CLASS) {
            SortField newSortField = new SortField(sortField.getField(), SortField.Type.DOUBLE);
            newSortField.setMissingValue(sortField.getMissingValue());
            return newSortField;
        }
        if (sortField.getClass() == SortedSetSortField.class) {
            SortField newSortField = new SortField(sortField.getField(), SortField.Type.STRING, sortField.getReverse());
            newSortField.setMissingValue(sortField.getMissingValue());
            return newSortField;
        }
        if (sortField.getClass() == SortedNumericSortField.class) {
            SortField newSortField = new SortField(sortField.getField(), ((SortedNumericSortField)sortField).getNumericType(), sortField.getReverse());
            newSortField.setMissingValue(sortField.getMissingValue());
            return newSortField;
        }
        if (sortField.getClass() == ShardDocSortField.class) {
            return new SortField(sortField.getField(), SortField.Type.LONG, sortField.getReverse());
        }
        return sortField;
    }

    public static void writeSortField(StreamOutput out, SortField sortField) throws IOException {
        if ((sortField = Lucene.rewriteMergeSortField(sortField)).getClass() != SortField.class) {
            throw new IllegalArgumentException("Cannot serialize SortField impl [" + sortField + "]");
        }
        if (sortField.getField() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(sortField.getField());
        }
        if (sortField.getComparatorSource() != null) {
            IndexFieldData.XFieldComparatorSource comparatorSource = (IndexFieldData.XFieldComparatorSource)sortField.getComparatorSource();
            Lucene.writeSortType(out, comparatorSource.reducedType());
            Lucene.writeMissingValue(out, comparatorSource.missingValue(sortField.getReverse()));
        } else {
            Lucene.writeSortType(out, sortField.getType());
            Lucene.writeMissingValue(out, sortField.getMissingValue());
        }
        out.writeBoolean(sortField.getReverse());
    }

    private static Number readExplanationValue(StreamInput in) throws IOException {
        byte numberType = in.readByte();
        return switch (numberType) {
            case 0 -> Float.valueOf(in.readFloat());
            case 1 -> in.readDouble();
            case 2 -> in.readZLong();
            default -> throw new IOException("Unexpected number type: " + numberType);
        };
    }

    public static Explanation readExplanation(StreamInput in) throws IOException {
        boolean match = in.readBoolean();
        String description = in.readString();
        Explanation[] subExplanations = new Explanation[in.readVInt()];
        for (int i = 0; i < subExplanations.length; ++i) {
            subExplanations[i] = Lucene.readExplanation(in);
        }
        if (match) {
            return Explanation.match((Number)Lucene.readExplanationValue(in), (String)description, (Explanation[])subExplanations);
        }
        return Explanation.noMatch((String)description, (Explanation[])subExplanations);
    }

    private static void writeExplanationValue(StreamOutput out, Number value) throws IOException {
        if (value instanceof Float) {
            out.writeByte((byte)0);
            out.writeFloat(value.floatValue());
        } else if (value instanceof Double) {
            out.writeByte((byte)1);
            out.writeDouble(value.doubleValue());
        } else {
            out.writeByte((byte)2);
            out.writeZLong(value.longValue());
        }
    }

    public static void writeExplanation(StreamOutput out, Explanation explanation) throws IOException {
        out.writeBoolean(explanation.isMatch());
        out.writeString(explanation.getDescription());
        Explanation[] subExplanations = explanation.getDetails();
        out.writeArray(Lucene::writeExplanation, subExplanations);
        if (explanation.isMatch()) {
            Lucene.writeExplanationValue(out, explanation.getValue());
        }
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return DirectoryReader.indexExists((Directory)directory);
    }

    public static boolean isCorruptionException(Throwable t) {
        return ExceptionsHelper.unwrapCorruption(t) != null;
    }

    public static Version parseVersionLenient(String toParse, Version defaultValue) {
        return LenientParser.parse(toParse, defaultValue);
    }

    public static SegmentReader segmentReader(LeafReader reader) {
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof FilterLeafReader) {
            FilterLeafReader fReader = (FilterLeafReader)reader;
            return Lucene.segmentReader(FilterLeafReader.unwrap((LeafReader)fReader));
        }
        if (reader instanceof FilterCodecReader) {
            FilterCodecReader fReader = (FilterCodecReader)reader;
            return Lucene.segmentReader((LeafReader)FilterCodecReader.unwrap((CodecReader)fReader));
        }
        throw new IllegalStateException("Can not extract segment reader from given index reader [" + reader + "]");
    }

    public static Bits asSequentialAccessBits(int maxDoc, @Nullable ScorerSupplier scorerSupplier) throws IOException {
        return Lucene.asSequentialAccessBits(maxDoc, scorerSupplier, 0L);
    }

    public static Bits asSequentialAccessBits(final int maxDoc, @Nullable ScorerSupplier scorerSupplier, long estimatedGetCount) throws IOException {
        if (scorerSupplier == null) {
            return new Bits.MatchNoBits(maxDoc);
        }
        Scorer scorer = scorerSupplier.get(estimatedGetCount);
        final TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
        final DocIdSetIterator iterator = twoPhase == null ? scorer.iterator() : twoPhase.approximation();
        return new Bits(){
            int previous = -1;
            boolean previousMatched = false;

            public boolean get(int index) {
                Objects.checkIndex(index, maxDoc);
                if (index < this.previous) {
                    throw new IllegalArgumentException("This Bits instance can only be consumed in order. Got called on [" + index + "] while previously called on [" + this.previous + "]");
                }
                if (index == this.previous) {
                    return this.previousMatched;
                }
                this.previous = index;
                int doc = iterator.docID();
                if (doc < index) {
                    try {
                        doc = iterator.advance(index);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot advance iterator", e);
                    }
                }
                if (index == doc) {
                    try {
                        this.previousMatched = twoPhase == null || twoPhase.matches();
                        return this.previousMatched;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot validate match", e);
                    }
                }
                this.previousMatched = false;
                return false;
            }

            public int length() {
                return maxDoc;
            }
        };
    }

    public static boolean canEarlyTerminate(Sort searchSort, Sort indexSort) {
        SortField[] fields2;
        SortField[] fields1 = searchSort.getSort();
        if (fields1.length > (fields2 = indexSort.getSort()).length) {
            return false;
        }
        return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
    }

    public static DirectoryReader wrapAllDocsLive(DirectoryReader in) throws IOException {
        return new DirectoryReaderWithAllLiveDocs(in);
    }

    private static int popCount(Bits bits) {
        assert (bits != null);
        int onBits = 0;
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            ++onBits;
        }
        return onBits;
    }

    public static NumericDocValuesField newSoftDeletesField() {
        return new NumericDocValuesField(SOFT_DELETES_FIELD, 1L);
    }

    @SuppressForbidden(reason="NoMergePolicy#INSTANCE is safe to use since we also set NoMergeScheduler#INSTANCE")
    public static IndexWriterConfig indexWriterConfigWithNoMerging(Analyzer analyzer) {
        return new IndexWriterConfig(analyzer).setMergePolicy(NoMergePolicy.INSTANCE).setMergeScheduler(NoMergeScheduler.INSTANCE);
    }

    private static final class CommitPoint
    extends IndexCommit {
        private final String segmentsFileName;
        private final Collection<String> files;
        private final Directory dir;
        private final long generation;
        private final Map<String, String> userData;
        private final int segmentCount;

        private CommitPoint(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getSegmentsFileName();
            this.dir = dir;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(true));
            this.generation = infos.getGeneration();
            this.segmentCount = infos.size();
        }

        public String toString() {
            return "DirectoryReader.ReaderCommit(" + this.segmentsFileName + ")";
        }

        public int getSegmentCount() {
            return this.segmentCount;
        }

        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public Collection<String> getFileNames() {
            return this.files;
        }

        public Directory getDirectory() {
            return this.dir;
        }

        public long getGeneration() {
            return this.generation;
        }

        public boolean isDeleted() {
            return false;
        }

        public Map<String, String> getUserData() {
            return this.userData;
        }

        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }

    @SuppressForbidden(reason="Version#parseLeniently() used in a central place")
    private static final class LenientParser {
        private LenientParser() {
        }

        public static Version parse(String toParse, Version defaultValue) {
            if (Strings.hasLength(toParse)) {
                try {
                    return Version.parseLeniently((String)toParse);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }
    }

    private static final class DirectoryReaderWithAllLiveDocs
    extends FilterDirectoryReader {
        private static final FilterDirectoryReader.SubReaderWrapper ALL_LIVE_DOCS_SUB_READER_WRAPPER = new FilterDirectoryReader.SubReaderWrapper(){

            public LeafReader wrap(LeafReader leaf) {
                SegmentReader segmentReader = Lucene.segmentReader(leaf);
                Bits hardLiveDocs = segmentReader.getHardLiveDocs();
                if (hardLiveDocs == null) {
                    return new LeafReaderWithLiveDocs(leaf, null, leaf.maxDoc());
                }
                int numDocs = segmentReader.maxDoc() - segmentReader.getSegmentInfo().getDelCount();
                assert (numDocs == Lucene.popCount(hardLiveDocs)) : numDocs + " != " + Lucene.popCount(hardLiveDocs);
                return new LeafReaderWithLiveDocs((LeafReader)segmentReader, hardLiveDocs, numDocs);
            }
        };

        DirectoryReaderWithAllLiveDocs(DirectoryReader in) throws IOException {
            super(in, ALL_LIVE_DOCS_SUB_READER_WRAPPER);
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return Lucene.wrapAllDocsLive(in);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        static final class LeafReaderWithLiveDocs
        extends SequentialStoredFieldsLeafReader {
            final Bits liveDocs;
            final int numDocs;

            LeafReaderWithLiveDocs(LeafReader in, Bits liveDocs, int numDocs) {
                super(in);
                this.liveDocs = liveDocs;
                this.numDocs = numDocs;
            }

            public Bits getLiveDocs() {
                return this.liveDocs;
            }

            public int numDocs() {
                return this.numDocs;
            }

            public IndexReader.CacheHelper getCoreCacheHelper() {
                return this.in.getCoreCacheHelper();
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }

            @Override
            protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
                return reader;
            }
        }
    }
}

