/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;

public record JoinStatus(DiscoveryNode remoteNode, long term, String message, TimeValue age) implements Writeable
{
    public JoinStatus(StreamInput in) throws IOException {
        this(new DiscoveryNode(in), in.readLong(), in.readString(), in.getTransportVersion().onOrAfter(TransportVersions.JOIN_STATUS_AGE_SERIALIZATION) ? in.readTimeValue() : new TimeValue(in.readLong(), TimeUnit.valueOf(in.readString())));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.remoteNode.writeTo(out);
        out.writeLong(this.term);
        out.writeString(this.message);
        if (out.getTransportVersion().onOrAfter(TransportVersions.JOIN_STATUS_AGE_SERIALIZATION)) {
            out.writeTimeValue(this.age);
        } else {
            out.writeLong(this.age.duration());
            out.writeString(this.age.timeUnit().name());
        }
    }
}

