/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum IndexComponentSelector {
    DATA("data"),
    FAILURES("failures");

    private final String key;
    private static final Map<String, IndexComponentSelector> REGISTRY;

    private IndexComponentSelector(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static IndexComponentSelector getByKey(String key) {
        return REGISTRY.get(key);
    }

    static {
        HashMap<String, IndexComponentSelector> registry = new HashMap<String, IndexComponentSelector>(IndexComponentSelector.values().length);
        for (IndexComponentSelector value : IndexComponentSelector.values()) {
            registry.put(value.getKey(), value);
        }
        REGISTRY = Collections.unmodifiableMap(registry);
    }
}

