/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.template.post.TransportSimulateIndexTemplateAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.SimulateBulkAction;
import org.elasticsearch.action.bulk.SimulateBulkRequest;
import org.elasticsearch.action.bulk.TransportAbstractBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.SimulateIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.SimulateIngestService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.plugins.internal.XContentMeteringParserDecorator;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class TransportSimulateBulkAction
extends TransportAbstractBulkAction {
    public static final NodeFeature SIMULATE_MAPPING_VALIDATION = new NodeFeature("simulate.mapping.validation");
    public static final NodeFeature SIMULATE_MAPPING_VALIDATION_TEMPLATES = new NodeFeature("simulate.mapping.validation.templates");
    public static final NodeFeature SIMULATE_COMPONENT_TEMPLATE_SUBSTITUTIONS = new NodeFeature("simulate.component.template.substitutions");
    public static final NodeFeature SIMULATE_INDEX_TEMPLATE_SUBSTITUTIONS = new NodeFeature("simulate.index.template.substitutions");
    private final IndicesService indicesService;
    private final NamedXContentRegistry xContentRegistry;
    private final Set<IndexSettingProvider> indexSettingProviders;

    @Inject
    public TransportSimulateBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, ActionFilters actionFilters, IndexingPressure indexingPressure, SystemIndices systemIndices, IndicesService indicesService, NamedXContentRegistry xContentRegistry, IndexSettingProviders indexSettingProviders) {
        super(SimulateBulkAction.INSTANCE, transportService, actionFilters, SimulateBulkRequest::new, threadPool, clusterService, ingestService, indexingPressure, systemIndices, threadPool::relativeTimeInNanos);
        this.indicesService = indicesService;
        this.xContentRegistry = xContentRegistry;
        this.indexSettingProviders = indexSettingProviders.getIndexSettingProviders();
    }

    @Override
    protected void doInternalExecute(Task task, BulkRequest bulkRequest, Executor executor, ActionListener<BulkResponse> listener, long relativeStartTimeNanos) throws IOException {
        assert (bulkRequest instanceof SimulateBulkRequest) : "TransportSimulateBulkAction should only ever be called with a SimulateBulkRequest but got a " + bulkRequest.getClass();
        AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        Map<String, ComponentTemplate> componentTemplateSubstitutions = bulkRequest.getComponentTemplateSubstitutions();
        Map<String, ComposableIndexTemplate> indexTemplateSubstitutions = bulkRequest.getIndexTemplateSubstitutions();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            DocWriteRequest<?> docRequest = bulkRequest.requests.get(i);
            assert (docRequest instanceof IndexRequest) : "TransportSimulateBulkAction should only ever be called with IndexRequests";
            IndexRequest request = (IndexRequest)docRequest;
            Exception mappingValidationException = this.validateMappings(componentTemplateSubstitutions, indexTemplateSubstitutions, request);
            responses.set(i, BulkItemResponse.success(0, DocWriteRequest.OpType.CREATE, new SimulateIndexResponse(request.id(), request.index(), request.version(), request.source(), request.getContentType(), request.getExecutedPipelines(), mappingValidationException)));
        }
        listener.onResponse(new BulkResponse(responses.toArray(new BulkItemResponse[responses.length()]), this.buildTookInMillis(relativeStartTimeNanos)));
    }

    private Exception validateMappings(Map<String, ComponentTemplate> componentTemplateSubstitutions, Map<String, ComposableIndexTemplate> indexTemplateSubstitutions, IndexRequest request) {
        SourceToParse sourceToParse = new SourceToParse(request.id(), request.source(), request.getContentType(), request.routing(), request.getDynamicTemplates(), XContentMeteringParserDecorator.NOOP);
        ClusterState state = this.clusterService.state();
        Exception mappingValidationException = null;
        IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(request.index());
        try {
            if (indexAbstraction != null && componentTemplateSubstitutions.isEmpty() && indexTemplateSubstitutions.isEmpty()) {
                IndexMetadata imd = state.metadata().getIndexSafe(indexAbstraction.getWriteIndex(request, state.metadata()));
                this.indicesService.withTempIndexService(imd, indexService -> {
                    indexService.mapperService().updateMapping(null, imd);
                    return IndexShard.prepareIndex(indexService.mapperService(), sourceToParse, -2L, -1L, -1L, VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY, Long.MIN_VALUE, false, request.ifSeqNo(), request.ifPrimaryTerm(), 0L);
                });
            } else {
                ClusterState simulatedState;
                String matchingTemplate;
                ClusterState.Builder simulatedClusterStateBuilder = new ClusterState.Builder(state);
                Metadata.Builder simulatedMetadata = Metadata.builder(state.metadata());
                if (indexAbstraction != null) {
                    String indexRequest = request.index();
                    assert (indexRequest != null) : "Index requests cannot be null in a simulate bulk call";
                    if (indexRequest != null) {
                        simulatedMetadata.remove(indexRequest);
                        simulatedMetadata.removeDataStream(indexRequest);
                    }
                }
                if (!componentTemplateSubstitutions.isEmpty()) {
                    HashMap<String, ComponentTemplate> updatedComponentTemplates = new HashMap<String, ComponentTemplate>();
                    updatedComponentTemplates.putAll(state.metadata().componentTemplates());
                    updatedComponentTemplates.putAll(componentTemplateSubstitutions);
                    simulatedMetadata.componentTemplates(updatedComponentTemplates);
                }
                if (!indexTemplateSubstitutions.isEmpty()) {
                    HashMap<String, ComposableIndexTemplate> updatedIndexTemplates = new HashMap<String, ComposableIndexTemplate>();
                    updatedIndexTemplates.putAll(state.metadata().templatesV2());
                    updatedIndexTemplates.putAll(indexTemplateSubstitutions);
                    simulatedMetadata.indexTemplates(updatedIndexTemplates);
                }
                if ((matchingTemplate = MetadataIndexTemplateService.findV2Template((simulatedState = simulatedClusterStateBuilder.metadata(simulatedMetadata).build()).metadata(), request.index(), false)) != null) {
                    Template template = TransportSimulateIndexTemplateAction.resolveTemplate(matchingTemplate, request.index(), simulatedState, DataStreamLifecycle.isDataStreamsLifecycleOnlyMode(this.clusterService.getSettings()), this.xContentRegistry, this.indicesService, this.systemIndices, this.indexSettingProviders);
                    CompressedXContent mappings = template.mappings();
                    if (mappings != null) {
                        MappingMetadata mappingMetadata = new MappingMetadata(mappings);
                        Settings dummySettings = Settings.builder().put("index.version.created", IndexVersion.current()).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
                        IndexMetadata imd = IndexMetadata.builder(request.index()).settings(dummySettings).putMapping(mappingMetadata).build();
                        this.indicesService.withTempIndexService(imd, indexService -> {
                            indexService.mapperService().updateMapping(null, imd);
                            return IndexShard.prepareIndex(indexService.mapperService(), sourceToParse, -2L, -1L, -1L, VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY, Long.MIN_VALUE, false, request.ifSeqNo(), request.ifPrimaryTerm(), 0L);
                        });
                    }
                } else {
                    List<IndexTemplateMetadata> matchingTemplates = MetadataIndexTemplateService.findV1Templates(simulatedState.metadata(), request.index(), false);
                    Map<String, Object> mappingsMap = MetadataCreateIndexService.parseV1Mappings("{}", matchingTemplates.stream().map(IndexTemplateMetadata::getMappings).collect(Collectors.toList()), this.xContentRegistry);
                    CompressedXContent combinedMappings = mappingsMap.isEmpty() ? null : new CompressedXContent(mappingsMap);
                    Settings dummySettings = Settings.builder().put("index.version.created", IndexVersion.current()).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
                    MappingMetadata mappingMetadata = combinedMappings == null ? null : new MappingMetadata(combinedMappings);
                    IndexMetadata imd = IndexMetadata.builder(request.index()).putMapping(mappingMetadata).settings(dummySettings).build();
                    this.indicesService.withTempIndexService(imd, indexService -> {
                        indexService.mapperService().updateMapping(null, imd);
                        return IndexShard.prepareIndex(indexService.mapperService(), sourceToParse, -2L, -1L, -1L, VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY, Long.MIN_VALUE, false, request.ifSeqNo(), request.ifPrimaryTerm(), 0L);
                    });
                }
            }
        }
        catch (Exception e) {
            mappingValidationException = e;
        }
        return mappingValidationException;
    }

    @Override
    protected IngestService getIngestService(BulkRequest request) {
        IngestService rawIngestService = super.getIngestService(request);
        return new SimulateIngestService(rawIngestService, request);
    }

    @Override
    protected Boolean resolveFailureStore(String indexName, Metadata metadata, long epochMillis) {
        return null;
    }
}

