/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.create.AutoCreateAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.rollover.LazyRolloverAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkOperation;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.FailureStoreMetrics;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.bulk.SimulateBulkRequest;
import org.elasticsearch.action.bulk.TransportAbstractBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends TransportAbstractBulkAction {
    public static final String NAME = "indices:data/write/bulk";
    public static final ActionType<BulkResponse> TYPE = new ActionType("indices:data/write/bulk");
    private static final Logger logger = LogManager.getLogger(TransportBulkAction.class);
    public static final String LAZY_ROLLOVER_ORIGIN = "lazy_rollover";
    private final FeatureService featureService;
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final OriginSettingClient rolloverClient;
    private final FailureStoreMetrics failureStoreMetrics;

    @Inject
    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, FeatureService featureService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices, FailureStoreMetrics failureStoreMetrics) {
        this(threadPool, transportService, clusterService, ingestService, featureService, client, actionFilters, indexNameExpressionResolver, indexingPressure, systemIndices, threadPool::relativeTimeInNanos, failureStoreMetrics);
    }

    public TransportBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, FeatureService featureService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices, LongSupplier relativeTimeProvider, FailureStoreMetrics failureStoreMetrics) {
        this(TYPE, BulkRequest::new, threadPool, transportService, clusterService, ingestService, featureService, client, actionFilters, indexNameExpressionResolver, indexingPressure, systemIndices, relativeTimeProvider, failureStoreMetrics);
    }

    TransportBulkAction(ActionType<BulkResponse> bulkAction, Writeable.Reader<BulkRequest> requestReader, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, FeatureService featureService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexingPressure indexingPressure, SystemIndices systemIndices, LongSupplier relativeTimeProvider, FailureStoreMetrics failureStoreMetrics) {
        super(bulkAction, transportService, actionFilters, requestReader, threadPool, clusterService, ingestService, indexingPressure, systemIndices, relativeTimeProvider);
        Objects.requireNonNull(relativeTimeProvider);
        this.featureService = featureService;
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.rolloverClient = new OriginSettingClient(client, LAZY_ROLLOVER_ORIGIN);
        this.failureStoreMetrics = failureStoreMetrics;
    }

    public static <Response extends ReplicationResponse> ActionListener<BulkResponse> unwrappingSingleItemBulkResponse(ActionListener<Response> listener) {
        return listener.delegateFailureAndWrap((l, bulkItemResponses) -> {
            assert (bulkItemResponses.getItems().length == 1) : "expected exactly one item in bulk response";
            BulkItemResponse bulkItemResponse = bulkItemResponses.getItems()[0];
            if (!bulkItemResponse.isFailed()) {
                Object response = bulkItemResponse.getResponse();
                l.onResponse(response);
            } else if (IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN.equals(bulkItemResponse.getFailure().getFailureStoreStatus())) {
                l.onFailure(bulkItemResponse.getFailure().getCause());
            } else {
                l.onFailure(new IndexDocFailureStoreStatus.ExceptionWithFailureStoreStatus(bulkItemResponse.getFailure()));
            }
        });
    }

    @Override
    protected void doInternalExecute(Task task, BulkRequest bulkRequest, Executor executor, ActionListener<BulkResponse> listener, long relativeStartTimeNanos) throws IOException {
        assert (!(bulkRequest instanceof SimulateBulkRequest)) : "TransportBulkAction should never be called with a SimulateBulkRequest";
        assert (bulkRequest.getComponentTemplateSubstitutions().isEmpty()) : "Component template substitutions are not allowed in a non-simulated bulk";
        this.trackIndexRequests(bulkRequest);
        HashMap<String, CreateIndexRequest> indicesToAutoCreate = new HashMap<String, CreateIndexRequest>();
        HashSet<String> dataStreamsToBeRolledOver = new HashSet<String>();
        HashSet<String> failureStoresToBeRolledOver = new HashSet<String>();
        this.populateMissingTargets(bulkRequest, indicesToAutoCreate, dataStreamsToBeRolledOver, failureStoresToBeRolledOver);
        this.createMissingIndicesAndIndexData(task, bulkRequest, executor, listener, indicesToAutoCreate, dataStreamsToBeRolledOver, failureStoresToBeRolledOver, relativeStartTimeNanos);
    }

    private void trackIndexRequests(BulkRequest bulkRequest) {
        Metadata metadata = this.clusterService.state().metadata();
        for (DocWriteRequest<?> request : bulkRequest.requests) {
            if (!(request instanceof IndexRequest)) continue;
            String resolvedIndexName = IndexNameExpressionResolver.resolveDateMathExpression(request.index());
            IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(resolvedIndexName);
            DataStream dataStream = DataStream.resolveDataStream(indexAbstraction, metadata);
            if (dataStream == null) continue;
            this.failureStoreMetrics.incrementTotal(dataStream.getName());
        }
    }

    private void populateMissingTargets(BulkRequest bulkRequest, Map<String, CreateIndexRequest> indicesToAutoCreate, Set<String> dataStreamsToBeRolledOver, Set<String> failureStoresToBeRolledOver) {
        ClusterState state = this.clusterService.state();
        HashMap<String, Boolean> indexExistence = new HashMap<String, Boolean>();
        Function<String, Boolean> indexExistenceComputation = index -> this.indexNameExpressionResolver.hasIndexAbstraction((String)index, state);
        boolean lazyRolloverFeature = this.featureService.clusterHasFeature(state, LazyRolloverAction.DATA_STREAM_LAZY_ROLLOVER);
        boolean lazyRolloverFailureStoreFeature = DataStream.isFailureStoreFeatureFlagEnabled();
        HashSet<String> indicesThatRequireAlias = new HashSet<String>();
        for (DocWriteRequest<?> request : bulkRequest.requests) {
            DataStream dataStream;
            IndexRequest indexRequest;
            if (request.opType() == DocWriteRequest.OpType.DELETE && request.versionType() != VersionType.EXTERNAL && request.versionType() != VersionType.EXTERNAL_GTE) continue;
            boolean writeToFailureStore = request instanceof IndexRequest && (indexRequest = (IndexRequest)request).isWriteToFailureStore();
            boolean indexExists = indexExistence.computeIfAbsent(request.index(), indexExistenceComputation);
            if (!indexExists) {
                if (request.isRequireAlias()) {
                    if (indicesThatRequireAlias.add(request.index())) {
                        indicesToAutoCreate.remove(request.index());
                    }
                } else if (!indicesThatRequireAlias.contains(request.index())) {
                    CreateIndexRequest createIndexRequest = indicesToAutoCreate.get(request.index());
                    if (createIndexRequest == null) {
                        createIndexRequest = ((CreateIndexRequest)new CreateIndexRequest(request.index()).cause("auto(bulk api)").masterNodeTimeout(bulkRequest.timeout())).requireDataStream(request.isRequireDataStream()).initializeFailureStore(writeToFailureStore);
                        indicesToAutoCreate.put(request.index(), createIndexRequest);
                    } else {
                        if (!createIndexRequest.isRequireDataStream() && request.isRequireDataStream()) {
                            createIndexRequest.requireDataStream(true);
                        }
                        if (!createIndexRequest.isInitializeFailureStore() && writeToFailureStore) {
                            createIndexRequest.initializeFailureStore(true);
                        }
                    }
                }
            }
            if (!lazyRolloverFeature || (dataStream = state.metadata().dataStreams().get(request.index())) == null) continue;
            if (!writeToFailureStore && dataStream.getBackingIndices().isRolloverOnWrite()) {
                dataStreamsToBeRolledOver.add(request.index());
                continue;
            }
            if (!lazyRolloverFailureStoreFeature || !writeToFailureStore || !dataStream.getFailureIndices().isRolloverOnWrite()) continue;
            failureStoresToBeRolledOver.add(request.index());
        }
    }

    protected void createMissingIndicesAndIndexData(final Task task, final BulkRequest bulkRequest, final Executor executor, ActionListener<BulkResponse> listener, Map<String, CreateIndexRequest> indicesToAutoCreate, Set<String> dataStreamsToBeRolledOver, Set<String> failureStoresToBeRolledOver, final long startTimeNanos) {
        final AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        if (indicesToAutoCreate.isEmpty() && dataStreamsToBeRolledOver.isEmpty() && failureStoresToBeRolledOver.isEmpty()) {
            this.executeBulk(task, bulkRequest, startTimeNanos, listener, executor, responses);
            return;
        }
        final ConcurrentHashMap<String, Exception> indicesExceptions = new ConcurrentHashMap<String, Exception>();
        final ConcurrentHashMap<String, Exception> dataStreamExceptions = new ConcurrentHashMap<String, Exception>();
        final ConcurrentHashMap<String, Exception> failureStoreExceptions = new ConcurrentHashMap<String, Exception>();
        Runnable executeBulkRunnable = () -> executor.execute(new ActionRunnable<BulkResponse>(listener){

            @Override
            protected void doRun() {
                TransportBulkAction.this.failRequestsWhenPrerequisiteActionFailed(indicesExceptions, dataStreamExceptions, failureStoreExceptions, bulkRequest, responses);
                TransportBulkAction.this.executeBulk(task, bulkRequest, startTimeNanos, this.listener, executor, responses);
            }
        });
        try (RefCountingRunnable refs = new RefCountingRunnable(executeBulkRunnable);){
            this.createIndices(indicesToAutoCreate, refs, indicesExceptions);
            this.rollOverDataStreams(bulkRequest, dataStreamsToBeRolledOver, false, refs, dataStreamExceptions);
            this.rollOverDataStreams(bulkRequest, failureStoresToBeRolledOver, true, refs, failureStoreExceptions);
        }
    }

    private void createIndices(Map<String, CreateIndexRequest> indicesToAutoCreate, RefCountingRunnable refs, final Map<String, Exception> indicesExceptions) {
        for (Map.Entry<String, CreateIndexRequest> indexEntry : indicesToAutoCreate.entrySet()) {
            final String index = indexEntry.getKey();
            this.createIndex(indexEntry.getValue(), ActionListener.releaseAfter(new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse createIndexResponse) {
                }

                @Override
                public void onFailure(Exception e) {
                    Throwable cause = ExceptionsHelper.unwrapCause(e);
                    if (!(cause instanceof ResourceAlreadyExistsException)) {
                        indicesExceptions.put(index, e);
                    }
                }
            }, refs.acquire()));
        }
    }

    void createIndex(CreateIndexRequest createIndexRequest, ActionListener<CreateIndexResponse> listener) {
        this.client.execute(AutoCreateAction.INSTANCE, createIndexRequest, listener);
    }

    private void rollOverDataStreams(BulkRequest bulkRequest, Set<String> dataStreamsToBeRolledOver, boolean targetFailureStore, RefCountingRunnable refs, final Map<String, Exception> dataStreamExceptions) {
        for (final String dataStream : dataStreamsToBeRolledOver) {
            final RolloverRequest rolloverRequest = new RolloverRequest(dataStream, null);
            rolloverRequest.masterNodeTimeout(bulkRequest.timeout);
            if (targetFailureStore) {
                rolloverRequest.setIndicesOptions(IndicesOptions.builder(rolloverRequest.indicesOptions()).selectorOptions(IndicesOptions.SelectorOptions.ONLY_FAILURES).build());
            }
            this.rollOver(rolloverRequest, ActionListener.releaseAfter(new ActionListener<RolloverResponse>(){

                @Override
                public void onResponse(RolloverResponse result) {
                    logger.debug("Data stream{} {} has {} over, the latest index is {}", (Object)(rolloverRequest.targetsFailureStore() ? " failure store" : ""), (Object)dataStream, (Object)(result.isRolledOver() ? "been successfully rolled" : "skipped rolling"), (Object)result.getNewIndex());
                }

                @Override
                public void onFailure(Exception e) {
                    dataStreamExceptions.put(dataStream, e);
                }
            }, refs.acquire()));
        }
    }

    void rollOver(RolloverRequest rolloverRequest, ActionListener<RolloverResponse> listener) {
        this.rolloverClient.execute(LazyRolloverAction.INSTANCE, rolloverRequest, listener);
    }

    private void failRequestsWhenPrerequisiteActionFailed(Map<String, Exception> indicesExceptions, Map<String, Exception> dataStreamExceptions, Map<String, Exception> failureStoreExceptions, BulkRequest bulkRequest, AtomicArray<BulkItemResponse> responses) {
        if (indicesExceptions.isEmpty() && dataStreamExceptions.isEmpty() && failureStoreExceptions.isEmpty()) {
            return;
        }
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            IndexRequest ir;
            DocWriteRequest<?> request = bulkRequest.requests.get(i);
            if (request == null) continue;
            Exception exception = indicesExceptions.get(request.index());
            if (exception == null) {
                IndexRequest indexRequest;
                exception = request instanceof IndexRequest && (indexRequest = (IndexRequest)request).isWriteToFailureStore() ? failureStoreExceptions.get(request.index()) : dataStreamExceptions.get(request.index());
            }
            if (exception == null) continue;
            IndexDocFailureStoreStatus failureStoreStatus = request instanceof IndexRequest && (ir = (IndexRequest)request).isWriteToFailureStore() ? IndexDocFailureStoreStatus.FAILED : IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN;
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.id(), exception, failureStoreStatus);
            responses.set(i, BulkItemResponse.failure(i, request.opType(), failure));
            bulkRequest.requests.set(i, null);
        }
    }

    static void prohibitAppendWritesInBackingIndices(DocWriteRequest<?> writeRequest, IndexAbstraction indexAbstraction) {
        DocWriteRequest.OpType opType = writeRequest.opType();
        if (!(opType == DocWriteRequest.OpType.CREATE || opType == DocWriteRequest.OpType.INDEX)) {
            return;
        }
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            return;
        }
        if (indexAbstraction.getParentDataStream() == null) {
            return;
        }
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (opType == DocWriteRequest.OpType.CREATE) {
            throw new IllegalArgumentException("index request with op_type=create targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
        if (writeRequest.ifPrimaryTerm() == 0L && writeRequest.ifSeqNo() == -2L) {
            throw new IllegalArgumentException("index request with op_type=index and no if_primary_term and if_seq_no set targeting backing indices is disallowed, target corresponding data stream [" + dataStream.getName() + "] instead");
        }
    }

    static void prohibitCustomRoutingOnDataStream(DocWriteRequest<?> writeRequest, IndexAbstraction indexAbstraction) {
        DataStream dataStream;
        if (indexAbstraction == null) {
            return;
        }
        if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) {
            return;
        }
        if (writeRequest.routing() != null && !(dataStream = (DataStream)indexAbstraction).isAllowCustomRouting()) {
            throw new IllegalArgumentException("index request targeting data stream [" + dataStream.getName() + "] specifies a custom routing but the [allow_custom_routing] setting was not enabled in the data stream's template.");
        }
    }

    static boolean isOnlySystem(BulkRequest request, SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices) {
        return request.getIndices().stream().allMatch(indexName -> TransportBulkAction.isSystemIndex(indicesLookup, systemIndices, indexName));
    }

    private static boolean isSystemIndex(SortedMap<String, IndexAbstraction> indicesLookup, SystemIndices systemIndices, String indexName) {
        IndexAbstraction abstraction = (IndexAbstraction)indicesLookup.get(indexName);
        if (abstraction != null) {
            return abstraction.isSystem();
        }
        return systemIndices.isSystemIndex(indexName);
    }

    void executeBulk(Task task, BulkRequest bulkRequest, long startTimeNanos, ActionListener<BulkResponse> listener, Executor executor, AtomicArray<BulkItemResponse> responses) {
        new BulkOperation(task, this.threadPool, executor, this.clusterService, bulkRequest, this.client, responses, this.indexNameExpressionResolver, this.relativeTimeNanosProvider, startTimeNanos, listener, this.failureStoreMetrics).run();
    }

    static Boolean resolveFailureInternal(String indexName, Metadata metadata, long epochMillis) {
        if (!DataStream.isFailureStoreFeatureFlagEnabled()) {
            return null;
        }
        Boolean resolution = TransportBulkAction.resolveFailureStoreFromMetadata(indexName, metadata, epochMillis);
        if (resolution != null) {
            return resolution;
        }
        return TransportBulkAction.resolveFailureStoreFromTemplate(indexName, metadata);
    }

    @Override
    protected Boolean resolveFailureStore(String indexName, Metadata metadata, long time) {
        return TransportBulkAction.resolveFailureInternal(indexName, metadata, time);
    }

    private static Boolean resolveFailureStoreFromMetadata(String indexName, Metadata metadata, long epochMillis) {
        if (indexName == null) {
            return null;
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(IndexNameExpressionResolver.resolveDateMathExpression(indexName, epochMillis));
        if (indexAbstraction == null || !indexAbstraction.isDataStreamRelated()) {
            return null;
        }
        DataStream targetDataStream = DataStream.resolveDataStream(indexAbstraction, metadata);
        return targetDataStream != null && targetDataStream.isFailureStoreEnabled();
    }

    private static Boolean resolveFailureStoreFromTemplate(String indexName, Metadata metadata) {
        ComposableIndexTemplate composableIndexTemplate;
        if (indexName == null) {
            return null;
        }
        String template = MetadataIndexTemplateService.findV2Template(metadata, indexName, false);
        if (template != null && (composableIndexTemplate = metadata.templatesV2().get(template)).getDataStreamTemplate() != null) {
            return composableIndexTemplate.getDataStreamTemplate().hasFailureStore();
        }
        return null;
    }
}

