/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class SimulateBulkRequest
extends BulkRequest {
    private final Map<String, Map<String, Object>> pipelineSubstitutions;
    private final Map<String, Map<String, Object>> componentTemplateSubstitutions;
    private final Map<String, Map<String, Object>> indexTemplateSubstitutions;

    public SimulateBulkRequest(@Nullable Map<String, Map<String, Object>> pipelineSubstitutions, @Nullable Map<String, Map<String, Object>> componentTemplateSubstitutions, @Nullable Map<String, Map<String, Object>> indexTemplateSubstitutions) {
        this.pipelineSubstitutions = pipelineSubstitutions;
        this.componentTemplateSubstitutions = componentTemplateSubstitutions;
        this.indexTemplateSubstitutions = indexTemplateSubstitutions;
    }

    public SimulateBulkRequest(StreamInput in) throws IOException {
        super(in);
        this.pipelineSubstitutions = (Map)in.readGenericValue();
        this.componentTemplateSubstitutions = in.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_COMPONENT_TEMPLATES_SUBSTITUTIONS) ? (Map)in.readGenericValue() : Map.of();
        this.indexTemplateSubstitutions = in.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_INDEX_TEMPLATES_SUBSTITUTIONS) ? (Map)in.readGenericValue() : Map.of();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeGenericValue(this.pipelineSubstitutions);
        if (out.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_COMPONENT_TEMPLATES_SUBSTITUTIONS)) {
            out.writeGenericValue(this.componentTemplateSubstitutions);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.SIMULATE_INDEX_TEMPLATES_SUBSTITUTIONS)) {
            out.writeGenericValue(this.indexTemplateSubstitutions);
        }
    }

    public Map<String, Map<String, Object>> getPipelineSubstitutions() {
        return this.pipelineSubstitutions;
    }

    @Override
    public boolean isSimulated() {
        return true;
    }

    @Override
    public Map<String, ComponentTemplate> getComponentTemplateSubstitutions() throws IOException {
        if (this.componentTemplateSubstitutions == null) {
            return Map.of();
        }
        HashMap<String, ComponentTemplate> result = new HashMap<String, ComponentTemplate>(this.componentTemplateSubstitutions.size());
        for (Map.Entry<String, Map<String, Object>> rawEntry : this.componentTemplateSubstitutions.entrySet()) {
            result.put(rawEntry.getKey(), SimulateBulkRequest.convertRawTemplateToComponentTemplate(rawEntry.getValue()));
        }
        return result;
    }

    @Override
    public Map<String, ComposableIndexTemplate> getIndexTemplateSubstitutions() throws IOException {
        if (this.indexTemplateSubstitutions == null) {
            return Map.of();
        }
        HashMap<String, ComposableIndexTemplate> result = new HashMap<String, ComposableIndexTemplate>(this.indexTemplateSubstitutions.size());
        for (Map.Entry<String, Map<String, Object>> rawEntry : this.indexTemplateSubstitutions.entrySet()) {
            result.put(rawEntry.getKey(), SimulateBulkRequest.convertRawTemplateToIndexTemplate(rawEntry.getValue()));
        }
        return result;
    }

    private static ComponentTemplate convertRawTemplateToComponentTemplate(Map<String, Object> rawTemplate) throws IOException {
        ComponentTemplate componentTemplate;
        try (XContentParser parser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, rawTemplate);){
            componentTemplate = ComponentTemplate.parse(parser);
        }
        return componentTemplate;
    }

    private static ComposableIndexTemplate convertRawTemplateToIndexTemplate(Map<String, Object> rawTemplate) throws IOException {
        ComposableIndexTemplate indexTemplate;
        try (XContentParser parser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, rawTemplate);){
            indexTemplate = ComposableIndexTemplate.parse(parser);
        }
        return indexTemplate;
    }

    @Override
    public BulkRequest shallowClone() {
        SimulateBulkRequest bulkRequest = new SimulateBulkRequest(this.pipelineSubstitutions, this.componentTemplateSubstitutions, this.indexTemplateSubstitutions);
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        bulkRequest.waitForActiveShards(this.waitForActiveShards());
        bulkRequest.timeout(this.timeout());
        bulkRequest.pipeline(this.pipeline());
        bulkRequest.routing(this.routing());
        bulkRequest.requireAlias(this.requireAlias());
        bulkRequest.requireDataStream(this.requireDataStream());
        return bulkRequest;
    }
}

