/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.AnalysisStats;
import org.elasticsearch.action.admin.cluster.stats.CCSTelemetrySnapshot;
import org.elasticsearch.action.admin.cluster.stats.CCSUsageTelemetry;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.MappingStats;
import org.elasticsearch.action.admin.cluster.stats.RemoteClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.RemoteClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.RepositoryUsageStats;
import org.elasticsearch.action.admin.cluster.stats.SearchUsageStats;
import org.elasticsearch.action.admin.cluster.stats.TransportRemoteClusterStatsAction;
import org.elasticsearch.action.admin.cluster.stats.VersionStats;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.CancellableFanOut;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.ClusterSnapshotStats;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CancellableSingleObjectCache;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.RemoteClusterConnection;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.usage.UsageService;

public class TransportClusterStatsAction
extends TransportNodesAction<ClusterStatsRequest, ClusterStatsResponse, ClusterStatsNodeRequest, ClusterStatsNodeResponse, SubscribableListener<AdditionalStats>> {
    public static final ActionType<ClusterStatsResponse> TYPE = new ActionType("cluster:monitor/stats");
    private static final CommonStatsFlags SHARD_STATS_FLAGS = new CommonStatsFlags(CommonStatsFlags.Flag.Docs, CommonStatsFlags.Flag.Store, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.Completion, CommonStatsFlags.Flag.Segments, CommonStatsFlags.Flag.DenseVector, CommonStatsFlags.Flag.SparseVector);
    private static final Logger logger = LogManager.getLogger(TransportClusterStatsAction.class);
    private final Settings settings;
    private final NodeService nodeService;
    private final IndicesService indicesService;
    private final RepositoriesService repositoriesService;
    private final SearchUsageHolder searchUsageHolder;
    private final CCSUsageTelemetry ccsUsageHolder;
    private final Executor clusterStateStatsExecutor;
    private final MetadataStatsCache<MappingStats> mappingStatsCache;
    private final MetadataStatsCache<AnalysisStats> analysisStatsCache;
    private final RemoteClusterService remoteClusterService;
    private final TransportRemoteClusterStatsAction remoteClusterStatsAction;

    @Inject
    public TransportClusterStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, IndicesService indicesService, RepositoriesService repositoriesService, UsageService usageService, ActionFilters actionFilters, Settings settings, TransportRemoteClusterStatsAction remoteClusterStatsAction) {
        super(TYPE.name(), clusterService, transportService, actionFilters, ClusterStatsNodeRequest::new, threadPool.executor("management"));
        this.nodeService = nodeService;
        this.indicesService = indicesService;
        this.repositoriesService = repositoriesService;
        this.searchUsageHolder = usageService.getSearchUsageHolder();
        this.ccsUsageHolder = usageService.getCcsUsageHolder();
        this.clusterStateStatsExecutor = threadPool.executor("management");
        this.mappingStatsCache = new MetadataStatsCache<MappingStats>(threadPool.getThreadContext(), MappingStats::of);
        this.analysisStatsCache = new MetadataStatsCache<AnalysisStats>(threadPool.getThreadContext(), AnalysisStats::of);
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.settings = settings;
        this.remoteClusterStatsAction = remoteClusterStatsAction;
    }

    @Override
    protected SubscribableListener<AdditionalStats> createActionContext(Task task, ClusterStatsRequest request) {
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        SubscribableListener<AdditionalStats> additionalStatsListener = new SubscribableListener<AdditionalStats>();
        if (!request.isRemoteStats()) {
            AdditionalStats additionalStats = new AdditionalStats();
            additionalStats.compute(cancellableTask, request, additionalStatsListener);
        } else {
            additionalStatsListener.onResponse(null);
        }
        return additionalStatsListener;
    }

    @Override
    protected void newResponseAsync(Task task, ClusterStatsRequest request, SubscribableListener<AdditionalStats> additionalStatsListener, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures, ActionListener<ClusterStatsResponse> listener) {
        assert (Transports.assertNotTransportThread("Computation of mapping/analysis stats runs expensive computations on mappings found in the cluster state that are too slow for a transport thread"));
        assert (ThreadPool.assertCurrentThreadPool("management"));
        additionalStatsListener.andThenApply(additionalStats -> request.isRemoteStats() ? new ClusterStatsResponse(System.currentTimeMillis(), this.clusterService.state().metadata().clusterUUID(), this.clusterService.getClusterName(), responses, List.of(), null, null, null, null, Map.of()) : new ClusterStatsResponse(System.currentTimeMillis(), additionalStats.clusterUUID(), this.clusterService.getClusterName(), responses, failures, additionalStats.mappingStats(), additionalStats.analysisStats(), VersionStats.of(this.clusterService.state().metadata(), responses), additionalStats.clusterSnapshotStats(), additionalStats.getRemoteStats())).addListener(listener);
    }

    @Override
    protected ClusterStatsResponse newResponse(ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures) {
        assert (false);
        throw new UnsupportedOperationException("use newResponseAsync instead");
    }

    @Override
    protected ClusterStatsNodeRequest newNodeRequest(ClusterStatsRequest request) {
        return new ClusterStatsNodeRequest();
    }

    @Override
    protected ClusterStatsNodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    protected ClusterStatsNodeResponse nodeOperation(ClusterStatsNodeRequest nodeRequest, Task task) {
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        NodeInfo nodeInfo = this.nodeService.info(true, true, false, true, false, true, false, false, true, false, false, false);
        NodeStats nodeStats = this.nodeService.stats(CommonStatsFlags.NONE, false, true, true, true, false, true, false, false, false, false, false, true, false, false, false, false);
        ArrayList<ShardStats> shardsStats = new ArrayList<ShardStats>();
        for (IndexService indexService : this.indicesService) {
            for (IndexShard indexShard : indexService) {
                RetentionLeaseStats retentionLeaseStats;
                SeqNoStats seqNoStats;
                CommitStats commitStats;
                cancellableTask.ensureNotCancelled();
                if (indexShard.routingEntry() == null || !indexShard.routingEntry().active()) continue;
                try {
                    commitStats = indexShard.commitStats();
                    seqNoStats = indexShard.seqNoStats();
                    retentionLeaseStats = indexShard.getRetentionLeaseStats();
                }
                catch (AlreadyClosedException e) {
                    commitStats = null;
                    seqNoStats = null;
                    retentionLeaseStats = null;
                }
                shardsStats.add(new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), CommonStats.getShardLevelStats(this.indicesService.getIndicesQueryCache(), indexShard, SHARD_STATS_FLAGS), commitStats, seqNoStats, retentionLeaseStats, indexShard.isSearchIdle(), indexShard.searchIdleTime()));
            }
        }
        ClusterState clusterState = this.clusterService.state();
        ClusterHealthStatus clusterStatus = clusterState.nodes().isLocalNodeElectedMaster() ? new ClusterStateHealth(clusterState).getStatus() : null;
        SearchUsageStats searchUsageStats = this.searchUsageHolder.getSearchUsageStats();
        RepositoryUsageStats repositoryUsageStats = this.repositoriesService.getUsageStats();
        CCSTelemetrySnapshot ccsTelemetry = this.ccsUsageHolder.getCCSTelemetrySnapshot();
        return new ClusterStatsNodeResponse(nodeInfo.getNode(), clusterStatus, nodeInfo, nodeStats, shardsStats.toArray(new ShardStats[shardsStats.size()]), searchUsageStats, repositoryUsageStats, ccsTelemetry);
    }

    private boolean doRemotes(ClusterStatsRequest request) {
        return SearchService.CCS_COLLECT_TELEMETRY.get(this.settings) != false && request.doRemotes();
    }

    private static class MetadataStatsCache<T>
    extends CancellableSingleObjectCache<Metadata, Long, T> {
        private final BiFunction<Metadata, Runnable, T> function;

        MetadataStatsCache(ThreadContext threadContext, BiFunction<Metadata, Runnable, T> function) {
            super(threadContext);
            this.function = function;
        }

        @Override
        protected void refresh(Metadata metadata, Runnable ensureNotCancelled, BooleanSupplier supersedeIfStale, ActionListener<T> listener) {
            ActionListener.completeWith(listener, () -> this.function.apply(metadata, ensureNotCancelled));
        }

        @Override
        protected Long getKey(Metadata indexMetadata) {
            return indexMetadata.version();
        }

        @Override
        protected boolean isFresh(Long currentKey, Long newKey) {
            return newKey <= currentKey;
        }
    }

    public final class AdditionalStats {
        private String clusterUUID;
        private MappingStats mappingStats;
        private AnalysisStats analysisStats;
        private ClusterSnapshotStats clusterSnapshotStats;
        private Map<String, ClusterStatsResponse.RemoteClusterStats> remoteStats;

        void compute(CancellableTask task, ClusterStatsRequest request, ActionListener<AdditionalStats> listener) {
            TransportClusterStatsAction.this.clusterStateStatsExecutor.execute(ActionRunnable.wrap(listener, l -> {
                task.ensureNotCancelled();
                this.internalCompute(task, request, TransportClusterStatsAction.this.clusterService.state(), TransportClusterStatsAction.this.mappingStatsCache, TransportClusterStatsAction.this.analysisStatsCache, task::isCancelled, TransportClusterStatsAction.this.clusterService.threadPool().absoluteTimeInMillis(), l.map(ignored -> this));
            }));
        }

        private void internalCompute(CancellableTask task, ClusterStatsRequest request, ClusterState clusterState, MetadataStatsCache<MappingStats> mappingStatsCache, MetadataStatsCache<AnalysisStats> analysisStatsCache, BooleanSupplier isCancelledSupplier, long absoluteTimeInMillis, ActionListener<Void> listener) {
            try (RefCountingListener listeners = new RefCountingListener(listener);){
                Metadata metadata = clusterState.metadata();
                this.clusterUUID = metadata.clusterUUID();
                mappingStatsCache.get(metadata, isCancelledSupplier, listeners.acquire(s -> {
                    this.mappingStats = s;
                }));
                analysisStatsCache.get(metadata, isCancelledSupplier, listeners.acquire(s -> {
                    this.analysisStats = s;
                }));
                this.clusterSnapshotStats = ClusterSnapshotStats.of(clusterState, absoluteTimeInMillis);
                if (TransportClusterStatsAction.this.doRemotes(request)) {
                    Set<String> remotes = TransportClusterStatsAction.this.remoteClusterService.getRegisteredRemoteClusterNames();
                    if (remotes.isEmpty()) {
                        this.remoteStats = Map.of();
                    } else {
                        new RemoteStatsFanout(task, TransportClusterStatsAction.this.transportService.getThreadPool().executor("search_coordination")).start(task, remotes, listeners.acquire(s -> {
                            this.remoteStats = s;
                        }));
                    }
                }
            }
        }

        String clusterUUID() {
            return this.clusterUUID;
        }

        MappingStats mappingStats() {
            return this.mappingStats;
        }

        AnalysisStats analysisStats() {
            return this.analysisStats;
        }

        ClusterSnapshotStats clusterSnapshotStats() {
            return this.clusterSnapshotStats;
        }

        public Map<String, ClusterStatsResponse.RemoteClusterStats> getRemoteStats() {
            return this.remoteStats;
        }
    }

    public static class ClusterStatsNodeRequest
    extends TransportRequest {
        ClusterStatsNodeRequest() {
        }

        public ClusterStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            TransportNodesAction.skipLegacyNodesRequestHeader(TransportVersions.DROP_UNUSED_NODES_REQUESTS, in);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            TransportNodesAction.sendLegacyNodesRequestHeader(TransportVersions.DROP_UNUSED_NODES_REQUESTS, out);
        }
    }

    private class RemoteStatsFanout
    extends CancellableFanOut<String, RemoteClusterStatsResponse, Map<String, ClusterStatsResponse.RemoteClusterStats>> {
        private final Executor requestExecutor;
        private final TaskId taskId;
        private Map<String, ClusterStatsResponse.RemoteClusterStats> remoteClustersStats;

        RemoteStatsFanout(Task task, Executor requestExecutor) {
            this.requestExecutor = requestExecutor;
            this.taskId = new TaskId(TransportClusterStatsAction.this.clusterService.getNodeName(), task.getId());
        }

        @Override
        protected void sendItemRequest(String clusterAlias, ActionListener<RemoteClusterStatsResponse> listener) {
            RemoteClusterClient remoteClusterClient = TransportClusterStatsAction.this.remoteClusterService.getRemoteClusterClient(clusterAlias, this.requestExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_IF_DISCONNECTED);
            RemoteClusterStatsRequest remoteRequest = new RemoteClusterStatsRequest();
            remoteRequest.setParentTask(this.taskId);
            remoteClusterClient.getConnection(remoteRequest, listener.delegateFailureAndWrap((responseListener, connection) -> {
                if (connection.getTransportVersion().before(TransportVersions.CCS_REMOTE_TELEMETRY_STATS)) {
                    responseListener.onResponse(null);
                } else {
                    remoteClusterClient.execute((Transport.Connection)connection, TransportRemoteClusterStatsAction.REMOTE_TYPE, remoteRequest, responseListener);
                }
            }));
        }

        @Override
        protected void onItemResponse(String clusterAlias, RemoteClusterStatsResponse response) {
            if (response != null) {
                this.remoteClustersStats.computeIfPresent(clusterAlias, (k, v) -> v.acceptResponse(response));
            }
        }

        @Override
        protected void onItemFailure(String clusterAlias, Exception e) {
            logger.warn("Failed to get remote cluster stats for [{}]: {}", (Object)clusterAlias, (Object)e);
        }

        void start(Task task, Collection<String> remotes, ActionListener<Map<String, ClusterStatsResponse.RemoteClusterStats>> listener) {
            this.remoteClustersStats = remotes.stream().collect(Collectors.toConcurrentMap(r -> r, this::makeRemoteClusterStats));
            super.run(task, remotes.iterator(), listener);
        }

        ClusterStatsResponse.RemoteClusterStats makeRemoteClusterStats(String clusterAlias) {
            RemoteClusterConnection remoteConnection = TransportClusterStatsAction.this.remoteClusterService.getRemoteClusterConnection(clusterAlias);
            RemoteConnectionInfo remoteConnectionInfo = remoteConnection.getConnectionInfo();
            Compression.Enabled compression = RemoteClusterService.REMOTE_CLUSTER_COMPRESS.getConcreteSettingForNamespace(clusterAlias).get(TransportClusterStatsAction.this.settings);
            return new ClusterStatsResponse.RemoteClusterStats(remoteConnectionInfo.getModeInfo().modeName(), remoteConnection.isSkipUnavailable(), compression.toString());
        }

        @Override
        protected Map<String, ClusterStatsResponse.RemoteClusterStats> onCompletion() {
            return this.remoteClustersStats;
        }
    }
}

