/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.cleanup;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class CleanupRepositoryRequest
extends AcknowledgedRequest<CleanupRepositoryRequest> {
    private String repository;

    public CleanupRepositoryRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout, String repository) {
        super(masterNodeTimeout, ackTimeout);
        this.repository = repository;
    }

    public static CleanupRepositoryRequest readFrom(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter(TransportVersions.SNAPSHOT_REQUEST_TIMEOUTS)) {
            return new CleanupRepositoryRequest(in);
        }
        return new CleanupRepositoryRequest(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS, in);
    }

    private CleanupRepositoryRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
    }

    public CleanupRepositoryRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout, StreamInput in) throws IOException {
        super(masterNodeTimeout, ackTimeout);
        this.repository = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.SNAPSHOT_REQUEST_TIMEOUTS)) {
            super.writeTo(out);
        }
        out.writeString(this.repository);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is null", null);
        }
        return validationException;
    }

    public String name() {
        return this.repository;
    }

    public void name(String repository) {
        this.repository = repository;
    }
}

