/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.allocation.TransportGetAllocationStatsAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStats;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public class TransportNodesStatsAction
extends TransportNodesAction<NodesStatsRequest, NodesStatsResponse, NodeStatsRequest, NodeStats, Void> {
    public static final ActionType<NodesStatsResponse> TYPE = new ActionType("cluster:monitor/nodes/stats");
    private final NodeService nodeService;
    private final NodeClient client;

    @Inject
    public TransportNodesStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeService nodeService, NodeClient client) {
        super(TYPE.name(), clusterService, transportService, actionFilters, NodeStatsRequest::new, threadPool.executor("management"));
        this.nodeService = nodeService;
        this.client = client;
    }

    @Override
    protected NodesStatsResponse newResponse(NodesStatsRequest request, List<NodeStats> responses, List<FailedNodeException> failures) {
        return new NodesStatsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected void newResponseAsync(Task task, NodesStatsRequest request, Void actionContext, List<NodeStats> responses, List<FailedNodeException> failures, ActionListener<NodesStatsResponse> listener) {
        EnumSet<NodesStatsRequestParameters.Metric> metrics = request.getNodesStatsRequestParameters().requestedMetrics();
        if (metrics.contains((Object)NodesStatsRequestParameters.Metric.FS) || metrics.contains((Object)NodesStatsRequestParameters.Metric.ALLOCATIONS)) {
            this.client.execute(TransportGetAllocationStatsAction.TYPE, new TransportGetAllocationStatsAction.Request(Objects.requireNonNullElse(request.timeout(), RestUtils.REST_MASTER_TIMEOUT_DEFAULT), new TaskId(this.clusterService.localNode().getId(), task.getId()), metrics), listener.delegateFailure((l, r) -> ActionListener.respondAndRelease(l, this.newResponse(request, TransportNodesStatsAction.merge(responses, r.getNodeAllocationStats(), r.getDiskThresholdSettings()), failures))));
        } else {
            ActionListener.run(listener, l -> ActionListener.respondAndRelease(l, this.newResponse(request, responses, failures)));
        }
    }

    private static List<NodeStats> merge(List<NodeStats> responses, Map<String, NodeAllocationStats> allocationStats, DiskThresholdSettings masterThresholdSettings) {
        return responses.stream().map(response -> response.withNodeAllocationStats((NodeAllocationStats)allocationStats.get(response.getNode().getId()), masterThresholdSettings)).toList();
    }

    @Override
    protected NodeStatsRequest newNodeRequest(NodesStatsRequest request) {
        return new NodeStatsRequest(request);
    }

    @Override
    protected NodeStats newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        assert (Transports.assertNotTransportThread("deserializing node stats is too expensive for a transport thread"));
        return new NodeStats(in);
    }

    @Override
    protected NodeStats nodeOperation(NodeStatsRequest request, Task task) {
        assert (task instanceof CancellableTask);
        NodesStatsRequestParameters nodesStatsRequestParameters = request.getNodesStatsRequestParameters();
        EnumSet<NodesStatsRequestParameters.Metric> metrics = nodesStatsRequestParameters.requestedMetrics();
        return this.nodeService.stats(nodesStatsRequestParameters.indices(), nodesStatsRequestParameters.includeShardsStats(), metrics.contains((Object)NodesStatsRequestParameters.Metric.OS), metrics.contains((Object)NodesStatsRequestParameters.Metric.PROCESS), metrics.contains((Object)NodesStatsRequestParameters.Metric.JVM), metrics.contains((Object)NodesStatsRequestParameters.Metric.THREAD_POOL), metrics.contains((Object)NodesStatsRequestParameters.Metric.FS), metrics.contains((Object)NodesStatsRequestParameters.Metric.TRANSPORT), metrics.contains((Object)NodesStatsRequestParameters.Metric.HTTP), metrics.contains((Object)NodesStatsRequestParameters.Metric.BREAKER), metrics.contains((Object)NodesStatsRequestParameters.Metric.SCRIPT), metrics.contains((Object)NodesStatsRequestParameters.Metric.DISCOVERY), metrics.contains((Object)NodesStatsRequestParameters.Metric.INGEST), metrics.contains((Object)NodesStatsRequestParameters.Metric.ADAPTIVE_SELECTION), metrics.contains((Object)NodesStatsRequestParameters.Metric.SCRIPT_CACHE), metrics.contains((Object)NodesStatsRequestParameters.Metric.INDEXING_PRESSURE), metrics.contains((Object)NodesStatsRequestParameters.Metric.REPOSITORIES));
    }

    public static class NodeStatsRequest
    extends TransportRequest {
        private final NodesStatsRequestParameters nodesStatsRequestParameters;

        public NodeStatsRequest(StreamInput in) throws IOException {
            super(in);
            TransportNodesAction.skipLegacyNodesRequestHeader(TransportVersions.V_8_13_0, in);
            this.nodesStatsRequestParameters = new NodesStatsRequestParameters(in);
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) && in.getTransportVersion().before(TransportVersions.DROP_UNUSED_NODES_IDS)) {
                in.readStringArray();
            }
        }

        NodeStatsRequest(NodesStatsRequest request) {
            this.nodesStatsRequestParameters = request.getNodesStatsRequestParameters();
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers){

                @Override
                public String getDescription() {
                    return Strings.format("metrics=%s, flags=%s", nodesStatsRequestParameters.requestedMetrics().toString(), Arrays.toString((Object[])nodesStatsRequestParameters.indices().getFlags()));
                }
            };
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            TransportNodesAction.sendLegacyNodesRequestHeader(TransportVersions.V_8_13_0, out);
            this.nodesStatsRequestParameters.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) && out.getTransportVersion().before(TransportVersions.DROP_UNUSED_NODES_IDS)) {
                out.writeStringArray(Strings.EMPTY_ARRAY);
            }
        }

        public NodesStatsRequestParameters getNodesStatsRequestParameters() {
            return this.nodesStatsRequestParameters;
        }
    }
}

