/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.migration;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.migration.GetFeatureUpgradeStatusResponse;
import org.elasticsearch.action.admin.cluster.migration.PostFeatureUpgradeRequest;
import org.elasticsearch.action.admin.cluster.migration.PostFeatureUpgradeResponse;
import org.elasticsearch.action.admin.cluster.migration.TransportGetFeatureUpgradeStatusAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.upgrades.SystemIndexMigrationTaskParams;

public class TransportPostFeatureUpgradeAction
extends TransportMasterNodeAction<PostFeatureUpgradeRequest, PostFeatureUpgradeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPostFeatureUpgradeAction.class);
    private final SystemIndices systemIndices;
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportPostFeatureUpgradeAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices, PersistentTasksService persistentTasksService) {
        super("cluster:admin/migration/post_system_feature", transportService, clusterService, threadPool, actionFilters, PostFeatureUpgradeRequest::new, indexNameExpressionResolver, PostFeatureUpgradeResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndices = systemIndices;
        this.persistentTasksService = persistentTasksService;
    }

    @Override
    protected void masterOperation(Task task, PostFeatureUpgradeRequest request, ClusterState state, ActionListener<PostFeatureUpgradeResponse> listener) throws Exception {
        EnumSet<GetFeatureUpgradeStatusResponse.UpgradeStatus> upgradableStatuses = EnumSet.of(GetFeatureUpgradeStatusResponse.UpgradeStatus.MIGRATION_NEEDED, GetFeatureUpgradeStatusResponse.UpgradeStatus.ERROR);
        List<PostFeatureUpgradeResponse.Feature> featuresToMigrate = this.systemIndices.getFeatures().stream().map(feature -> TransportGetFeatureUpgradeStatusAction.getFeatureUpgradeStatus(state, feature)).filter(status -> upgradableStatuses.contains((Object)status.getUpgradeStatus())).map(GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus::getFeatureName).map(PostFeatureUpgradeResponse.Feature::new).sorted(Comparator.comparing(PostFeatureUpgradeResponse.Feature::getFeatureName)).toList();
        if (!featuresToMigrate.isEmpty()) {
            this.persistentTasksService.sendStartRequest("upgrade-system-indices", "upgrade-system-indices", new SystemIndexMigrationTaskParams(), null, ActionListener.wrap(startedTask -> listener.onResponse(new PostFeatureUpgradeResponse(true, featuresToMigrate, null, null)), ex -> {
                logger.error("failed to start system index upgrade task", (Throwable)ex);
                listener.onResponse(new PostFeatureUpgradeResponse(false, null, null, new ElasticsearchException((Throwable)ex)));
            }));
        } else {
            listener.onResponse(new PostFeatureUpgradeResponse(false, null, "No system indices require migration", null));
        }
    }

    @Override
    protected ClusterBlockException checkBlock(PostFeatureUpgradeRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

