/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.settings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class RateLimitSettings
implements Writeable,
ToXContentFragment {
    public static final String FIELD_NAME = "rate_limit";
    public static final String REQUESTS_PER_MINUTE_FIELD = "requests_per_minute";
    private final long requestsPerTimeUnit;
    private final TimeUnit timeUnit;

    public static RateLimitSettings of(Map<String, Object> map, RateLimitSettings defaultValue, ValidationException validationException, String serviceName, ConfigurationParseContext context) {
        Map<String, Object> settings = ServiceUtils.removeFromMapOrDefaultEmpty(map, FIELD_NAME);
        Long requestsPerMinute = ServiceUtils.extractOptionalPositiveLong(settings, REQUESTS_PER_MINUTE_FIELD, FIELD_NAME, validationException);
        if (ConfigurationParseContext.isRequestContext(context)) {
            ServiceUtils.throwIfNotEmptyMap(settings, serviceName);
        }
        return requestsPerMinute == null ? defaultValue : new RateLimitSettings(requestsPerMinute);
    }

    public RateLimitSettings(long requestsPerMinute) {
        this(requestsPerMinute, TimeUnit.MINUTES);
    }

    public RateLimitSettings(long requestsPerTimeUnit, TimeUnit timeUnit) {
        if (requestsPerTimeUnit <= 0L) {
            throw new IllegalArgumentException("requests per minute must be positive");
        }
        this.requestsPerTimeUnit = requestsPerTimeUnit;
        this.timeUnit = Objects.requireNonNull(timeUnit);
    }

    public RateLimitSettings(StreamInput in) throws IOException {
        this.requestsPerTimeUnit = in.readVLong();
        this.timeUnit = TimeUnit.MINUTES;
    }

    public long requestsPerTimeUnit() {
        return this.requestsPerTimeUnit;
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(FIELD_NAME);
        builder.field(REQUESTS_PER_MINUTE_FIELD, this.requestsPerTimeUnit);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.requestsPerTimeUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateLimitSettings that = (RateLimitSettings)o;
        return Objects.equals(this.requestsPerTimeUnit, that.requestsPerTimeUnit) && Objects.equals((Object)this.timeUnit, (Object)that.timeUnit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestsPerTimeUnit, this.timeUnit});
    }
}

