/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.settings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public record DefaultSecretSettings(SecureString apiKey) implements SecretSettings,
ApiKeySecrets
{
    public static final String NAME = "default_secret_settings";
    static final String API_KEY = "api_key";

    public DefaultSecretSettings {
        Objects.requireNonNull(apiKey);
    }

    public DefaultSecretSettings(StreamInput in) throws IOException {
        this(in.readSecureString());
    }

    public static DefaultSecretSettings fromMap(@Nullable Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        SecureString secureApiToken = ServiceUtils.extractRequiredSecureString(map, API_KEY, "secret_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new DefaultSecretSettings(secureApiToken);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(API_KEY, this.apiKey.toString());
        builder.endObject();
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeSecureString(this.apiKey);
    }

    public SecretSettings newSecretSettings(Map<String, Object> newSecrets) {
        return DefaultSecretSettings.fromMap(new HashMap<String, Object>(newSecrets));
    }
}

