/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.embeddings;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.OpenAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class OpenAiEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
OpenAiRateLimitServiceSettings {
    public static final String NAME = "openai_service_settings";
    static final String DIMENSIONS_SET_BY_USER = "dimensions_set_by_user";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(3000L);
    private final String modelId;
    private final URI uri;
    private final String organizationId;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;
    private final Boolean dimensionsSetByUser;
    private final RateLimitSettings rateLimitSettings;

    public static OpenAiEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationParseContext.REQUEST -> OpenAiEmbeddingsServiceSettings.fromRequestMap(map);
            case ConfigurationParseContext.PERSISTENT -> OpenAiEmbeddingsServiceSettings.fromPersistentMap(map);
        };
    }

    private static OpenAiEmbeddingsServiceSettings fromPersistentMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        CommonFields commonFields = OpenAiEmbeddingsServiceSettings.fromMap(map, validationException, ConfigurationParseContext.PERSISTENT);
        Boolean dimensionsSetByUser = ServiceUtils.removeAsType(map, DIMENSIONS_SET_BY_USER, Boolean.class);
        if (dimensionsSetByUser == null) {
            dimensionsSetByUser = Boolean.FALSE;
        }
        return new OpenAiEmbeddingsServiceSettings(commonFields, dimensionsSetByUser);
    }

    private static OpenAiEmbeddingsServiceSettings fromRequestMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        CommonFields commonFields = OpenAiEmbeddingsServiceSettings.fromMap(map, validationException, ConfigurationParseContext.REQUEST);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenAiEmbeddingsServiceSettings(commonFields, commonFields.dimensions != null);
    }

    private static CommonFields fromMap(Map<String, Object> map, ValidationException validationException, ConfigurationParseContext context) {
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        String organizationId = ServiceUtils.extractOptionalString(map, "organization_id", "service_settings", validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "openai", context);
        return new CommonFields(modelId, uri, organizationId, similarity, maxInputTokens, dims, rateLimitSettings);
    }

    public OpenAiEmbeddingsServiceSettings(String modelId, @Nullable URI uri, @Nullable String organizationId, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, Boolean dimensionsSetByUser, @Nullable RateLimitSettings rateLimitSettings) {
        this.uri = uri;
        this.modelId = Objects.requireNonNull(modelId);
        this.organizationId = organizationId;
        this.similarity = similarity;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
        this.dimensionsSetByUser = Objects.requireNonNull(dimensionsSetByUser);
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    OpenAiEmbeddingsServiceSettings(String modelId, @Nullable String uri, @Nullable String organizationId, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, Boolean dimensionsSetByUser, @Nullable RateLimitSettings rateLimitSettings) {
        this(modelId, ServiceUtils.createOptionalUri(uri), organizationId, similarity, dimensions, maxInputTokens, dimensionsSetByUser, rateLimitSettings);
    }

    public OpenAiEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createOptionalUri(in.readOptionalString());
        this.organizationId = in.readOptionalString();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
            this.dimensions = in.readOptionalVInt();
            this.maxInputTokens = in.readOptionalVInt();
        } else {
            this.similarity = null;
            this.dimensions = null;
            this.maxInputTokens = null;
        }
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            this.dimensionsSetByUser = in.readBoolean();
            this.modelId = in.readString();
        } else {
            this.dimensionsSetByUser = false;
            this.modelId = "unset";
        }
        this.rateLimitSettings = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_RATE_LIMIT_SETTINGS_ADDED) ? new RateLimitSettings(in) : DEFAULT_RATE_LIMIT_SETTINGS;
    }

    private OpenAiEmbeddingsServiceSettings(CommonFields fields, Boolean dimensionsSetByUser) {
        this(fields.modelId, fields.uri, fields.organizationId, fields.similarity, fields.dimensions, fields.maxInputTokens, dimensionsSetByUser, fields.rateLimitSettings);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String organizationId() {
        return this.organizationId;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Boolean dimensionsSetByUser() {
        return this.dimensionsSetByUser;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        if (this.dimensionsSetByUser != null) {
            builder.field(DIMENSIONS_SET_BY_USER, this.dimensionsSetByUser);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.organizationId != null) {
            builder.field("organization_id", this.organizationId);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        String uriToWrite = this.uri != null ? this.uri.toString() : null;
        out.writeOptionalString(uriToWrite);
        out.writeOptionalString(this.organizationId);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
            out.writeOptionalVInt(this.dimensions);
            out.writeOptionalVInt(this.maxInputTokens);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeBoolean(this.dimensionsSetByUser.booleanValue());
            out.writeString(this.modelId);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ML_INFERENCE_RATE_LIMIT_SETTINGS_ADDED)) {
            this.rateLimitSettings.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAiEmbeddingsServiceSettings that = (OpenAiEmbeddingsServiceSettings)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.dimensionsSetByUser, that.dimensionsSetByUser) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.modelId, this.organizationId, this.similarity, this.dimensions, this.maxInputTokens, this.dimensionsSetByUser, this.rateLimitSettings);
    }

    private record CommonFields(String modelId, @Nullable URI uri, @Nullable String organizationId, @Nullable SimilarityMeasure similarity, @Nullable Integer maxInputTokens, @Nullable Integer dimensions, RateLimitSettings rateLimitSettings) {
    }
}

