/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.rerank;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankRequestTaskSettings;

public class GoogleVertexAiRerankTaskSettings
implements TaskSettings {
    public static final String NAME = "google_vertex_ai_rerank_task_settings";
    public static final String TOP_N = "top_n";
    private final Integer topN;

    public static GoogleVertexAiRerankTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Integer topN = ServiceUtils.extractOptionalPositiveInteger(map, TOP_N, "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiRerankTaskSettings(topN);
    }

    public static GoogleVertexAiRerankTaskSettings of(GoogleVertexAiRerankTaskSettings originalSettings, GoogleVertexAiRerankRequestTaskSettings requestSettings) {
        Integer topN = requestSettings.topN() == null ? originalSettings.topN() : requestSettings.topN();
        return new GoogleVertexAiRerankTaskSettings(topN);
    }

    public GoogleVertexAiRerankTaskSettings(@Nullable Integer topN) {
        this.topN = topN;
    }

    public GoogleVertexAiRerankTaskSettings(StreamInput in) throws IOException {
        this.topN = in.readOptionalVInt();
    }

    public boolean isEmpty() {
        return this.topN == null;
    }

    public Integer topN() {
        return this.topN;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_GOOGLE_VERTEX_AI_RERANKING_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.topN);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.topN != null) {
            builder.field(TOP_N, this.topN);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GoogleVertexAiRerankTaskSettings that = (GoogleVertexAiRerankTaskSettings)object;
        return Objects.equals(this.topN, that.topN);
    }

    public int hashCode() {
        return Objects.hash(this.topN);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        GoogleVertexAiRerankRequestTaskSettings requestSettings = GoogleVertexAiRerankRequestTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return GoogleVertexAiRerankTaskSettings.of(this, requestSettings);
    }
}

