/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.rerank;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleDiscoveryEngineRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class GoogleVertexAiRerankServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
GoogleDiscoveryEngineRateLimitServiceSettings {
    public static final String NAME = "google_vertex_ai_rerank_service_settings";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(300L);
    private final String projectId;
    private final String modelId;
    private final RateLimitSettings rateLimitSettings;

    public static GoogleVertexAiRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String projectId = ServiceUtils.extractRequiredString(map, "project_id", "service_settings", validationException);
        String model = ServiceUtils.extractOptionalString(map, "model_id", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "googlevertexai", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiRerankServiceSettings(projectId, model, rateLimitSettings);
    }

    public GoogleVertexAiRerankServiceSettings(String projectId, @Nullable String modelId, @Nullable RateLimitSettings rateLimitSettings) {
        this.projectId = Objects.requireNonNull(projectId);
        this.modelId = modelId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public GoogleVertexAiRerankServiceSettings(StreamInput in) throws IOException {
        this.projectId = in.readString();
        this.modelId = in.readOptionalString();
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    @Override
    public String projectId() {
        return this.projectId;
    }

    public String modelId() {
        return this.modelId;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_GOOGLE_VERTEX_AI_RERANKING_ADDED;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("project_id", this.projectId);
        if (this.modelId != null) {
            builder.field("model_id", this.modelId);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.projectId);
        out.writeOptionalString(this.modelId);
        this.rateLimitSettings.writeTo(out);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GoogleVertexAiRerankServiceSettings that = (GoogleVertexAiRerankServiceSettings)object;
        return Objects.equals(this.projectId, that.projectId) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.modelId, this.rateLimitSettings);
    }
}

