/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.rerank;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.googlevertexai.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiSecretSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleDiscoveryEngineRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankTaskSettings;

public class GoogleVertexAiRerankModel
extends GoogleVertexAiModel {
    private URI uri;

    public GoogleVertexAiRerankModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, GoogleVertexAiRerankServiceSettings.fromMap(serviceSettings, context), GoogleVertexAiRerankTaskSettings.fromMap(taskSettings), GoogleVertexAiSecretSettings.fromMap(secrets));
    }

    public GoogleVertexAiRerankModel(GoogleVertexAiRerankModel model, GoogleVertexAiRerankServiceSettings serviceSettings) {
        super(model, serviceSettings);
    }

    GoogleVertexAiRerankModel(String inferenceEntityId, TaskType taskType, String service, GoogleVertexAiRerankServiceSettings serviceSettings, GoogleVertexAiRerankTaskSettings taskSettings, @Nullable GoogleVertexAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = GoogleVertexAiRerankModel.buildUri(serviceSettings.projectId());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected GoogleVertexAiRerankModel(String inferenceEntityId, TaskType taskType, String service, String uri, GoogleVertexAiRerankServiceSettings serviceSettings, GoogleVertexAiRerankTaskSettings taskSettings, @Nullable GoogleVertexAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public GoogleVertexAiRerankServiceSettings getServiceSettings() {
        return (GoogleVertexAiRerankServiceSettings)super.getServiceSettings();
    }

    public GoogleVertexAiRerankTaskSettings getTaskSettings() {
        return (GoogleVertexAiRerankTaskSettings)super.getTaskSettings();
    }

    public GoogleVertexAiSecretSettings getSecretSettings() {
        return (GoogleVertexAiSecretSettings)super.getSecretSettings();
    }

    @Override
    public GoogleDiscoveryEngineRateLimitServiceSettings rateLimitServiceSettings() {
        return (GoogleDiscoveryEngineRateLimitServiceSettings)super.rateLimitServiceSettings();
    }

    public URI uri() {
        return this.uri;
    }

    @Override
    public ExecutableAction accept(GoogleVertexAiActionVisitor visitor, Map<String, Object> taskSettings) {
        return visitor.create(this, taskSettings);
    }

    public static URI buildUri(String projectId) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("discoveryengine.googleapis.com").setPathSegments(new String[]{"v1", "projects", projectId, "locations", "global", "rankingConfigs", Strings.format((String)"%s:%s", (Object[])new Object[]{"default_ranking_config", "rank"})}).build();
    }
}

