/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai;

import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.googlevertexai.GoogleVertexAiActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankModel;

public class GoogleVertexAiService
extends SenderService {
    public static final String NAME = "googlevertexai";

    public GoogleVertexAiService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parseModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ChunkingSettings chunkingSettings = null;
            if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
                chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
            }
            GoogleVertexAiModel model = GoogleVertexAiService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parseModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parseModelListener.onFailure(e);
        }
    }

    public Model parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return GoogleVertexAiService.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return GoogleVertexAiService.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_GOOGLE_VERTEX_AI_EMBEDDINGS_ADDED;
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof GoogleVertexAiEmbeddingsModel) {
            GoogleVertexAiEmbeddingsModel embeddingsModel = (GoogleVertexAiEmbeddingsModel)model;
            ServiceUtils.getEmbeddingSize(model, this, (ActionListener<Integer>)listener.delegateFailureAndWrap((l, size) -> l.onResponse((Object)this.updateModelWithEmbeddingDetails(embeddingsModel, (int)size))));
        } else {
            listener.onResponse((Object)model);
        }
    }

    @Override
    protected void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof GoogleVertexAiModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        GoogleVertexAiModel googleVertexAiModel = (GoogleVertexAiModel)model;
        GoogleVertexAiActionCreator actionCreator = new GoogleVertexAiActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = googleVertexAiModel.accept(actionCreator, taskSettings);
        action.execute(inputs, timeout, listener);
    }

    @Override
    protected void doChunkedInfer(Model model, DocumentsOnlyInput inputs, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        GoogleVertexAiModel googleVertexAiModel = (GoogleVertexAiModel)model;
        GoogleVertexAiActionCreator actionCreator = new GoogleVertexAiActionCreator(this.getSender(), this.getServiceComponents());
        List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(inputs.getInputs(), 5, EmbeddingRequestChunker.EmbeddingType.FLOAT, googleVertexAiModel.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
        for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
            ExecutableAction action = googleVertexAiModel.accept(actionCreator, taskSettings);
            action.execute(new DocumentsOnlyInput(request.batch().inputs()), timeout, request.listener());
        }
    }

    private GoogleVertexAiEmbeddingsModel updateModelWithEmbeddingDetails(GoogleVertexAiEmbeddingsModel model, int embeddingSize) {
        if (model.getServiceSettings().dimensionsSetByUser().booleanValue() && model.getServiceSettings().dimensions() != null && model.getServiceSettings().dimensions() != embeddingSize) {
            throw new ElasticsearchStatusException(Strings.format((String)"The retrieved embeddings size [%s] does not match the size specified in the settings [%s]. Please recreate the [%s] configuration with the correct dimensions", (Object[])new Object[]{embeddingSize, model.getServiceSettings().dimensions(), model.getConfigurations().getInferenceEntityId()}), RestStatus.BAD_REQUEST, new Object[0]);
        }
        GoogleVertexAiEmbeddingsServiceSettings serviceSettings = new GoogleVertexAiEmbeddingsServiceSettings(model.getServiceSettings().location(), model.getServiceSettings().projectId(), model.getServiceSettings().modelId(), model.getServiceSettings().dimensionsSetByUser(), model.getServiceSettings().maxInputTokens(), embeddingSize, model.getServiceSettings().similarity(), model.getServiceSettings().rateLimitSettings());
        return new GoogleVertexAiEmbeddingsModel(model, serviceSettings);
    }

    private static GoogleVertexAiModel createModelFromPersistent(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, Map<String, Object> secretSettings, String failureMessage) {
        return GoogleVertexAiService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, chunkingSettings, secretSettings, failureMessage, ConfigurationParseContext.PERSISTENT);
    }

    private static GoogleVertexAiModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings, String failureMessage, ConfigurationParseContext context) {
        return switch (taskType) {
            case TaskType.TEXT_EMBEDDING -> new GoogleVertexAiEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, chunkingSettings, secretSettings, context);
            case TaskType.RERANK -> new GoogleVertexAiRerankModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            default -> throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
        };
    }
}

