/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googleaistudio.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googleaistudio.GoogleAiStudioRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class GoogleAiStudioEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
GoogleAiStudioRateLimitServiceSettings {
    public static final String NAME = "google_ai_studio_embeddings_service_settings";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(360L);
    private final String modelId;
    private final RateLimitSettings rateLimitSettings;
    private final Integer dims;
    private final Integer maxInputTokens;
    private final SimilarityMeasure similarity;

    public static GoogleAiStudioEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String model = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        SimilarityMeasure similarityMeasure = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "googleaistudio", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleAiStudioEmbeddingsServiceSettings(model, maxInputTokens, dims, similarityMeasure, rateLimitSettings);
    }

    public GoogleAiStudioEmbeddingsServiceSettings(String modelId, @Nullable Integer maxInputTokens, @Nullable Integer dims, @Nullable SimilarityMeasure similarity, @Nullable RateLimitSettings rateLimitSettings) {
        this.modelId = modelId;
        this.maxInputTokens = maxInputTokens;
        this.dims = dims;
        this.similarity = similarity;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public GoogleAiStudioEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.maxInputTokens = in.readOptionalVInt();
        this.dims = in.readOptionalVInt();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public Integer dimensions() {
        return this.dims;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_GOOGLE_AI_STUDIO_EMBEDDINGS_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeOptionalVInt(this.dims);
        out.writeOptionalEnum((Enum)this.similarity);
        this.rateLimitSettings.writeTo(out);
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.dims != null) {
            builder.field("dimensions", this.dims);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GoogleAiStudioEmbeddingsServiceSettings that = (GoogleAiStudioEmbeddingsServiceSettings)object;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings) && Objects.equals(this.dims, that.dims) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && this.similarity == that.similarity;
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.rateLimitSettings, this.dims, this.maxInputTokens, this.similarity);
    }
}

