/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.MultilingualE5SmallInternalServiceSettings;

public class MultilingualE5SmallModel
extends ElasticsearchInternalModel {
    public MultilingualE5SmallModel(String inferenceEntityId, TaskType taskType, String service, MultilingualE5SmallInternalServiceSettings serviceSettings, ChunkingSettings chunkingSettings) {
        super(inferenceEntityId, taskType, service, (ElasticsearchInternalServiceSettings)serviceSettings, chunkingSettings);
    }

    @Override
    public MultilingualE5SmallInternalServiceSettings getServiceSettings() {
        return (MultilingualE5SmallInternalServiceSettings)super.getServiceSettings();
    }

    @Override
    public ActionListener<CreateTrainedModelAssignmentAction.Response> getCreateTrainedModelAssignmentActionListener(Model model, final ActionListener<Boolean> listener) {
        return new ActionListener<CreateTrainedModelAssignmentAction.Response>(){

            public void onResponse(CreateTrainedModelAssignmentAction.Response response) {
                listener.onResponse((Object)Boolean.TRUE);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not start the TextEmbeddingService service as the Multilingual-E5-Small model for this platform cannot be found. Multilingual-E5-Small needs to be downloaded before it can be started", new Object[0]));
                    return;
                }
                listener.onFailure(e);
            }
        };
    }
}

