/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.core.ml.inference.assignment.AdaptiveAllocationsSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserModels;

public class ElserInternalServiceSettings
extends ElasticsearchInternalServiceSettings {
    public static final String NAME = "elser_mlnode_service_settings";

    public static ElasticsearchInternalServiceSettings.Builder fromRequestMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        ElasticsearchInternalServiceSettings.Builder baseSettings = ElasticsearchInternalServiceSettings.fromMap(map, validationException);
        String modelId = baseSettings.getModelId();
        if (modelId != null && !ElserModels.isValidModel(modelId)) {
            ValidationException ve = new ValidationException();
            ve.addValidationError("Unknown ELSER model ID [" + modelId + "]. Valid models are " + Arrays.toString(ElserModels.VALID_ELSER_MODEL_IDS.toArray()));
            throw ve;
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return baseSettings;
    }

    public ElserInternalServiceSettings(ElasticsearchInternalServiceSettings other) {
        super(other);
    }

    public ElserInternalServiceSettings(Integer numAllocations, int numThreads, String modelId, AdaptiveAllocationsSettings adaptiveAllocationsSettings) {
        this(new ElasticsearchInternalServiceSettings(numAllocations, numThreads, modelId, adaptiveAllocationsSettings));
    }

    public ElserInternalServiceSettings(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_11_X;
    }
}

