/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserMlNodeTaskSettings;

public class ElserInternalModel
extends ElasticsearchInternalModel {
    public ElserInternalModel(String inferenceEntityId, TaskType taskType, String service, ElserInternalServiceSettings serviceSettings, ElserMlNodeTaskSettings taskSettings, ChunkingSettings chunkingSettings) {
        super(inferenceEntityId, taskType, service, serviceSettings, taskSettings, chunkingSettings);
    }

    @Override
    public ElserInternalServiceSettings getServiceSettings() {
        return (ElserInternalServiceSettings)super.getServiceSettings();
    }

    public ElserMlNodeTaskSettings getTaskSettings() {
        return (ElserMlNodeTaskSettings)super.getTaskSettings();
    }

    @Override
    public ActionListener<CreateTrainedModelAssignmentAction.Response> getCreateTrainedModelAssignmentActionListener(Model model, final ActionListener<Boolean> listener) {
        return new ActionListener<CreateTrainedModelAssignmentAction.Response>(){

            public void onResponse(CreateTrainedModelAssignmentAction.Response response) {
                listener.onResponse((Object)Boolean.TRUE);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not start the ELSER service as the ELSER model for this platform cannot be found. ELSER needs to be downloaded before it can be started.", new Object[0]));
                    return;
                }
                listener.onFailure(e);
            }
        };
    }
}

