/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public abstract class ElasticsearchInternalModel
extends Model {
    protected ElasticsearchInternalServiceSettings internalServiceSettings;

    public ElasticsearchInternalModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings, ChunkingSettings chunkingSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)internalServiceSettings, chunkingSettings));
        this.internalServiceSettings = internalServiceSettings;
    }

    public ElasticsearchInternalModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)internalServiceSettings));
        this.internalServiceSettings = internalServiceSettings;
    }

    public ElasticsearchInternalModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings, TaskSettings taskSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)internalServiceSettings, taskSettings));
        this.internalServiceSettings = internalServiceSettings;
    }

    public ElasticsearchInternalModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings, TaskSettings taskSettings, ChunkingSettings chunkingSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)internalServiceSettings, taskSettings, chunkingSettings));
        this.internalServiceSettings = internalServiceSettings;
    }

    public StartTrainedModelDeploymentAction.Request getStartTrainedModelDeploymentActionRequest() {
        StartTrainedModelDeploymentAction.Request startRequest = new StartTrainedModelDeploymentAction.Request(this.internalServiceSettings.modelId(), this.getInferenceEntityId());
        startRequest.setNumberOfAllocations(this.internalServiceSettings.getNumAllocations());
        startRequest.setThreadsPerAllocation(this.internalServiceSettings.getNumThreads());
        startRequest.setAdaptiveAllocationsSettings(this.internalServiceSettings.getAdaptiveAllocationsSettings());
        startRequest.setWaitForState(AllocationStatus.State.STARTED);
        return startRequest;
    }

    public abstract ActionListener<CreateTrainedModelAssignmentAction.Response> getCreateTrainedModelAssignmentActionListener(Model var1, ActionListener<Boolean> var2);

    public boolean usesExistingDeployment() {
        return this.internalServiceSettings.getDeploymentId() != null;
    }

    public ElasticsearchInternalServiceSettings getServiceSettings() {
        return (ElasticsearchInternalServiceSettings)super.getServiceSettings();
    }

    public void updateNumAllocation(Integer numAllocations) {
        this.internalServiceSettings.setNumAllocations(numAllocations);
    }

    public String toString() {
        return Strings.toString((ToXContent)this.getConfigurations());
    }

    public String mlNodeDeploymentId() {
        return this.internalServiceSettings.getDeploymentId() == null ? this.getInferenceEntityId() : this.internalServiceSettings.getDeploymentId();
    }
}

