/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public class CustomElandModel
extends ElasticsearchInternalModel {
    public CustomElandModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings, ChunkingSettings chunkingSettings) {
        super(inferenceEntityId, taskType, service, internalServiceSettings, chunkingSettings);
    }

    public CustomElandModel(String inferenceEntityId, TaskType taskType, String service, ElasticsearchInternalServiceSettings internalServiceSettings, TaskSettings taskSettings) {
        super(inferenceEntityId, taskType, service, internalServiceSettings, taskSettings);
    }

    @Override
    public ActionListener<CreateTrainedModelAssignmentAction.Response> getCreateTrainedModelAssignmentActionListener(Model model, final ActionListener<Boolean> listener) {
        return new ActionListener<CreateTrainedModelAssignmentAction.Response>(){

            public void onResponse(CreateTrainedModelAssignmentAction.Response response) {
                listener.onResponse((Object)Boolean.TRUE);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not start the inference as the custom eland model [{0}] for this platform cannot be found. Custom models need to be loaded into the cluster with eland before they can be started.", new Object[]{CustomElandModel.this.internalServiceSettings.modelId()}));
                    return;
                }
                listener.onFailure(e);
            }
        };
    }
}

