/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai.completion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionRequestTaskSettings;

public class AzureOpenAiCompletionTaskSettings
implements TaskSettings {
    public static final String NAME = "azure_openai_completion_task_settings";
    public static final String USER = "user";
    private final String user;

    public static AzureOpenAiCompletionTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        String user = ServiceUtils.extractOptionalString(map, USER, "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureOpenAiCompletionTaskSettings(user);
    }

    public static AzureOpenAiCompletionTaskSettings of(AzureOpenAiCompletionTaskSettings originalSettings, AzureOpenAiCompletionRequestTaskSettings requestSettings) {
        String userToUse = requestSettings.user() == null ? originalSettings.user : requestSettings.user();
        return new AzureOpenAiCompletionTaskSettings(userToUse);
    }

    public AzureOpenAiCompletionTaskSettings(@Nullable String user) {
        this.user = user;
    }

    public AzureOpenAiCompletionTaskSettings(StreamInput in) throws IOException {
        this.user = in.readOptionalString();
    }

    public boolean isEmpty() {
        return this.user == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.user != null) {
            builder.field(USER, this.user);
        }
        builder.endObject();
        return builder;
    }

    public String user() {
        return this.user;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_AZURE_OPENAI_COMPLETIONS;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.user);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AzureOpenAiCompletionTaskSettings that = (AzureOpenAiCompletionTaskSettings)object;
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AzureOpenAiCompletionRequestTaskSettings updatedSettings = AzureOpenAiCompletionRequestTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return AzureOpenAiCompletionTaskSettings.of(this, updatedSettings);
    }
}

