/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AzureAiStudioEmbeddingsServiceSettings
extends AzureAiStudioServiceSettings {
    public static final String NAME = "azure_ai_studio_embeddings_service_settings";
    static final String DIMENSIONS_SET_BY_USER = "dimensions_set_by_user";
    private final Integer dimensions;
    private final Boolean dimensionsSetByUser;
    private final Integer maxInputTokens;
    private final SimilarityMeasure similarity;

    public static AzureAiStudioEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        AzureAiStudioEmbeddingCommonFields settings = AzureAiStudioEmbeddingsServiceSettings.embeddingSettingsFromMap(map, validationException, context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureAiStudioEmbeddingsServiceSettings(settings);
    }

    private static AzureAiStudioEmbeddingCommonFields embeddingSettingsFromMap(Map<String, Object> map, ValidationException validationException, ConfigurationParseContext context) {
        AzureAiStudioServiceSettings.BaseAzureAiStudioCommonFields baseSettings = AzureAiStudioServiceSettings.fromMap(map, validationException, context);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        Integer maxTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        Boolean dimensionsSetByUser = ServiceUtils.extractOptionalBoolean(map, DIMENSIONS_SET_BY_USER, validationException);
        switch (context) {
            case REQUEST: {
                if (dimensionsSetByUser != null) {
                    validationException.addValidationError(ServiceUtils.invalidSettingError(DIMENSIONS_SET_BY_USER, "service_settings"));
                }
                dimensionsSetByUser = dims != null;
                break;
            }
            case PERSISTENT: {
                if (dimensionsSetByUser != null) break;
                validationException.addValidationError(ServiceUtils.missingSettingErrorMsg(DIMENSIONS_SET_BY_USER, "service_settings"));
            }
        }
        return new AzureAiStudioEmbeddingCommonFields(baseSettings, dims, dimensionsSetByUser, maxTokens, similarity);
    }

    public AzureAiStudioEmbeddingsServiceSettings(String target, AzureAiStudioProvider provider, AzureAiStudioEndpointType endpointType, @Nullable Integer dimensions, Boolean dimensionsSetByUser, @Nullable Integer maxInputTokens, @Nullable SimilarityMeasure similarity, RateLimitSettings rateLimitSettings) {
        super(target, provider, endpointType, rateLimitSettings);
        this.dimensions = dimensions;
        this.dimensionsSetByUser = dimensionsSetByUser;
        this.maxInputTokens = maxInputTokens;
        this.similarity = similarity;
    }

    public AzureAiStudioEmbeddingsServiceSettings(StreamInput in) throws IOException {
        super(in);
        this.dimensions = in.readOptionalVInt();
        this.dimensionsSetByUser = in.readBoolean();
        this.maxInputTokens = in.readOptionalVInt();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
    }

    private AzureAiStudioEmbeddingsServiceSettings(AzureAiStudioEmbeddingCommonFields fields) {
        this(fields.baseCommonFields.target(), fields.baseCommonFields.provider(), fields.baseCommonFields.endpointType(), fields.dimensions(), fields.dimensionsSetByUser(), fields.maxInputTokens(), fields.similarity(), fields.baseCommonFields.rateLimitSettings());
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Boolean dimensionsSetByUser() {
        return this.dimensionsSetByUser;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_AZURE_AI_STUDIO;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalVInt(this.dimensions);
        out.writeBoolean(this.dimensionsSetByUser.booleanValue());
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeOptionalEnum((Enum)this.similarity);
    }

    private void addXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.addXContentFields(builder, params);
        this.addXContentFragmentOfExposedFields(builder, params);
        builder.field(DIMENSIONS_SET_BY_USER, this.dimensionsSetByUser);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addExposedXContentFields(builder, params);
        this.addXContentFragmentOfExposedFields(builder, params);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureAiStudioEmbeddingsServiceSettings that = (AzureAiStudioEmbeddingsServiceSettings)o;
        return Objects.equals(this.target, that.target) && Objects.equals((Object)this.provider, (Object)that.provider) && Objects.equals((Object)this.endpointType, (Object)that.endpointType) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.dimensionsSetByUser, that.dimensionsSetByUser) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.target, this.provider, this.endpointType, this.dimensions, this.dimensionsSetByUser, this.maxInputTokens, this.similarity, this.rateLimitSettings});
    }

    private record AzureAiStudioEmbeddingCommonFields(AzureAiStudioServiceSettings.BaseAzureAiStudioCommonFields baseCommonFields, @Nullable Integer dimensions, Boolean dimensionsSetByUser, @Nullable Integer maxInputTokens, SimilarityMeasure similarity) {
    }
}

