/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class AmazonBedrockServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    protected static final String AMAZON_BEDROCK_BASE_NAME = "amazon_bedrock";
    protected final String region;
    protected final String model;
    protected final AmazonBedrockProvider provider;
    protected final RateLimitSettings rateLimitSettings;
    protected static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(240L);

    protected static BaseAmazonBedrockCommonSettings fromMap(Map<String, Object> map, ValidationException validationException, ConfigurationParseContext context) {
        String model = ServiceUtils.extractRequiredString(map, "model", "service_settings", validationException);
        String region = ServiceUtils.extractRequiredString(map, "region", "service_settings", validationException);
        AmazonBedrockProvider provider = ServiceUtils.extractRequiredEnum(map, "provider", "service_settings", AmazonBedrockProvider::fromString, EnumSet.allOf(AmazonBedrockProvider.class), validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, AMAZON_BEDROCK_BASE_NAME, context);
        return new BaseAmazonBedrockCommonSettings(region, model, provider, rateLimitSettings);
    }

    protected AmazonBedrockServiceSettings(StreamInput in) throws IOException {
        this.region = in.readString();
        this.model = in.readString();
        this.provider = (AmazonBedrockProvider)in.readEnum(AmazonBedrockProvider.class);
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    protected AmazonBedrockServiceSettings(String region, String model, AmazonBedrockProvider provider, @Nullable RateLimitSettings rateLimitSettings) {
        this.region = Objects.requireNonNull(region);
        this.model = Objects.requireNonNull(model);
        this.provider = Objects.requireNonNull(provider);
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_AMAZON_BEDROCK_ADDED;
    }

    public String region() {
        return this.region;
    }

    public String modelId() {
        return this.model;
    }

    public AmazonBedrockProvider provider() {
        return this.provider;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.region);
        out.writeString(this.model);
        out.writeEnum((Enum)this.provider);
        this.rateLimitSettings.writeTo(out);
    }

    public void addBaseXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContentFragmentOfExposedFields(builder, params);
    }

    protected void addXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("region", this.region);
        builder.field("model", this.model);
        builder.field("provider", this.provider.name());
        this.rateLimitSettings.toXContent(builder, params);
    }

    protected record BaseAmazonBedrockCommonSettings(String region, String model, AmazonBedrockProvider provider, @Nullable RateLimitSettings rateLimitSettings) {
    }
}

