/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;

public abstract class SenderService
implements InferenceService {
    protected static final Set<TaskType> COMPLETION_ONLY = EnumSet.of(TaskType.COMPLETION, TaskType.ANY);
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public SenderService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        Objects.requireNonNull(factory);
        this.sender = factory.createSender();
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    protected Sender getSender() {
        return this.sender;
    }

    protected ServiceComponents getServiceComponents() {
        return this.serviceComponents;
    }

    public void infer(Model model, @Nullable String query, List<String> input, boolean stream, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        this.init();
        if (query != null) {
            this.doInfer(model, new QueryAndDocsInputs(query, input, stream), taskSettings, inputType, timeout, listener);
        } else {
            this.doInfer(model, new DocumentsOnlyInput(input, stream), taskSettings, inputType, timeout, listener);
        }
    }

    public void chunkedInfer(Model model, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        this.init();
        this.chunkedInfer(model, null, input, taskSettings, inputType, chunkingOptions, timeout, listener);
    }

    public void chunkedInfer(Model model, @Nullable String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        this.init();
        this.doChunkedInfer(model, new DocumentsOnlyInput(input), taskSettings, inputType, chunkingOptions, timeout, listener);
    }

    protected abstract void doInfer(Model var1, InferenceInputs var2, Map<String, Object> var3, InputType var4, TimeValue var5, ActionListener<InferenceServiceResults> var6);

    protected abstract void doChunkedInfer(Model var1, DocumentsOnlyInput var2, Map<String, Object> var3, InputType var4, ChunkingOptions var5, TimeValue var6, ActionListener<List<ChunkedInferenceServiceResults>> var7);

    public void start(Model model, ActionListener<Boolean> listener) {
        this.init();
        this.doStart(model, listener);
    }

    protected void doStart(Model model, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    private void init() {
        this.sender.start();
    }

    public void close() throws IOException {
        IOUtils.closeWhileHandlingException((Closeable)this.sender);
    }
}

