/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.support.MapXContentParser;

public record SemanticTextField(String fieldName, List<String> originalValues, InferenceResult inference, XContentType contentType) implements ToXContentObject
{
    static final String TEXT_FIELD = "text";
    static final String INFERENCE_FIELD = "inference";
    static final String INFERENCE_ID_FIELD = "inference_id";
    static final String SEARCH_INFERENCE_ID_FIELD = "search_inference_id";
    static final String CHUNKS_FIELD = "chunks";
    static final String CHUNKED_EMBEDDINGS_FIELD = "embeddings";
    static final String CHUNKED_TEXT_FIELD = "text";
    static final String MODEL_SETTINGS_FIELD = "model_settings";
    static final String TASK_TYPE_FIELD = "task_type";
    static final String DIMENSIONS_FIELD = "dimensions";
    static final String SIMILARITY_FIELD = "similarity";
    static final String ELEMENT_TYPE_FIELD = "element_type";
    private static final ConstructingObjectParser<SemanticTextField, Tuple<String, XContentType>> SEMANTIC_TEXT_FIELD_PARSER = new ConstructingObjectParser("semantic_text", true, (args, context) -> new SemanticTextField((String)context.v1(), (List<String>)(args[0] == null ? List.of() : args[0]), (InferenceResult)args[1], (XContentType)context.v2()));
    private static final ConstructingObjectParser<InferenceResult, Void> INFERENCE_RESULT_PARSER = new ConstructingObjectParser("inference", true, args -> new InferenceResult((String)args[0], (ModelSettings)args[1], (List)args[2]));
    private static final ConstructingObjectParser<Chunk, Void> CHUNKS_PARSER = new ConstructingObjectParser("chunks", true, args -> new Chunk((String)args[0], (BytesReference)args[1]));
    private static final ConstructingObjectParser<ModelSettings, Void> MODEL_SETTINGS_PARSER = new ConstructingObjectParser("model_settings", true, args -> {
        TaskType taskType = TaskType.fromString((String)((String)args[0]));
        Integer dimensions = (Integer)args[1];
        SimilarityMeasure similarity = args[2] == null ? null : SimilarityMeasure.fromString((String)((String)args[2]));
        DenseVectorFieldMapper.ElementType elementType = args[3] == null ? null : DenseVectorFieldMapper.ElementType.fromString((String)((String)args[3]));
        return new ModelSettings(taskType, dimensions, similarity, elementType);
    });

    public static String getOriginalTextFieldName(String fieldName) {
        return fieldName + ".text";
    }

    public static String getInferenceFieldName(String fieldName) {
        return fieldName + ".inference";
    }

    public static String getChunksFieldName(String fieldName) {
        return SemanticTextField.getInferenceFieldName(fieldName) + ".chunks";
    }

    public static String getEmbeddingsFieldName(String fieldName) {
        return SemanticTextField.getChunksFieldName(fieldName) + ".embeddings";
    }

    static SemanticTextField parse(XContentParser parser, Tuple<String, XContentType> context) throws IOException {
        return (SemanticTextField)SEMANTIC_TEXT_FIELD_PARSER.parse(parser, context);
    }

    static ModelSettings parseModelSettings(XContentParser parser) throws IOException {
        return (ModelSettings)MODEL_SETTINGS_PARSER.parse(parser, null);
    }

    static ModelSettings parseModelSettingsFromMap(Object node) {
        if (node == null) {
            return null;
        }
        try {
            Map map = XContentMapValues.nodeMapValue((Object)node, (String)MODEL_SETTINGS_FIELD);
            MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, map, XContentType.JSON);
            return SemanticTextField.parseModelSettings((XContentParser)parser);
        }
        catch (Exception exc) {
            throw new ElasticsearchException((Throwable)exc);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.originalValues.isEmpty()) {
            builder.field("text", this.originalValues.size() == 1 ? this.originalValues.get(0) : this.originalValues);
        }
        builder.startObject(INFERENCE_FIELD);
        builder.field(INFERENCE_ID_FIELD, this.inference.inferenceId);
        builder.field(MODEL_SETTINGS_FIELD, (ToXContent)this.inference.modelSettings);
        builder.startArray(CHUNKS_FIELD);
        for (Chunk chunk : this.inference.chunks) {
            builder.startObject();
            builder.field("text", chunk.text);
            XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)chunk.rawEmbeddings, (XContentType)this.contentType);
            builder.field(CHUNKED_EMBEDDINGS_FIELD).copyCurrentStructure(parser);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static List<Chunk> toSemanticTextFieldChunks(List<ChunkedInferenceServiceResults> results, XContentType contentType) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (ChunkedInferenceServiceResults result : results) {
            Iterator it = result.chunksAsMatchedTextAndByteReference(contentType.xContent());
            while (it.hasNext()) {
                ChunkedInferenceServiceResults.Chunk chunkAsByteReference = (ChunkedInferenceServiceResults.Chunk)it.next();
                chunks.add(new Chunk(chunkAsByteReference.matchedText(), chunkAsByteReference.bytesReference()));
            }
        }
        return chunks;
    }

    static {
        SEMANTIC_TEXT_FIELD_PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("text", new String[0]));
        SEMANTIC_TEXT_FIELD_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (InferenceResult)INFERENCE_RESULT_PARSER.parse(p, null), new ParseField(INFERENCE_FIELD, new String[0]));
        INFERENCE_RESULT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INFERENCE_ID_FIELD, new String[0]));
        INFERENCE_RESULT_PARSER.declareObject(ConstructingObjectParser.constructorArg(), MODEL_SETTINGS_PARSER, new ParseField(MODEL_SETTINGS_FIELD, new String[0]));
        INFERENCE_RESULT_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), CHUNKS_PARSER, new ParseField(CHUNKS_FIELD, new String[0]));
        CHUNKS_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("text", new String[0]));
        CHUNKS_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
            XContentBuilder b = XContentBuilder.builder((XContent)p.contentType().xContent());
            b.copyCurrentStructure(p);
            return BytesReference.bytes((XContentBuilder)b);
        }, new ParseField(CHUNKED_EMBEDDINGS_FIELD, new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        MODEL_SETTINGS_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(TASK_TYPE_FIELD, new String[0]));
        MODEL_SETTINGS_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(DIMENSIONS_FIELD, new String[0]));
        MODEL_SETTINGS_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(SIMILARITY_FIELD, new String[0]));
        MODEL_SETTINGS_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(ELEMENT_TYPE_FIELD, new String[0]));
    }

    public record InferenceResult(String inferenceId, ModelSettings modelSettings, List<Chunk> chunks) {
    }

    public record ModelSettings(TaskType taskType, Integer dimensions, SimilarityMeasure similarity, DenseVectorFieldMapper.ElementType elementType) implements ToXContentObject
    {
        public ModelSettings(Model model) {
            this(model.getTaskType(), model.getServiceSettings().dimensions(), model.getServiceSettings().similarity(), model.getServiceSettings().elementType());
        }

        public ModelSettings(TaskType taskType, Integer dimensions, SimilarityMeasure similarity, DenseVectorFieldMapper.ElementType elementType) {
            this.taskType = Objects.requireNonNull(taskType, "task type must not be null");
            this.dimensions = dimensions;
            this.similarity = similarity;
            this.elementType = elementType;
            this.validate();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SemanticTextField.TASK_TYPE_FIELD, this.taskType.toString());
            if (this.dimensions != null) {
                builder.field(SemanticTextField.DIMENSIONS_FIELD, this.dimensions);
            }
            if (this.similarity != null) {
                builder.field(SemanticTextField.SIMILARITY_FIELD, (Enum)this.similarity);
            }
            if (this.elementType != null) {
                builder.field(SemanticTextField.ELEMENT_TYPE_FIELD, (Enum)this.elementType);
            }
            return builder.endObject();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("task_type=").append(this.taskType);
            if (this.dimensions != null) {
                sb.append(", dimensions=").append(this.dimensions);
            }
            if (this.similarity != null) {
                sb.append(", similarity=").append(this.similarity);
            }
            if (this.elementType != null) {
                sb.append(", element_type=").append(this.elementType);
            }
            return sb.toString();
        }

        private void validate() {
            switch (this.taskType) {
                case TEXT_EMBEDDING: {
                    this.validateFieldPresent(SemanticTextField.DIMENSIONS_FIELD, this.dimensions);
                    this.validateFieldPresent(SemanticTextField.SIMILARITY_FIELD, this.similarity);
                    this.validateFieldPresent(SemanticTextField.ELEMENT_TYPE_FIELD, this.elementType);
                    break;
                }
                case SPARSE_EMBEDDING: {
                    this.validateFieldNotPresent(SemanticTextField.DIMENSIONS_FIELD, this.dimensions);
                    this.validateFieldNotPresent(SemanticTextField.SIMILARITY_FIELD, this.similarity);
                    this.validateFieldNotPresent(SemanticTextField.ELEMENT_TYPE_FIELD, this.elementType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong [task_type], expected " + TaskType.TEXT_EMBEDDING + " or " + TaskType.SPARSE_EMBEDDING + ", got " + this.taskType.name());
                }
            }
        }

        private void validateFieldPresent(String field, Object fieldValue) {
            if (fieldValue == null) {
                throw new IllegalArgumentException("required [" + field + "] field is missing for task_type [" + this.taskType.name() + "]");
            }
        }

        private void validateFieldNotPresent(String field, Object fieldValue) {
            if (fieldValue != null) {
                throw new IllegalArgumentException("[" + field + "] is not allowed for task_type [" + this.taskType.name() + "]");
            }
        }
    }

    public record Chunk(String text, BytesReference rawEmbeddings) {
    }
}

