/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.alibabacloudsearch;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsTaskSettings;

public record AlibabaCloudSearchEmbeddingsRequestEntity(List<String> input, AlibabaCloudSearchEmbeddingsTaskSettings taskSettings) implements ToXContentObject
{
    private static final String SEARCH_DOCUMENT = "document";
    private static final String SEARCH_QUERY = "query";
    private static final String TEXTS_FIELD = "input";
    static final String INPUT_TYPE_FIELD = "input_type";

    public AlibabaCloudSearchEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TEXTS_FIELD, this.input);
        String inputType = AlibabaCloudSearchEmbeddingsRequestEntity.covertToString(this.taskSettings.getInputType());
        if (inputType != null) {
            builder.field(INPUT_TYPE_FIELD, inputType);
        }
        builder.endObject();
        return builder;
    }

    static String covertToString(InputType inputType) {
        if (inputType == null) {
            return null;
        }
        return switch (inputType) {
            case InputType.INGEST -> SEARCH_DOCUMENT;
            case InputType.SEARCH -> SEARCH_QUERY;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)AlibabaCloudSearchEmbeddingsTaskSettings.invalidInputTypeMessage(inputType));
                }
                yield null;
            }
        };
    }
}

