/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

class StreamingResponseHandler
implements Flow.Processor<HttpResult, HttpResult> {
    private static final Logger log = LogManager.getLogger(StreamingResponseHandler.class);
    private final ThrottlerManager throttlerManager;
    private final Logger throttlerLogger;
    private final Request request;
    private final ResponseHandler responseHandler;
    private final AtomicBoolean upstreamIsClosed = new AtomicBoolean(false);
    private final AtomicBoolean processedFirstItem = new AtomicBoolean(false);
    private volatile Flow.Subscription upstream;
    private volatile Flow.Subscriber<? super HttpResult> downstream;

    StreamingResponseHandler(ThrottlerManager throttlerManager, Logger throttlerLogger, Request request, ResponseHandler responseHandler) {
        this.throttlerManager = throttlerManager;
        this.throttlerLogger = throttlerLogger;
        this.request = request;
        this.responseHandler = responseHandler;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super HttpResult> subscriber) {
        if (this.downstream != null) {
            subscriber.onError(new IllegalStateException("Failed to initialize streaming response. Another subscriber is already subscribed."));
            return;
        }
        this.downstream = subscriber;
        subscriber.onSubscribe(this.forwardingSubscription());
    }

    private Flow.Subscription forwardingSubscription() {
        return new Flow.Subscription(){

            @Override
            public void request(long n) {
                if (StreamingResponseHandler.this.upstreamIsClosed.get()) {
                    StreamingResponseHandler.this.downstream.onComplete();
                } else if (StreamingResponseHandler.this.upstream != null) {
                    StreamingResponseHandler.this.upstream.request(n);
                } else {
                    String errorMessage = "Failed to initialize streaming response. onSubscribe must be called first to set the upstream";
                    assert (false) : errorMessage;
                    StreamingResponseHandler.this.downstream.onError(new IllegalStateException(errorMessage));
                }
            }

            @Override
            public void cancel() {
                if (StreamingResponseHandler.this.upstreamIsClosed.compareAndSet(false, true) && StreamingResponseHandler.this.upstream != null) {
                    StreamingResponseHandler.this.upstream.cancel();
                }
            }
        };
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.upstream = subscription;
    }

    @Override
    public void onNext(HttpResult item) {
        if (this.processedFirstItem.compareAndSet(false, true)) {
            try {
                this.responseHandler.validateResponse(this.throttlerManager, this.throttlerLogger, this.request, item);
            }
            catch (Exception e) {
                this.logException(this.throttlerLogger, this.request, item, this.responseHandler.getRequestType(), e);
                this.upstream.cancel();
                this.onError(e);
                return;
            }
        }
        this.downstream.onNext(item);
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.upstreamIsClosed.compareAndSet(false, true)) {
            if (this.downstream != null) {
                this.downstream.onError(throwable);
            } else {
                log.warn("Flow failed before the InferenceServiceResults were generated.  The error should go to the listener directly.", throwable);
            }
        }
    }

    @Override
    public void onComplete() {
        if (this.upstreamIsClosed.compareAndSet(false, true)) {
            if (this.downstream != null) {
                this.downstream.onComplete();
            } else {
                log.debug("Flow completed before the InferenceServiceResults were generated.  Shutting down this Processor.");
            }
        }
    }

    private void logException(Logger logger, Request request, HttpResult result, String requestType, Exception exception) {
        Throwable causeException = ExceptionsHelper.unwrapCause((Throwable)exception);
        this.throttlerManager.warn(logger, Strings.format((String)"Failed to process the stream connection for request from inference entity id [%s] of type [%s] with status [%s] [%s]", (Object[])new Object[]{request.getInferenceEntityId(), requestType, result.response().getStatusLine().getStatusCode(), result.response().getStatusLine().getReasonPhrase()}), causeException);
    }
}

