/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.IOException;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.HttpSettings;
import org.elasticsearch.xpack.inference.external.http.RequestBasedTaskRunner;

class StreamingHttpResultPublisher
implements HttpAsyncResponseConsumer<HttpResponse>,
Flow.Publisher<HttpResult> {
    private final HttpSettings settings;
    private final ActionListener<Flow.Publisher<HttpResult>> listener;
    private final AtomicBoolean listenerCalled = new AtomicBoolean(false);
    private volatile HttpResponse response;
    private volatile Exception ex;
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final AtomicBoolean subscriptionCanceled = new AtomicBoolean(false);
    private volatile Flow.Subscriber<? super HttpResult> subscriber;
    private final RequestBasedTaskRunner taskRunner;
    private final AtomicBoolean pendingRequest = new AtomicBoolean(false);
    private final Deque<Runnable> queue = new ConcurrentLinkedDeque<Runnable>();
    private final SimpleInputBuffer inputBuffer = new SimpleInputBuffer(4096);
    private final AtomicLong bytesInQueue = new AtomicLong(0L);
    private final Object ioLock = new Object();
    private volatile IOControl savedIoControl;

    StreamingHttpResultPublisher(ThreadPool threadPool, HttpSettings settings, ActionListener<Flow.Publisher<HttpResult>> listener) {
        this.settings = Objects.requireNonNull(settings);
        this.listener = ActionListener.notifyOnce(Objects.requireNonNull(listener));
        this.taskRunner = new RequestBasedTaskRunner(new OffloadThread(), threadPool, "inference_utility");
    }

    public void responseReceived(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super HttpResult> subscriber) {
        if (this.subscriber != null) {
            subscriber.onError(new IllegalStateException("Only one subscriber is allowed for this Publisher."));
            return;
        }
        this.subscriber = subscriber;
        subscriber.onSubscribe(new HttpSubscription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeContent(ContentDecoder contentDecoder, IOControl ioControl) throws IOException {
        if (this.subscriptionCanceled.get()) {
            ioControl.shutdown();
            return;
        }
        try {
            int consumed = this.inputBuffer.consumeContent(contentDecoder);
            byte[] allBytes = new byte[consumed];
            this.inputBuffer.read(allBytes);
            if (allBytes.length > 0) {
                this.queue.offer(() -> {
                    double maxBytes;
                    this.subscriber.onNext(new HttpResult(this.response, allBytes));
                    long currentBytesInQueue = this.bytesInQueue.updateAndGet(current -> Long.max(0L, current - (long)allBytes.length));
                    if (this.savedIoControl != null && (double)currentBytesInQueue <= (maxBytes = (double)this.settings.getMaxResponseSize().getBytes() * 0.5)) {
                        this.resumeProducer();
                    }
                });
            }
            if (this.bytesInQueue.accumulateAndGet(allBytes.length, Long::sum) >= this.settings.getMaxResponseSize().getBytes()) {
                this.pauseProducer(ioControl);
            }
            this.taskRunner.requestNextRun();
            if (this.listenerCalled.compareAndSet(false, true)) {
                this.listener.onResponse((Object)this);
            }
        }
        finally {
            this.inputBuffer.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseProducer(IOControl ioControl) {
        ioControl.suspendInput();
        Object object = this.ioLock;
        synchronized (object) {
            this.savedIoControl = ioControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeProducer() {
        Object object = this.ioLock;
        synchronized (object) {
            if (this.savedIoControl != null) {
                this.savedIoControl.requestInput();
                this.savedIoControl = null;
            }
        }
    }

    public void responseCompleted(HttpContext httpContext) {
    }

    public void failed(Exception e) {
        if (this.isDone.compareAndSet(false, true)) {
            if (this.listenerCalled.compareAndSet(false, true)) {
                this.listener.onFailure(e);
            } else {
                this.ex = e;
                this.queue.offer(() -> this.subscriber.onError(e));
                this.taskRunner.requestNextRun();
            }
        }
    }

    public void close() {
        if (this.isDone.compareAndSet(false, true)) {
            this.queue.offer(() -> this.subscriber.onComplete());
            this.taskRunner.requestNextRun();
        }
    }

    public boolean cancel() {
        this.close();
        return true;
    }

    public Exception getException() {
        return this.ex;
    }

    public HttpResponse getResult() {
        return this.response;
    }

    public boolean isDone() {
        return this.isDone.get();
    }

    private class OffloadThread
    implements Runnable {
        private OffloadThread() {
        }

        @Override
        public void run() {
            if (StreamingHttpResultPublisher.this.subscriptionCanceled.get()) {
                return;
            }
            if (!StreamingHttpResultPublisher.this.queue.isEmpty() && StreamingHttpResultPublisher.this.pendingRequest.compareAndSet(true, false)) {
                Runnable next = StreamingHttpResultPublisher.this.queue.poll();
                if (next != null) {
                    next.run();
                } else {
                    StreamingHttpResultPublisher.this.pendingRequest.set(true);
                }
            }
        }
    }

    private class HttpSubscription
    implements Flow.Subscription {
        private HttpSubscription() {
        }

        @Override
        public void request(long n) {
            if (StreamingHttpResultPublisher.this.subscriptionCanceled.get()) {
                return;
            }
            if (n > 0L) {
                StreamingHttpResultPublisher.this.pendingRequest.set(true);
                StreamingHttpResultPublisher.this.taskRunner.requestNextRun();
            } else {
                this.cancel();
                StreamingHttpResultPublisher.this.subscriber.onError(new IllegalArgumentException("Subscriber requested a non-positive number " + n));
            }
        }

        @Override
        public void cancel() {
            if (StreamingHttpResultPublisher.this.subscriptionCanceled.compareAndSet(false, true)) {
                StreamingHttpResultPublisher.this.taskRunner.cancel();
            }
        }
    }
}

