/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.googlevertexai;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.googlevertexai.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.GoogleVertexAiEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.GoogleVertexAiRerankRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankModel;

public class GoogleVertexAiActionCreator
implements GoogleVertexAiActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public GoogleVertexAiActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(GoogleVertexAiEmbeddingsModel model, Map<String, Object> taskSettings) {
        GoogleVertexAiEmbeddingsRequestManager requestManager = new GoogleVertexAiEmbeddingsRequestManager(model, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage(model.uri(), "Google Vertex AI embeddings");
        return new SenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(GoogleVertexAiRerankModel model, Map<String, Object> taskSettings) {
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage(model.uri(), "Google Vertex AI rerank");
        GoogleVertexAiRerankRequestManager requestManager = GoogleVertexAiRerankRequestManager.of(model, this.serviceComponents.threadPool());
        return new SenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage);
    }
}

