/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.action.UpdateInferenceModelAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentUtils;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public class TransportUpdateInferenceModelAction
extends TransportMasterNodeAction<UpdateInferenceModelAction.Request, UpdateInferenceModelAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateInferenceModelAction.class);
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;
    private final Client client;

    @Inject
    public TransportUpdateInferenceModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry, Client client, Settings settings) {
        super("cluster:admin/xpack/inference/update", transportService, clusterService, threadPool, actionFilters, UpdateInferenceModelAction.Request::new, indexNameExpressionResolver, UpdateInferenceModelAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
        this.client = client;
    }

    protected void masterOperation(Task task, UpdateInferenceModelAction.Request request, ClusterState state, ActionListener<UpdateInferenceModelAction.Response> masterListener) {
        TaskType bodyTaskType = request.getContentAsSettings().taskType();
        TaskType resolvedTaskType = ServiceUtils.resolveTaskType(request.getTaskType(), bodyTaskType != null ? bodyTaskType.toString() : null);
        AtomicReference service = new AtomicReference();
        String inferenceEntityId = request.getInferenceEntityId();
        SubscribableListener.newForked(listener -> this.checkEndpointExists(inferenceEntityId, (ActionListener<UnparsedModel>)listener)).andThen((listener, unparsedModel) -> {
            Optional optionalService = this.serviceRegistry.getService(unparsedModel.service());
            if (optionalService.isEmpty()) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Service [{}] not found", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{unparsedModel.service()})));
            } else {
                service.set((InferenceService)optionalService.get());
                listener.onResponse(unparsedModel);
            }
        }).andThen((listener, existingUnparsedModel) -> {
            Model existingParsedModel = ((InferenceService)service.get()).parsePersistedConfigWithSecrets(request.getInferenceEntityId(), existingUnparsedModel.taskType(), new HashMap(existingUnparsedModel.settings()), new HashMap(existingUnparsedModel.secrets()));
            Model newModel = this.combineExistingModelWithNewSettings(existingParsedModel, request.getContentAsSettings(), ((InferenceService)service.get()).name(), resolvedTaskType);
            if (this.isInClusterService(((InferenceService)service.get()).name())) {
                this.updateInClusterEndpoint(request, newModel, existingParsedModel, (ActionListener<Boolean>)listener);
            } else {
                this.modelRegistry.updateModelTransaction(newModel, existingParsedModel, (ActionListener<Boolean>)listener);
            }
        }).andThen((listener, didUpdate) -> {
            if (didUpdate.booleanValue()) {
                this.modelRegistry.getModel(inferenceEntityId, (ActionListener<UnparsedModel>)ActionListener.wrap(unparsedModel -> {
                    if (unparsedModel == null) {
                        listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to update model, updated model not found", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
                    } else {
                        listener.onResponse((Object)((InferenceService)service.get()).parsePersistedConfig(request.getInferenceEntityId(), resolvedTaskType, new HashMap(unparsedModel.settings())).getConfigurations());
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to update model", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }).andThen((listener, modelConfig) -> listener.onResponse((Object)new UpdateInferenceModelAction.Response(modelConfig))).addListener(masterListener);
    }

    private Model combineExistingModelWithNewSettings(Model existingParsedModel, UpdateInferenceModelAction.Settings settingsToUpdate, String serviceName, TaskType resolvedTaskType) {
        SecretSettings existingSecretSettings;
        ModelConfigurations existingConfigs = existingParsedModel.getConfigurations();
        TaskSettings existingTaskSettings = existingConfigs.getTaskSettings();
        SecretSettings newSecretSettings = existingSecretSettings = existingParsedModel.getSecretSettings();
        TaskSettings newTaskSettings = existingTaskSettings;
        ServiceSettings newServiceSettings = existingConfigs.getServiceSettings();
        if (settingsToUpdate.serviceSettings() != null && existingSecretSettings != null) {
            newSecretSettings = existingSecretSettings.newSecretSettings(settingsToUpdate.serviceSettings());
        }
        if (settingsToUpdate.serviceSettings() != null && settingsToUpdate.serviceSettings().containsKey("num_allocations") && newServiceSettings instanceof ElasticsearchInternalServiceSettings) {
            ElasticsearchInternalServiceSettings elasticServiceSettings = (ElasticsearchInternalServiceSettings)newServiceSettings;
            newServiceSettings = new ElasticsearchInternalServiceSettings(elasticServiceSettings, (Integer)settingsToUpdate.serviceSettings().get("num_allocations"));
        }
        if (settingsToUpdate.taskSettings() != null && existingTaskSettings != null) {
            newTaskSettings = existingTaskSettings.updatedTaskSettings(settingsToUpdate.taskSettings());
        }
        if (!existingParsedModel.getTaskType().equals((Object)resolvedTaskType)) {
            throw new ElasticsearchStatusException("Task type must match the task type of the existing endpoint", RestStatus.BAD_REQUEST, new Object[0]);
        }
        ModelConfigurations newModelConfigs = new ModelConfigurations(existingParsedModel.getInferenceEntityId(), existingParsedModel.getTaskType(), serviceName, newServiceSettings, newTaskSettings);
        return new Model(newModelConfigs, new ModelSecrets(newSecretSettings));
    }

    private void updateInClusterEndpoint(UpdateInferenceModelAction.Request request, Model newModel, Model existingParsedModel, ActionListener<Boolean> listener) throws IOException {
        Object v;
        this.throwIfTrainedModelDoesntExist(request);
        Map serviceSettings = request.getContentAsSettings().serviceSettings();
        if (serviceSettings != null && (v = serviceSettings.get("num_allocations")) instanceof Integer) {
            Integer numAllocations = (Integer)v;
            UpdateTrainedModelDeploymentAction.Request updateRequest = new UpdateTrainedModelDeploymentAction.Request(request.getInferenceEntityId());
            updateRequest.setNumberOfAllocations(numAllocations);
            ActionListener delegate = listener.delegateFailure((l2, response) -> this.modelRegistry.updateModelTransaction(newModel, existingParsedModel, (ActionListener<Boolean>)l2));
            logger.info("Updating trained model deployment for inference entity [{}] with [{}] num_allocations", (Object)request.getInferenceEntityId(), (Object)numAllocations);
            this.client.execute((ActionType)UpdateTrainedModelDeploymentAction.INSTANCE, (ActionRequest)updateRequest, delegate);
        } else {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to parse [{}] of update request [{}]", RestStatus.BAD_REQUEST, new Object[]{"num_allocations", request.getContent().utf8ToString()})));
        }
    }

    private boolean isInClusterService(String name) {
        return List.of("elasticsearch", "elser").contains(name);
    }

    private void throwIfTrainedModelDoesntExist(UpdateInferenceModelAction.Request request) throws ElasticsearchStatusException {
        List assignments = TrainedModelAssignmentUtils.modelAssignments((String)request.getInferenceEntityId(), (ClusterState)this.clusterService.state());
        if (assignments == null || assignments.isEmpty()) {
            throw ExceptionsHelper.entityNotFoundException((String)"Requested model ID [{}] does not have a matching trained model and thus cannot be updated.", (Object[])new Object[]{request.getInferenceEntityId()});
        }
    }

    private void checkEndpointExists(String inferenceEntityId, ActionListener<UnparsedModel> listener) {
        this.modelRegistry.getModelWithSecrets(inferenceEntityId, (ActionListener<UnparsedModel>)ActionListener.wrap(model -> {
            if (model == null) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.entityNotFoundException((String)"The inference endpoint [{}] does not exist and cannot be updated", (Object[])new Object[]{inferenceEntityId})));
            } else {
                listener.onResponse(model);
            }
        }, e -> {
            if (e instanceof ResourceNotFoundException) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.entityNotFoundException((String)"The inference endpoint [{}] does not exist and cannot be updated", (Object[])new Object[]{inferenceEntityId})));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private static XContentParser getParser(UpdateInferenceModelAction.Request request) throws IOException {
        return XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)request.getContent(), (XContentType)request.getContentType());
    }

    protected ClusterBlockException checkBlock(UpdateInferenceModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

