/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal;

import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public interface ProtocolFact {
    public static final ProtocolFact DEFAULT = new ProtocolFact(){};
    public static final ProtocolFact AWS_JSON = new ProtocolFact(){

        @Override
        public boolean generatesBody(OperationInfo info) {
            return true;
        }
    };
    public static final ProtocolFact SMITHY_RPC_V2_CBOR = new ProtocolFact(){
        private final Map<String, String> extraHeaders = Collections.unmodifiableMap(MapUtils.of((Object)"smithy-protocol", (Object)"rpc-v2-cbor"));

        @Override
        public boolean generatesBody(OperationInfo info) {
            return true;
        }

        @Override
        public Map<String, String> extraHeaders() {
            return this.extraHeaders;
        }
    };

    default public boolean generatesBody(OperationInfo info) {
        return info.hasPayloadMembers();
    }

    default public Map<String, String> extraHeaders() {
        return Collections.emptyMap();
    }

    public static ProtocolFact from(AwsJsonProtocol protocol) {
        if (protocol == null) {
            return DEFAULT;
        }
        switch (protocol) {
            case SMITHY_RPC_V2_CBOR: {
                return SMITHY_RPC_V2_CBOR;
            }
            case AWS_JSON: {
                return AWS_JSON;
            }
        }
        return DEFAULT;
    }
}

