/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.indexing.AsyncTwoPhaseIndexer;
import org.elasticsearch.xpack.core.indexing.IndexerJobStats;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.indexing.IterationResult;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformEffectiveSettings;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.transforms.RetentionPolicyToDeleteByQueryRequestConverter;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.transforms.TransformFailureHandler;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformSchedulingUtils;

public abstract class TransformIndexer
extends AsyncTwoPhaseIndexer<TransformIndexerPosition, TransformIndexerStats> {
    private static final int PERSIST_STOP_AT_CHECKPOINT_TIMEOUT_SEC = 5;
    public static final int MINIMUM_PAGE_SIZE = 10;
    private static final Logger logger = LogManager.getLogger(TransformIndexer.class);
    private static final long NUMBER_OF_CHECKPOINTS_TO_KEEP = 10L;
    private static final long RETENTION_OF_CHECKPOINTS_MS = 864000000L;
    private static final long CHECKPOINT_CLEANUP_INTERVAL = 100L;
    public static final TimeValue DEFAULT_TRIGGER_SAVE_STATE_INTERVAL = TimeValue.timeValueSeconds((long)60L);
    protected final TransformConfigManager transformsConfigManager;
    private final CheckpointProvider checkpointProvider;
    protected final TransformFailureHandler failureHandler;
    private volatile float docsPerSecond = -1.0f;
    protected final TransformAuditor auditor;
    protected final TransformContext context;
    protected volatile TransformConfig transformConfig;
    private volatile TransformProgress progress;
    protected volatile boolean hasSourceChanged = true;
    protected final AtomicReference<Collection<ActionListener<Void>>> saveStateListeners = new AtomicReference();
    private volatile Map<String, String> fieldMappings;
    private Function function;
    private Function.ChangeCollector changeCollector;
    private Map<String, Object> nextChangeCollectorBucketPosition = null;
    private volatile Integer initialConfiguredPageSize;
    private final AtomicInteger remainingCheckpointsUntilAudit = new AtomicInteger(0);
    private volatile TransformCheckpoint lastCheckpoint;
    private volatile TransformCheckpoint nextCheckpoint;
    private volatile RunState runState;
    private volatile long lastCheckpointCleanup = 0L;
    private volatile long lastSaveStateMilliseconds;
    protected volatile boolean indexerThreadShuttingDown = false;
    protected volatile boolean saveStateRequestedDuringIndexerThreadShutdown = false;

    public TransformIndexer(ThreadPool threadPool, TransformServices transformServices, CheckpointProvider checkpointProvider, TransformConfig transformConfig, AtomicReference<IndexerState> initialState, TransformIndexerPosition initialPosition, TransformIndexerStats jobStats, TransformProgress transformProgress, TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint, TransformContext context) {
        super(threadPool, initialState, (Object)initialPosition, (IndexerJobStats)jobStats, (Object)context);
        ExceptionsHelper.requireNonNull((Object)transformServices, (String)"transformServices");
        this.transformsConfigManager = transformServices.configManager();
        this.checkpointProvider = (CheckpointProvider)ExceptionsHelper.requireNonNull((Object)checkpointProvider, (String)"checkpointProvider");
        this.auditor = transformServices.auditor();
        this.transformConfig = (TransformConfig)ExceptionsHelper.requireNonNull((Object)transformConfig, (String)"transformConfig");
        this.progress = transformProgress != null ? transformProgress : new TransformProgress();
        this.lastCheckpoint = (TransformCheckpoint)ExceptionsHelper.requireNonNull((Object)lastCheckpoint, (String)"lastCheckpoint");
        this.nextCheckpoint = (TransformCheckpoint)ExceptionsHelper.requireNonNull((Object)nextCheckpoint, (String)"nextCheckpoint");
        this.context = (TransformContext)ExceptionsHelper.requireNonNull((Object)context, (String)"context");
        this.runState = RunState.APPLY_RESULTS;
        this.failureHandler = new TransformFailureHandler(this.auditor, context, transformConfig.getId());
        if (transformConfig.getSettings() != null && transformConfig.getSettings().getDocsPerSecond() != null) {
            this.docsPerSecond = transformConfig.getSettings().getDocsPerSecond().floatValue();
        }
        this.lastSaveStateMilliseconds = TimeUnit.NANOSECONDS.toMillis(this.getTimeNanos());
    }

    abstract void doGetInitialProgress(SearchRequest var1, ActionListener<SearchResponse> var2);

    abstract void doGetFieldMappings(ActionListener<Map<String, String>> var1);

    abstract void doMaybeCreateDestIndex(Map<String, String> var1, ActionListener<Boolean> var2);

    abstract void doDeleteByQuery(DeleteByQueryRequest var1, ActionListener<BulkByScrollResponse> var2);

    abstract void refreshDestinationIndex(ActionListener<Void> var1);

    abstract void persistState(TransformState var1, ActionListener<Void> var2);

    abstract void validate(ActionListener<ValidateTransformAction.Response> var1);

    protected String getJobId() {
        return this.transformConfig.getId();
    }

    protected float getMaxDocsPerSecond() {
        return this.docsPerSecond;
    }

    protected boolean triggerSaveState() {
        long nextSaveStateMilliseconds;
        if (this.saveStateListeners.get() != null) {
            return true;
        }
        long currentTimeMilliseconds = TimeUnit.NANOSECONDS.toMillis(this.getTimeNanos());
        return currentTimeMilliseconds > (nextSaveStateMilliseconds = TransformSchedulingUtils.calculateNextScheduledTime(this.lastSaveStateMilliseconds, DEFAULT_TRIGGER_SAVE_STATE_INTERVAL, this.context.getStatePersistenceFailureCount()));
    }

    public TransformConfig getConfig() {
        return this.transformConfig;
    }

    public boolean isContinuous() {
        return this.getConfig().getSyncConfig() != null;
    }

    public Map<String, String> getFieldMappings() {
        return this.fieldMappings;
    }

    public TransformProgress getProgress() {
        return this.progress;
    }

    public TransformCheckpoint getLastCheckpoint() {
        return this.lastCheckpoint;
    }

    public TransformCheckpoint getNextCheckpoint() {
        return this.nextCheckpoint;
    }

    protected void createCheckpoint(ActionListener<TransformCheckpoint> listener) {
        this.checkpointProvider.createNextCheckpoint(this.getLastCheckpoint(), (ActionListener<TransformCheckpoint>)ActionListener.wrap(checkpoint -> this.transformsConfigManager.putTransformCheckpoint((TransformCheckpoint)checkpoint, (ActionListener<Boolean>)ActionListener.wrap(putCheckPointResponse -> listener.onResponse(checkpoint), createCheckpointException -> {
            logger.warn(() -> "[" + this.getJobId() + "] failed to create checkpoint.", (Throwable)createCheckpointException);
            listener.onFailure((Exception)new RuntimeException("Failed to create checkpoint due to: " + createCheckpointException.getMessage(), (Throwable)createCheckpointException));
        })), getCheckPointException -> {
            logger.warn(() -> "[" + this.getJobId() + "] failed to retrieve checkpoint.", (Throwable)getCheckPointException);
            listener.onFailure((Exception)new RuntimeException("Failed to retrieve checkpoint due to: " + getCheckPointException.getMessage(), (Throwable)getCheckPointException));
        }));
    }

    protected void onStart(long now, ActionListener<Boolean> listener) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to start while in state [{}].", (Object)this.getJobId(), (Object)TransformTaskState.FAILED.value());
            listener.onFailure((Exception)new ElasticsearchException("Attempted to start a failed transform [{}].", new Object[]{this.getJobId()}));
            return;
        }
        switch (this.getState()) {
            case ABORTING: 
            case STOPPING: 
            case STOPPED: {
                logger.debug("[{}] attempted to start while in state [{}].", (Object)this.getJobId(), (Object)this.getState().value());
                listener.onResponse((Object)false);
                return;
            }
        }
        if (this.context.getAuthState() != null && HealthStatus.RED.equals((Object)this.context.getAuthState().getStatus())) {
            listener.onFailure((Exception)new ElasticsearchSecurityException(TransformMessages.getMessage((String)"Cannot start transform [{0}] because user lacks required permissions, see privileges_check_failed issue for more details", (Object[])new Object[]{this.getConfig().getId()}), new Object[0]));
            return;
        }
        ActionListener finalListener = listener.delegateFailureAndWrap((l, r) -> {
            if (this.context.getPageSize() == 0) {
                this.configurePageSize(() -> this.context.getPageSize() == 0, this.getConfig().getSettings().getMaxPageSearchSize());
            }
            this.runState = this.determineRunStateAtStart();
            l.onResponse((Object)true);
        });
        ActionListener configurationReadyListener = ActionListener.wrap(unused -> {
            this.initializeFunction();
            if (this.initialRun()) {
                this.createCheckpoint((ActionListener<TransformCheckpoint>)ActionListener.wrap(cp -> {
                    this.nextCheckpoint = cp;
                    if (this.nextCheckpoint.getCheckpoint() > 1L) {
                        this.progress = new TransformProgress(null, Long.valueOf(0L), Long.valueOf(0L));
                        finalListener.onResponse(null);
                        return;
                    }
                    SearchRequest request = new SearchRequest(this.transformConfig.getSource().getIndex());
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                    this.function.buildSearchQueryForInitialProgress(searchSourceBuilder);
                    searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().filter(this.buildFilterQuery()).filter(searchSourceBuilder.query()));
                    request.allowPartialSearchResults(false).source(searchSourceBuilder);
                    this.doGetInitialProgress(request, (ActionListener<SearchResponse>)ActionListener.wrap(response -> this.function.getInitialProgressFromResponse((SearchResponse)response, (ActionListener<TransformProgress>)ActionListener.wrap(newProgress -> {
                        logger.trace("[{}] reset the progress from [{}] to [{}].", (Object)this.getJobId(), (Object)this.progress, newProgress);
                        this.progress = newProgress != null ? newProgress : new TransformProgress();
                        finalListener.onResponse(null);
                    }, failure -> {
                        this.progress = new TransformProgress();
                        logger.warn(() -> "[" + this.getJobId() + "] unable to load progress information for task.", (Throwable)failure);
                        finalListener.onResponse(null);
                    })), failure -> {
                        this.progress = new TransformProgress();
                        logger.warn(() -> "[" + this.getJobId() + "] unable to load progress information for task.", (Throwable)failure);
                        finalListener.onResponse(null);
                    }));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                finalListener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        SetOnce deducedDestIndexMappings = new SetOnce();
        boolean shouldMaybeCreateDestIndex = this.isFirstUnattendedRun() || this.context.shouldRecreateDestinationIndex();
        ActionListener fieldMappingsListener = ActionListener.wrap(destIndexMappings -> {
            this.fieldMappings = !destIndexMappings.isEmpty() ? destIndexMappings : (Map)deducedDestIndexMappings.get();
            if (destIndexMappings.isEmpty() && shouldMaybeCreateDestIndex) {
                this.doMaybeCreateDestIndex((Map)deducedDestIndexMappings.get(), (ActionListener<Boolean>)configurationReadyListener.delegateFailure((delegate, response) -> {
                    this.context.setShouldRecreateDestinationIndex(false);
                    delegate.onResponse(response);
                }));
            } else {
                configurationReadyListener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener reLoadFieldMappingsListener = ActionListener.wrap(updateConfigResponse -> {
            logger.debug(() -> Strings.format((String)"[%s] Retrieve field mappings from the destination index", (Object[])new Object[]{this.getJobId()}));
            this.doGetFieldMappings((ActionListener<Map<String, String>>)fieldMappingsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener changedSourceListener = ActionListener.wrap(validationResponse -> {
            deducedDestIndexMappings.set((Object)validationResponse.getDestIndexMappings());
            if (this.isContinuous()) {
                this.transformsConfigManager.getTransformConfiguration(this.getJobId(), (ActionListener<TransformConfig>)ActionListener.wrap(config -> {
                    if (this.transformConfig.equals(config) && this.fieldMappings != null && !shouldMaybeCreateDestIndex) {
                        logger.trace("[{}] transform config has not changed.", (Object)this.getJobId());
                        configurationReadyListener.onResponse(null);
                    } else {
                        this.transformConfig = config;
                        logger.debug("[{}] successfully refreshed transform config from index.", (Object)this.getJobId());
                        reLoadFieldMappingsListener.onResponse(null);
                    }
                }, failure -> {
                    String msg = TransformMessages.getMessage((String)"Failed to reload transform configuration for transform [{0}]", (Object[])new Object[]{this.getJobId()});
                    if (failure instanceof ResourceNotFoundException) {
                        if (IndexerState.ABORTING == this.getState()) {
                            logger.atDebug().withThrowable((Throwable)failure).log("Transform is in state [{}] during possible failure [{}].", (Object)IndexerState.ABORTING.value(), (Object)msg);
                            listener.onResponse((Object)false);
                        } else {
                            logger.error(msg, (Throwable)failure);
                            reLoadFieldMappingsListener.onFailure((Exception)((Object)new TransformConfigLostOnReloadException(msg, (Throwable)failure, new Object[0])));
                        }
                    } else {
                        logger.warn(msg, (Throwable)failure);
                        this.auditor.warning(this.getJobId(), msg);
                        reLoadFieldMappingsListener.onResponse(null);
                    }
                }));
            } else {
                reLoadFieldMappingsListener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        Instant instantOfTrigger = Instant.ofEpochMilli(now);
        if (this.context.getCheckpoint() > 0L && this.initialRun()) {
            this.checkpointProvider.sourceHasChanged(this.getLastCheckpoint(), (ActionListener<Boolean>)ActionListener.wrap(hasChanged -> {
                this.context.setLastSearchTime(instantOfTrigger);
                this.hasSourceChanged = hasChanged;
                if (hasChanged.booleanValue()) {
                    this.context.setChangesLastDetectedAt(instantOfTrigger);
                    logger.debug("[{}] source has changed, triggering new indexer run.", (Object)this.getJobId());
                    changedSourceListener.onResponse((Object)new ValidateTransformAction.Response(Collections.emptyMap()));
                } else {
                    logger.trace("[{}] source has not changed, finish indexer early.", (Object)this.getJobId());
                    listener.onResponse((Object)false);
                }
            }, failure -> {
                this.hasSourceChanged = true;
                listener.onFailure(failure);
            }));
        } else if (shouldMaybeCreateDestIndex) {
            this.validate((ActionListener<ValidateTransformAction.Response>)changedSourceListener);
        } else {
            this.hasSourceChanged = true;
            this.context.setLastSearchTime(instantOfTrigger);
            this.context.setChangesLastDetectedAt(instantOfTrigger);
            changedSourceListener.onResponse((Object)new ValidateTransformAction.Response(Collections.emptyMap()));
        }
    }

    private boolean isFirstUnattendedRun() {
        return this.context.getCheckpoint() == 0L && TransformEffectiveSettings.isUnattended((SettingsConfig)this.transformConfig.getSettings());
    }

    protected void initializeFunction() {
        this.function = FunctionFactory.create(this.getConfig());
        if (this.isContinuous()) {
            this.changeCollector = this.function.buildChangeCollector(this.getConfig().getSyncConfig().getField());
        }
    }

    protected boolean initialRun() {
        return this.getPosition() == null;
    }

    protected void onFinish(ActionListener<Void> listener) {
        this.startIndexerThreadShutdown();
        if (!this.hasSourceChanged) {
            if (this.context.shouldStopAtCheckpoint()) {
                this.stop();
            }
            listener.onResponse(null);
            return;
        }
        ActionListener failureHandlingListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), failure -> {
            this.failureHandler.handleIndexerFailure((Exception)failure, this.getConfig().getSettings());
            listener.onFailure(failure);
        });
        try {
            this.refreshDestinationIndex((ActionListener<Void>)ActionListener.wrap(response -> {
                if (this.transformConfig.getRetentionPolicyConfig() != null) {
                    this.executeRetentionPolicy((ActionListener<Void>)failureHandlingListener);
                } else {
                    this.finalizeCheckpoint((ActionListener<Void>)failureHandlingListener);
                }
            }, arg_0 -> ((ActionListener)failureHandlingListener).onFailure(arg_0)));
        }
        catch (Exception e) {
            failureHandlingListener.onFailure(e);
        }
    }

    private void executeRetentionPolicy(ActionListener<Void> listener) {
        DeleteByQueryRequest deleteByQuery = RetentionPolicyToDeleteByQueryRequestConverter.buildDeleteByQueryRequest(this.transformConfig.getRetentionPolicyConfig(), this.transformConfig.getSettings(), this.transformConfig.getDestination(), this.nextCheckpoint);
        if (deleteByQuery == null) {
            this.finalizeCheckpoint(listener);
            return;
        }
        logger.debug(() -> Strings.format((String)"[%s] Run delete based on retention policy using dbq [%s] with query: [%s]", (Object[])new Object[]{this.getJobId(), deleteByQuery, deleteByQuery.getSearchRequest()}));
        ((TransformIndexerStats)this.getStats()).markStartDelete();
        ActionListener deleteByQueryAndRefreshDoneListener = ActionListener.wrap(unused -> this.finalizeCheckpoint(listener), arg_0 -> listener.onFailure(arg_0));
        this.doDeleteByQuery(deleteByQuery, (ActionListener<BulkByScrollResponse>)ActionListener.wrap(bulkByScrollResponse -> {
            logger.trace(() -> Strings.format((String)"[%s] dbq response: [%s]", (Object[])new Object[]{this.getJobId(), bulkByScrollResponse}));
            ((TransformIndexerStats)this.getStats()).markEndDelete();
            ((TransformIndexerStats)this.getStats()).incrementNumDeletedDocuments(bulkByScrollResponse.getDeleted());
            logger.debug("[{}] deleted [{}] documents as part of the retention policy.", (Object)this.getJobId(), (Object)bulkByScrollResponse.getDeleted());
            if (bulkByScrollResponse.getVersionConflicts() > 0L) {
                listener.onFailure((Exception)((Object)new RetentionPolicyToDeleteByQueryRequestConverter.RetentionPolicyException("found [{}] version conflicts when deleting documents as part of the retention policy.", bulkByScrollResponse.getDeleted())));
                return;
            }
            if (bulkByScrollResponse.getBulkFailures().size() > 0 || bulkByScrollResponse.getSearchFailures().size() > 0) {
                assert (false) : "delete by query failed unexpectedly" + bulkByScrollResponse;
                listener.onFailure((Exception)((Object)new RetentionPolicyToDeleteByQueryRequestConverter.RetentionPolicyException("found failures when deleting documents as part of the retention policy. Response: [{}]", bulkByScrollResponse)));
                return;
            }
            this.refreshDestinationIndex((ActionListener<Void>)deleteByQueryAndRefreshDoneListener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void finalizeCheckpoint(ActionListener<Void> listener) {
        try {
            Integer pageSize = this.initialConfiguredPageSize;
            this.configurePageSize(() -> Objects.equals(pageSize, this.initialConfiguredPageSize), pageSize);
            if (this.changeCollector != null) {
                this.changeCollector.clear();
            }
            long checkpoint = this.context.incrementAndGetCheckpoint();
            this.lastCheckpoint = this.getNextCheckpoint();
            this.nextCheckpoint = null;
            this.context.resetReasonAndFailureCounter();
            if (this.progress.getPercentComplete() != null && this.progress.getPercentComplete() < 100.0) {
                this.progress.incrementDocsProcessed(this.progress.getTotalDocs() - this.progress.getDocumentsProcessed());
            }
            if (this.lastCheckpoint != null) {
                long docsIndexed = this.progress.getDocumentsIndexed();
                long docsProcessed = this.progress.getDocumentsProcessed();
                long durationMs = System.currentTimeMillis() - this.lastCheckpoint.getTimestamp();
                ((TransformIndexerStats)this.getStats()).incrementCheckpointExponentialAverages(durationMs < 0L ? 0L : durationMs, docsIndexed, docsProcessed);
            }
            if (this.shouldAuditOnFinish(checkpoint)) {
                this.auditor.info(this.getJobId(), "Finished indexing for transform checkpoint [" + checkpoint + "].");
            }
            logger.debug("[{}] finished indexing for transform checkpoint [{}].", (Object)this.getJobId(), (Object)checkpoint);
            if (this.context.shouldStopAtCheckpoint()) {
                this.stop();
            }
            if (checkpoint - this.lastCheckpointCleanup > 100L) {
                this.cleanupOldCheckpoints(listener);
            } else {
                listener.onResponse(null);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void afterFinishOrFailure() {
        this.finishIndexerThreadShutdown();
    }

    protected IterationResult<TransformIndexerPosition> doProcess(SearchResponse searchResponse) {
        switch (this.runState) {
            case APPLY_RESULTS: {
                return this.processBuckets(searchResponse);
            }
            case IDENTIFY_CHANGES: {
                return this.processChangedBuckets(searchResponse);
            }
        }
        logger.warn("[{}] Encountered unexpected run state [{}]", (Object)this.getJobId(), (Object)this.runState);
        throw new IllegalStateException("Transform indexer job encountered an illegal state [" + this.runState + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeTriggerAsyncJob(long now) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] schedule was triggered for transform but task is failed. Ignoring trigger.", (Object)this.getJobId());
            return false;
        }
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            IndexerState indexerState = this.getState();
            if (IndexerState.INDEXING.equals((Object)indexerState) || IndexerState.STOPPING.equals((Object)indexerState)) {
                logger.debug("[{}] indexer for transform has state [{}]. Ignoring trigger.", (Object)this.getJobId(), (Object)indexerState);
                return false;
            }
            return super.maybeTriggerAsyncJob(now);
        }
    }

    public void applyNewSettings(SettingsConfig newSettings) {
        this.auditor.info(this.transformConfig.getId(), "Transform settings have been updated.");
        logger.info("[{}] transform settings have been updated.", (Object)this.transformConfig.getId());
        this.docsPerSecond = newSettings.getDocsPerSecond() != null ? newSettings.getDocsPerSecond().floatValue() : -1.0f;
        this.configurePageSize(() -> !Objects.equals(newSettings.getMaxPageSearchSize(), this.initialConfiguredPageSize), newSettings.getMaxPageSearchSize());
        this.rethrottle();
    }

    protected void onFailure(Exception exc) {
        this.startIndexerThreadShutdown();
        try {
            this.failureHandler.handleIndexerFailure(exc, this.getConfig().getSettings());
        }
        catch (Exception e) {
            logger.error(() -> "[" + this.getJobId() + "] transform encountered an unexpected internal exception: ", (Throwable)e);
        }
    }

    protected void onStop() {
        this.auditor.info(this.transformConfig.getId(), "Transform has stopped.");
        logger.info("[{}] transform has stopped.", (Object)this.transformConfig.getId());
    }

    protected void onAbort() {
        this.auditor.info(this.transformConfig.getId(), "Received abort request, stopping transform.");
        logger.info("[{}] transform received abort request. Stopping indexer.", (Object)this.transformConfig.getId());
        this.context.shutdown();
    }

    protected void doSaveState(IndexerState indexerState, TransformIndexerPosition position, Runnable next) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to save state and stats while failed.", (Object)this.getJobId());
            next.run();
            return;
        }
        if (indexerState.equals((Object)IndexerState.ABORTING)) {
            next.run();
            return;
        }
        Collection saveStateListenersAtTheMomentOfCalling = this.saveStateListeners.getAndSet(null);
        boolean shouldStopAtCheckpoint = this.context.shouldStopAtCheckpoint();
        if (shouldStopAtCheckpoint && this.initialRun() && indexerState.equals((Object)IndexerState.STARTED)) {
            indexerState = IndexerState.STOPPED;
            this.auditor.info(this.transformConfig.getId(), "Transform is no longer in the middle of a checkpoint, initiating stop.");
            logger.info("[{}] transform is no longer in the middle of a checkpoint, initiating stop.", (Object)this.transformConfig.getId());
        }
        if (!this.hasSourceChanged && !indexerState.equals((Object)IndexerState.STOPPED)) {
            if (saveStateListenersAtTheMomentOfCalling != null) {
                ActionListener.onResponse((Iterable)saveStateListenersAtTheMomentOfCalling, null);
            }
            next.run();
            return;
        }
        TransformTaskState taskState = this.context.getTaskState();
        if (indexerState.equals((Object)IndexerState.STARTED) && this.context.getCheckpoint() == 1L && !this.isContinuous()) {
            indexerState = IndexerState.STOPPED;
            this.auditor.info(this.transformConfig.getId(), "Transform finished indexing all data, initiating stop");
            logger.info("[{}] transform finished indexing all data, initiating stop.", (Object)this.transformConfig.getId());
        }
        if (indexerState.equals((Object)IndexerState.STOPPED)) {
            shouldStopAtCheckpoint = false;
            taskState = TransformTaskState.STOPPED;
        }
        TransformState state = new TransformState(taskState, indexerState, position, this.context.getCheckpoint(), this.context.getStateReason(), this.getProgress(), null, shouldStopAtCheckpoint, this.context.getAuthState());
        logger.debug("[{}] updating persistent state of transform to [{}].", (Object)this.transformConfig.getId(), (Object)state.toString());
        this.persistStateWithAutoStop(state, (ActionListener<Void>)ActionListener.wrap(r -> {
            try {
                if (saveStateListenersAtTheMomentOfCalling != null) {
                    ActionListener.onResponse((Iterable)saveStateListenersAtTheMomentOfCalling, (Object)r);
                }
            }
            catch (Exception onResponseException) {
                String msg = LoggerMessageFormat.format((String)"[{}] failed notifying saveState listeners, ignoring.", (String)this.getJobId(), (Object[])new Object[0]);
                logger.warn(msg, (Throwable)onResponseException);
            }
            finally {
                this.lastSaveStateMilliseconds = TimeUnit.NANOSECONDS.toMillis(this.getTimeNanos());
                next.run();
            }
        }, e -> {
            try {
                if (saveStateListenersAtTheMomentOfCalling != null) {
                    ActionListener.onFailure((Iterable)saveStateListenersAtTheMomentOfCalling, (Exception)e);
                }
            }
            catch (Exception onFailureException) {
                String msg = LoggerMessageFormat.format((String)"[{}] failed notifying saveState listeners, ignoring.", (String)this.getJobId(), (Object[])new Object[0]);
                logger.warn(msg, (Throwable)onFailureException);
            }
            finally {
                next.run();
            }
        }));
    }

    private void persistStateWithAutoStop(TransformState state, ActionListener<Void> listener) {
        this.persistState(state, (ActionListener<Void>)ActionListener.runBefore(listener, () -> {
            if (state.getTaskState().equals((Object)TransformTaskState.STOPPED)) {
                this.context.shutdown();
            }
        }));
    }

    final void setStopAtCheckpoint(boolean shouldStopAtCheckpoint, ActionListener<Void> shouldStopAtCheckpointListener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
        try {
            if (!this.addSetStopAtCheckpointListener(shouldStopAtCheckpoint, shouldStopAtCheckpointListener)) {
                shouldStopAtCheckpointListener.onResponse(null);
            }
        }
        catch (InterruptedException e) {
            logger.error(() -> Strings.format((String)"[%s] Interrupt waiting (%ss) for transform state to be stored.", (Object[])new Object[]{this.getJobId(), 5}), (Throwable)e);
            shouldStopAtCheckpointListener.onFailure((Exception)new RuntimeException("Timed out (5s) waiting for transform state to be stored.", e));
        }
        catch (Exception e) {
            logger.error(() -> "[" + this.getJobId() + "] failed to persist transform state.", (Throwable)e);
            shouldStopAtCheckpointListener.onFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addSetStopAtCheckpointListener(boolean shouldStopAtCheckpoint, ActionListener<Void> shouldStopAtCheckpointListener) throws InterruptedException {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            if (this.indexerThreadShuttingDown) {
                this.context.setShouldStopAtCheckpoint(shouldStopAtCheckpoint);
                this.saveStateRequestedDuringIndexerThreadShutdown = true;
                return false;
            }
            IndexerState state = this.getState();
            if (state == IndexerState.STARTED && this.context.shouldStopAtCheckpoint() != shouldStopAtCheckpoint) {
                IndexerState newIndexerState = IndexerState.STARTED;
                TransformTaskState newtaskState = this.context.getTaskState();
                if (shouldStopAtCheckpoint && this.initialRun()) {
                    newIndexerState = IndexerState.STOPPED;
                    newtaskState = TransformTaskState.STOPPED;
                    logger.debug("[{}] transform is at a checkpoint, initiating stop.", (Object)this.transformConfig.getId());
                } else {
                    this.context.setShouldStopAtCheckpoint(shouldStopAtCheckpoint);
                }
                TransformState newTransformState = new TransformState(newtaskState, newIndexerState, (TransformIndexerPosition)this.getPosition(), this.context.getCheckpoint(), this.context.getStateReason(), this.getProgress(), null, newIndexerState == IndexerState.STARTED, this.context.getAuthState());
                CountDownLatch latch = new CountDownLatch(1);
                logger.debug("[{}] persisting stop at checkpoint", (Object)this.getJobId());
                this.persistState(newTransformState, (ActionListener<Void>)ActionListener.running(() -> latch.countDown()));
                if (!latch.await(5L, TimeUnit.SECONDS)) {
                    logger.error(() -> Strings.format((String)"[%s] Timed out (%ss) waiting for transform state to be stored.", (Object[])new Object[]{this.getJobId(), 5}));
                }
                if (newtaskState.equals((Object)TransformTaskState.STOPPED)) {
                    this.context.shutdown();
                }
                return false;
            }
            if (state != IndexerState.INDEXING) {
                return false;
            }
            if (this.saveStateListeners.updateAndGet(currentListeners -> {
                if (this.getState() != IndexerState.INDEXING) {
                    return null;
                }
                if (currentListeners == null) {
                    if (this.context.shouldStopAtCheckpoint() == shouldStopAtCheckpoint) {
                        return null;
                    }
                    return Collections.singletonList(shouldStopAtCheckpointListener);
                }
                return CollectionUtils.appendToCopy((Collection)currentListeners, (Object)shouldStopAtCheckpointListener);
            }) == null) {
                return false;
            }
            this.context.setShouldStopAtCheckpoint(shouldStopAtCheckpoint);
        }
        this.runSearchImmediately();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAndMaybeSaveState() {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            this.onStop();
            IndexerState state = this.stop();
            if (this.indexerThreadShuttingDown) {
                this.saveStateRequestedDuringIndexerThreadShutdown = true;
            } else if (state == IndexerState.STOPPED) {
                this.doSaveState(IndexerState.STOPPED, (TransformIndexerPosition)this.getPosition(), () -> {});
            }
        }
    }

    void handleFailure(Exception e) {
        this.failureHandler.handleIndexerFailure(e, this.getConfig().getSettings());
    }

    private void cleanupOldCheckpoints(ActionListener<Void> listener) {
        long now = this.getTimeNanos() * 1000L;
        long checkpointLowerBound = this.context.getCheckpoint() - 10L;
        long lowerBoundEpochMs = now - 864000000L;
        if (checkpointLowerBound > 0L && lowerBoundEpochMs > 0L) {
            this.transformsConfigManager.deleteOldCheckpoints(this.transformConfig.getId(), checkpointLowerBound, lowerBoundEpochMs, (ActionListener<Long>)ActionListener.wrap(deletes -> {
                logger.debug("[{}] deleted [{}] outdated checkpoints", (Object)this.getJobId(), deletes);
                listener.onResponse(null);
                this.lastCheckpointCleanup = this.context.getCheckpoint();
            }, e -> {
                logger.warn(() -> "[" + this.getJobId() + "] failed to cleanup old checkpoints, retrying after next checkpoint", (Throwable)e);
                this.auditor.warning(this.getJobId(), "Failed to cleanup old checkpoints, retrying after next checkpoint. Exception: " + e.getMessage());
                listener.onResponse(null);
            }));
        } else {
            logger.debug("[{}] checked for outdated checkpoints", (Object)this.getJobId());
            listener.onResponse(null);
        }
    }

    private IterationResult<TransformIndexerPosition> processBuckets(SearchResponse searchResponse) {
        Tuple<Stream<IndexRequest>, Map<String, Object>> indexRequestStreamAndCursor = this.function.processSearchResponse(searchResponse, this.getConfig().getDestination().getIndex(), this.getConfig().getDestination().getPipeline(), this.getFieldMappings(), (TransformIndexerStats)this.getStats(), this.progress);
        if (indexRequestStreamAndCursor == null || indexRequestStreamAndCursor.v1() == null) {
            if (this.nextCheckpoint.getCheckpoint() == 1L || !this.isContinuous() || !this.changeCollector.queryForChanges()) {
                return new IterationResult(Stream.empty(), null, true);
            }
            this.changeCollector.clear();
            this.runState = RunState.IDENTIFY_CHANGES;
            return new IterationResult(Stream.empty(), (Object)new TransformIndexerPosition(null, this.nextChangeCollectorBucketPosition), false);
        }
        Stream indexRequestStream = (Stream)indexRequestStreamAndCursor.v1();
        TransformIndexerPosition oldPosition = (TransformIndexerPosition)this.getPosition();
        TransformIndexerPosition newPosition = new TransformIndexerPosition((Map)indexRequestStreamAndCursor.v2(), oldPosition != null ? ((TransformIndexerPosition)this.getPosition()).getBucketsPosition() : null);
        return new IterationResult(indexRequestStream, (Object)newPosition, false);
    }

    private IterationResult<TransformIndexerPosition> processChangedBuckets(SearchResponse searchResponse) {
        this.nextChangeCollectorBucketPosition = this.changeCollector.processSearchResponse(searchResponse);
        if (this.nextChangeCollectorBucketPosition == null) {
            this.changeCollector.clear();
            return new IterationResult(Stream.empty(), null, true);
        }
        this.runState = RunState.APPLY_RESULTS;
        return new IterationResult(Stream.empty(), (Object)((TransformIndexerPosition)this.getPosition()), false);
    }

    protected QueryBuilder buildFilterQuery() {
        assert (this.nextCheckpoint != null);
        QueryBuilder queryBuilder = this.getConfig().getSource().getQueryConfig().getQuery();
        TransformConfig config = this.getConfig();
        if (this.isContinuous()) {
            BoolQueryBuilder filteredQuery = new BoolQueryBuilder().filter(queryBuilder);
            if (this.lastCheckpoint != null) {
                filteredQuery.filter(config.getSyncConfig().getRangeQuery(this.lastCheckpoint, this.nextCheckpoint));
            } else {
                filteredQuery.filter(config.getSyncConfig().getRangeQuery(this.nextCheckpoint));
            }
            return filteredQuery;
        }
        return queryBuilder;
    }

    protected Tuple<String, SearchRequest> buildSearchRequest() {
        assert (this.nextCheckpoint != null);
        switch (this.runState) {
            case APPLY_RESULTS: {
                return new Tuple((Object)"apply_results", (Object)this.buildQueryToUpdateDestinationIndex());
            }
            case IDENTIFY_CHANGES: {
                return new Tuple((Object)"identify_changes", (Object)this.buildQueryToFindChanges());
            }
        }
        logger.warn("Encountered unexpected run state [" + this.runState + "]");
        throw new IllegalStateException("Transform indexer job encountered an illegal state [" + this.runState + "]");
    }

    private SearchRequest buildQueryToFindChanges() {
        assert (this.isContinuous());
        TransformIndexerPosition position = (TransformIndexerPosition)this.getPosition();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().runtimeMappings(this.getConfig().getSource().getRuntimeMappings());
        SearchRequest request = new SearchRequest(this.getConfig().getSource().getIndex());
        request.allowPartialSearchResults(false).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        this.changeCollector.buildChangesQuery(sourceBuilder, position != null ? position.getBucketsPosition() : null, this.context.getPageSize());
        QueryBuilder queryBuilder = this.getConfig().getSource().getQueryConfig().getQuery();
        TransformConfig config = this.getConfig();
        BoolQueryBuilder filteredQuery = new BoolQueryBuilder().filter(queryBuilder).filter(config.getSyncConfig().getRangeQuery(this.lastCheckpoint, this.nextCheckpoint));
        sourceBuilder.query((QueryBuilder)filteredQuery);
        logger.debug("[{}] Querying {} for changes: {}", (Object)this.getJobId(), (Object)request.indices(), (Object)sourceBuilder);
        return request.source(sourceBuilder);
    }

    private SearchRequest buildQueryToUpdateDestinationIndex() {
        TransformIndexerPosition position = (TransformIndexerPosition)this.getPosition();
        TransformConfig config = this.getConfig();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().runtimeMappings(this.getConfig().getSource().getRuntimeMappings());
        this.function.buildSearchQuery(sourceBuilder, position != null ? position.getIndexerPosition() : null, this.context.getPageSize());
        SearchRequest request = new SearchRequest();
        QueryBuilder queryBuilder = config.getSource().getQueryConfig().getQuery();
        if (this.isContinuous()) {
            BoolQueryBuilder filteredQuery = new BoolQueryBuilder().filter(queryBuilder).filter(config.getSyncConfig().getRangeQuery(this.nextCheckpoint));
            if (this.changeCollector != null) {
                QueryBuilder filter = this.changeCollector.buildFilterQuery(this.lastCheckpoint, this.nextCheckpoint);
                if (filter != null) {
                    filteredQuery.filter(filter);
                }
                request.indices(this.getConfig().getSource().getIndex());
            } else {
                request.indices(this.getConfig().getSource().getIndex());
            }
            queryBuilder = filteredQuery;
        } else {
            request.indices(this.getConfig().getSource().getIndex());
        }
        sourceBuilder.query(queryBuilder);
        logger.debug("[{}] Querying {} for data: {}", (Object)this.getJobId(), (Object)request.indices(), (Object)sourceBuilder);
        return request.source(sourceBuilder).allowPartialSearchResults(false).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
    }

    protected boolean shouldAuditOnFinish(long completedCheckpoint) {
        return this.remainingCheckpointsUntilAudit.getAndUpdate(count -> {
            if (count > 0) {
                return count - 1;
            }
            if (completedCheckpoint >= 1000L) {
                return 999;
            }
            if (completedCheckpoint >= 100L) {
                return 99;
            }
            if (completedCheckpoint >= 10L) {
                return 9;
            }
            return 0;
        }) == 0;
    }

    private RunState determineRunStateAtStart() {
        if (this.context.from() != null && this.changeCollector != null && this.changeCollector.queryForChanges()) {
            return RunState.IDENTIFY_CHANGES;
        }
        if (this.nextCheckpoint.getCheckpoint() == 1L || !this.isContinuous()) {
            return RunState.APPLY_RESULTS;
        }
        if (this.changeCollector == null || !this.changeCollector.queryForChanges()) {
            return RunState.APPLY_RESULTS;
        }
        return RunState.IDENTIFY_CHANGES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurePageSize(Supplier<Boolean> shouldUpdate, Integer newPageSize) {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            if (shouldUpdate.get().booleanValue()) {
                this.initialConfiguredPageSize = newPageSize;
                if (newPageSize != null && newPageSize > 0) {
                    this.context.setPageSize(this.initialConfiguredPageSize);
                } else if (this.function != null) {
                    this.context.setPageSize(this.function.getInitialPageSize());
                } else {
                    this.context.setPageSize(Transform.DEFAULT_INITIAL_MAX_PAGE_SEARCH_SIZE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIndexerThreadShutdown() {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            this.indexerThreadShuttingDown = true;
            this.saveStateRequestedDuringIndexerThreadShutdown = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishIndexerThreadShutdown() {
        TransformContext transformContext = this.context;
        synchronized (transformContext) {
            this.indexerThreadShuttingDown = false;
            if (this.saveStateRequestedDuringIndexerThreadShutdown) {
                if (this.context.shouldStopAtCheckpoint() && this.nextCheckpoint == null) {
                    this.stop();
                }
                this.doSaveState(this.getState(), (TransformIndexerPosition)this.getPosition(), () -> {});
            }
        }
    }

    private static enum RunState {
        APPLY_RESULTS,
        IDENTIFY_CHANGES;

    }

    static class TransformConfigLostOnReloadException
    extends ResourceNotFoundException {
        TransformConfigLostOnReloadException(String msg, Throwable cause, Object ... args) {
            super(msg, cause, args);
        }
    }
}

