/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.EnrichResolution;
import org.elasticsearch.xpack.esql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.esql.analysis.TableInfo;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.enrich.ResolvedEnrichPolicy;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.index.MappingException;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalPlanOptimizer;
import org.elasticsearch.xpack.esql.parser.EsqlParser;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.plan.TableIdentifier;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Phased;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.Mapper;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.IndexResolver;
import org.elasticsearch.xpack.esql.session.Result;
import org.elasticsearch.xpack.esql.stats.PlanningMetrics;

public class EsqlSession {
    private static final Logger LOGGER = LogManager.getLogger(EsqlSession.class);
    private final String sessionId;
    private final Configuration configuration;
    private final IndexResolver indexResolver;
    private final EnrichPolicyResolver enrichPolicyResolver;
    private final PreAnalyzer preAnalyzer;
    private final Verifier verifier;
    private final EsqlFunctionRegistry functionRegistry;
    private final LogicalPlanOptimizer logicalPlanOptimizer;
    private final Mapper mapper;
    private final PhysicalPlanOptimizer physicalPlanOptimizer;
    private final PlanningMetrics planningMetrics;
    private final IndicesExpressionGrouper indicesExpressionGrouper;

    public EsqlSession(String sessionId, Configuration configuration, IndexResolver indexResolver, EnrichPolicyResolver enrichPolicyResolver, PreAnalyzer preAnalyzer, EsqlFunctionRegistry functionRegistry, LogicalPlanOptimizer logicalPlanOptimizer, Mapper mapper, Verifier verifier, PlanningMetrics planningMetrics, IndicesExpressionGrouper indicesExpressionGrouper) {
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.indexResolver = indexResolver;
        this.enrichPolicyResolver = enrichPolicyResolver;
        this.preAnalyzer = preAnalyzer;
        this.verifier = verifier;
        this.functionRegistry = functionRegistry;
        this.mapper = mapper;
        this.logicalPlanOptimizer = logicalPlanOptimizer;
        this.physicalPlanOptimizer = new PhysicalPlanOptimizer(new PhysicalOptimizerContext(configuration));
        this.planningMetrics = planningMetrics;
        this.indicesExpressionGrouper = indicesExpressionGrouper;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public void execute(EsqlQueryRequest request, EsqlExecutionInfo executionInfo, BiConsumer<PhysicalPlan, ActionListener<Result>> runPhase, ActionListener<Result> listener) {
        LOGGER.debug("ESQL query:\n{}", new Object[]{request.query()});
        this.analyzedPlan(this.parse(request.query(), request.params()), executionInfo, (ActionListener<LogicalPlan>)listener.delegateFailureAndWrap((next, analyzedPlan) -> this.executeOptimizedPlan(request, executionInfo, runPhase, this.optimizedPlan((LogicalPlan)((Object)analyzedPlan)), (ActionListener<Result>)next)));
    }

    public void executeOptimizedPlan(EsqlQueryRequest request, EsqlExecutionInfo executionInfo, BiConsumer<PhysicalPlan, ActionListener<Result>> runPhase, LogicalPlan optimizedPlan, ActionListener<Result> listener) {
        LogicalPlan firstPhase = Phased.extractFirstPhase(optimizedPlan);
        if (firstPhase == null) {
            EsqlSession.updateExecutionInfoAtEndOfPlanning(executionInfo);
            runPhase.accept(this.logicalPlanToPhysicalPlan(optimizedPlan, request), listener);
        } else {
            this.executePhased(new ArrayList<DriverProfile>(), optimizedPlan, request, executionInfo, firstPhase, runPhase, listener);
        }
    }

    private void executePhased(List<DriverProfile> profileAccumulator, LogicalPlan mainPlan, EsqlQueryRequest request, EsqlExecutionInfo executionInfo, LogicalPlan firstPhase, BiConsumer<PhysicalPlan, ActionListener<Result>> runPhase, ActionListener<Result> listener) {
        PhysicalPlan physicalPlan = this.logicalPlanToPhysicalPlan(this.optimizedPlan(firstPhase), request);
        runPhase.accept(physicalPlan, (ActionListener<Result>)listener.delegateFailureAndWrap((next, result) -> {
            try {
                profileAccumulator.addAll(result.profiles());
                LogicalPlan newMainPlan = this.optimizedPlan(Phased.applyResultsFromFirstPhase(mainPlan, physicalPlan.output(), result.pages()));
                LogicalPlan newFirstPhase = Phased.extractFirstPhase(newMainPlan);
                if (newFirstPhase == null) {
                    PhysicalPlan finalPhysicalPlan = this.logicalPlanToPhysicalPlan(newMainPlan, request);
                    runPhase.accept(finalPhysicalPlan, next.delegateFailureAndWrap((finalListener, finalResult) -> {
                        profileAccumulator.addAll(finalResult.profiles());
                        finalListener.onResponse((Object)new Result(finalResult.schema(), finalResult.pages(), profileAccumulator, executionInfo));
                    }));
                } else {
                    this.executePhased(profileAccumulator, newMainPlan, request, executionInfo, newFirstPhase, runPhase, (ActionListener<Result>)next);
                }
            }
            finally {
                Releasables.closeExpectNoException((Releasable)Releasables.wrap((Iterator)Iterators.map(result.pages().iterator(), p -> () -> ((Page)p).releaseBlocks())));
            }
        }));
    }

    private LogicalPlan parse(String query, QueryParams params) {
        LogicalPlan parsed = new EsqlParser().createStatement(query, params);
        LOGGER.debug("Parsed logical plan:\n{}", new Object[]{parsed});
        return parsed;
    }

    public void analyzedPlan(LogicalPlan parsed, EsqlExecutionInfo executionInfo, ActionListener<LogicalPlan> listener) {
        if (parsed.analyzed()) {
            listener.onResponse((Object)parsed);
            return;
        }
        this.preAnalyze(parsed, executionInfo, (indices, policies) -> {
            this.planningMetrics.gatherPreAnalysisMetrics(parsed);
            Analyzer analyzer = new Analyzer(new AnalyzerContext(this.configuration, this.functionRegistry, (IndexResolution)indices, (EnrichResolution)policies), this.verifier);
            LogicalPlan plan = analyzer.analyze(parsed);
            plan.setAnalyzed();
            LOGGER.debug("Analyzed plan:\n{}", new Object[]{plan});
            return plan;
        }, listener);
    }

    private <T> void preAnalyze(LogicalPlan parsed, EsqlExecutionInfo executionInfo, BiFunction<IndexResolution, EnrichResolution, T> action, ActionListener<T> listener) {
        PreAnalyzer.PreAnalysis preAnalysis = this.preAnalyzer.preAnalyze(parsed);
        Set<EnrichPolicyResolver.UnresolvedPolicy> unresolvedPolicies = preAnalysis.enriches.stream().map(e -> new EnrichPolicyResolver.UnresolvedPolicy((String)e.policyName().fold(), e.mode())).collect(Collectors.toSet());
        Set<String> targetClusters = this.enrichPolicyResolver.groupIndicesPerCluster((String[])preAnalysis.indices.stream().flatMap(t -> Arrays.stream(Strings.commaDelimitedListToStringArray((String)t.id().index()))).toArray(String[]::new)).keySet();
        this.enrichPolicyResolver.resolvePolicies(targetClusters, unresolvedPolicies, (ActionListener<EnrichResolution>)listener.delegateFailureAndWrap((l, enrichResolution) -> {
            Set<String> matchFields = enrichResolution.resolvedEnrichPolicies().stream().map(ResolvedEnrichPolicy::matchField).collect(Collectors.toSet());
            this.preAnalyzeIndices(parsed, executionInfo, (ActionListener<IndexResolution>)l.delegateFailureAndWrap((ll, indexResolution) -> {
                if (indexResolution.isValid()) {
                    EsqlSession.updateExecutionInfoWithClustersWithNoMatchingIndices(executionInfo, indexResolution);
                    EsqlSession.updateExecutionInfoWithUnavailableClusters(executionInfo, indexResolution.getUnavailableClusters());
                    Set<String> newClusters = this.enrichPolicyResolver.groupIndicesPerCluster((String[])indexResolution.get().concreteIndices().toArray(String[]::new)).keySet();
                    if (!targetClusters.containsAll(newClusters)) {
                        this.enrichPolicyResolver.resolvePolicies(newClusters, unresolvedPolicies, (ActionListener<EnrichResolution>)ll.map(newEnrichResolution -> action.apply((IndexResolution)indexResolution, (EnrichResolution)newEnrichResolution)));
                        return;
                    }
                }
                ll.onResponse(action.apply((IndexResolution)indexResolution, (EnrichResolution)enrichResolution));
            }), matchFields);
        }));
    }

    private void preAnalyzeIndices(LogicalPlan parsed, EsqlExecutionInfo executionInfo, ActionListener<IndexResolution> listener, Set<String> enrichPolicyMatchFields) {
        PreAnalyzer.PreAnalysis preAnalysis = new PreAnalyzer().preAnalyze(parsed);
        if (preAnalysis.indices.size() > 1) {
            listener.onFailure((Exception)((Object)new MappingException("Queries with multiple indices are not supported", new Object[0])));
        } else if (preAnalysis.indices.size() == 1) {
            TableInfo tableInfo = preAnalysis.indices.get(0);
            TableIdentifier table = tableInfo.id();
            Set<String> fieldNames = EsqlSession.fieldNames(parsed, enrichPolicyMatchFields);
            Map clusterIndices = this.indicesExpressionGrouper.groupIndices(IndicesOptions.DEFAULT, table.index());
            for (Map.Entry entry : clusterIndices.entrySet()) {
                String clusterAlias = (String)entry.getKey();
                String indexExpr = Strings.arrayToCommaDelimitedString((Object[])((OriginalIndices)entry.getValue()).indices());
                executionInfo.swapCluster(clusterAlias, (k, v) -> {
                    assert (v == null) : "No cluster for " + clusterAlias + " should have been added to ExecutionInfo yet";
                    return new EsqlExecutionInfo.Cluster(clusterAlias, indexExpr, executionInfo.isSkipUnavailable(clusterAlias));
                });
            }
            this.indexResolver.resolveAsMergedMapping(table.index(), fieldNames, listener);
        } else {
            try {
                listener.onResponse((Object)IndexResolution.invalid("[none specified]"));
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        }
    }

    static Set<String> fieldNames(LogicalPlan parsed, Set<String> enrichPolicyMatchFields) {
        if (!parsed.anyMatch(plan -> plan instanceof Aggregate || plan instanceof Project)) {
            return IndexResolver.ALL_FIELDS;
        }
        Holder projectAll = new Holder((Object)false);
        parsed.forEachExpressionDown(UnresolvedStar.class, us -> {
            if (((Boolean)projectAll.get()).booleanValue()) {
                return;
            }
            projectAll.set((Object)true);
        });
        if (((Boolean)projectAll.get()).booleanValue()) {
            return IndexResolver.ALL_FIELDS;
        }
        AttributeSet references = new AttributeSet();
        AttributeSet keepCommandReferences = new AttributeSet();
        ArrayList keepMatches = new ArrayList();
        ArrayList keepPatterns = new ArrayList();
        parsed.forEachDown(p -> {
            if (p instanceof RegexExtract) {
                RegexExtract re = (RegexExtract)p;
                for (Attribute extracted : re.extractedFields()) {
                    references.removeIf(attr -> EsqlSession.matchByName(attr, extracted.name(), false));
                }
                references.addAll(re.input().references());
            } else if (p instanceof Enrich) {
                Enrich enrich = (Enrich)p;
                AttributeSet enrichRefs = Expressions.references(enrich.enrichFields());
                enrichRefs = enrichRefs.combine(enrich.matchField().references());
                enrichRefs.removeIf(attr -> attr instanceof EmptyAttribute);
                references.addAll(enrichRefs);
            } else {
                UnresolvedRelation ur;
                references.addAll(p.references());
                if (p instanceof UnresolvedRelation && (ur = (UnresolvedRelation)((Object)p)).indexMode() == IndexMode.TIME_SERIES) {
                    references.add((Attribute)new UnresolvedAttribute(ur.source(), "@timestamp"));
                }
                p.forEachExpression(UnresolvedNamePattern.class, up -> {
                    UnresolvedAttribute ua = new UnresolvedAttribute(up.source(), up.name());
                    references.add((Attribute)ua);
                    if (p instanceof Keep) {
                        keepCommandReferences.add((Attribute)ua);
                        keepMatches.add(up::match);
                    }
                });
                if (p instanceof Keep) {
                    keepCommandReferences.addAll(p.references());
                }
            }
            AttributeSet planRefs = Expressions.references(p.expressions());
            p.forEachExpressionDown(Alias.class, alias -> {
                if (planRefs.names().contains(alias.name())) {
                    return;
                }
                references.removeIf(attr -> EsqlSession.matchByName(attr, alias.name(), keepCommandReferences.contains(attr)));
            });
        });
        references.removeIf(a -> a instanceof MetadataAttribute || MetadataAttribute.isSupported((String)a.name()));
        Set fieldNames = references.names();
        if (fieldNames.isEmpty() && enrichPolicyMatchFields.isEmpty()) {
            return IndexResolver.INDEX_METADATA_FIELD;
        }
        fieldNames.addAll(EsqlSession.subfields(fieldNames));
        fieldNames.addAll(enrichPolicyMatchFields);
        fieldNames.addAll(EsqlSession.subfields(enrichPolicyMatchFields));
        return fieldNames;
    }

    private static boolean matchByName(Attribute attr, String other, boolean skipIfPattern) {
        boolean isPattern = Regex.isSimpleMatchPattern((String)attr.name());
        if (skipIfPattern && isPattern) {
            return false;
        }
        String name = attr.name();
        return isPattern ? Regex.simpleMatch((String)name, (String)other) : name.equals(other);
    }

    private static Set<String> subfields(Set<String> names) {
        return names.stream().filter(name -> !name.endsWith("*")).map(name -> name + ".*").collect(Collectors.toSet());
    }

    private PhysicalPlan logicalPlanToPhysicalPlan(LogicalPlan optimizedPlan, EsqlQueryRequest request) {
        PhysicalPlan physicalPlan = this.optimizedPhysicalPlan(optimizedPlan);
        physicalPlan = (PhysicalPlan)physicalPlan.transformUp(FragmentExec.class, f -> {
            QueryBuilder filter = request.filter();
            if (filter != null) {
                QueryBuilder fragmentFilter = f.esFilter();
                filter = fragmentFilter != null ? QueryBuilders.boolQuery().filter(fragmentFilter).must(filter) : filter;
                LOGGER.debug("Fold filter {} to EsQueryExec", new Object[]{filter});
                f = f.withFilter(filter);
            }
            return f;
        });
        return EstimatesRowSize.estimateRowSize(0, physicalPlan);
    }

    public LogicalPlan optimizedPlan(LogicalPlan logicalPlan) {
        if (!logicalPlan.analyzed()) {
            throw new IllegalStateException("Expected analyzed plan");
        }
        LogicalPlan plan = this.logicalPlanOptimizer.optimize(logicalPlan);
        LOGGER.debug("Optimized logicalPlan plan:\n{}", new Object[]{plan});
        return plan;
    }

    public PhysicalPlan physicalPlan(LogicalPlan optimizedPlan) {
        if (!optimizedPlan.optimized()) {
            throw new IllegalStateException("Expected optimized plan");
        }
        PhysicalPlan plan = this.mapper.map(optimizedPlan);
        LOGGER.debug("Physical plan:\n{}", new Object[]{plan});
        return plan;
    }

    public PhysicalPlan optimizedPhysicalPlan(LogicalPlan optimizedPlan) {
        PhysicalPlan plan = this.physicalPlanOptimizer.optimize(this.physicalPlan(optimizedPlan));
        LOGGER.debug("Optimized physical plan:\n{}", new Object[]{plan});
        return plan;
    }

    static void updateExecutionInfoWithUnavailableClusters(EsqlExecutionInfo executionInfo, Set<String> unavailableClusters) {
        for (String clusterAlias : unavailableClusters) {
            executionInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(EsqlExecutionInfo.Cluster.Status.SKIPPED).build());
        }
    }

    static void updateExecutionInfoWithClustersWithNoMatchingIndices(EsqlExecutionInfo executionInfo, IndexResolution indexResolution) {
        HashSet<String> clustersWithResolvedIndices = new HashSet<String>();
        for (String indexName : indexResolution.get().indexNameWithModes().keySet()) {
            clustersWithResolvedIndices.add(RemoteClusterAware.parseClusterAlias((String)indexName));
        }
        Set<String> clustersRequested = executionInfo.clusterAliases();
        Set clustersWithNoMatchingIndices = Sets.difference(clustersRequested, clustersWithResolvedIndices);
        clustersWithNoMatchingIndices.removeAll(indexResolution.getUnavailableClusters());
        for (String c : clustersWithNoMatchingIndices) {
            executionInfo.swapCluster(c, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(EsqlExecutionInfo.Cluster.Status.SKIPPED).setTook(new TimeValue(0L)).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).build());
        }
    }

    static void updateExecutionInfoAtEndOfPlanning(EsqlExecutionInfo execInfo) {
        if (execInfo.isCrossClusterSearch()) {
            execInfo.markEndPlanning();
            for (String clusterAlias : execInfo.clusterAliases()) {
                EsqlExecutionInfo.Cluster cluster = execInfo.getCluster(clusterAlias);
                if (cluster.getStatus() != EsqlExecutionInfo.Cluster.Status.SKIPPED) continue;
                execInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(execInfo.planningTookTime()).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).build());
            }
        }
    }
}

