/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.lucene.spatial.XYQueriesUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class SpatialRelatesQuery
extends org.elasticsearch.xpack.esql.core.querydsl.query.Query {
    private final String field;
    private final ShapeRelation queryRelation;
    private final Geometry shape;
    private final DataType dataType;

    public SpatialRelatesQuery(Source source, String field, ShapeRelation queryRelation, Geometry shape, DataType dataType) {
        super(source);
        this.field = field;
        this.queryRelation = queryRelation;
        this.shape = shape;
        this.dataType = dataType;
    }

    public QueryBuilder asBuilder() {
        return DataType.isSpatialGeo((DataType)this.dataType) ? new GeoShapeQueryBuilder() : new CartesianShapeQueryBuilder();
    }

    protected String innerToString() {
        return "field:" + this.field + ", dataType:" + this.dataType + ", queryRelation:" + this.queryRelation + ", shape:" + this.shape;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.queryRelation, this.shape, this.dataType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SpatialRelatesQuery other = (SpatialRelatesQuery)((Object)obj);
        return Objects.equals(this.field, other.field) && Objects.equals(this.queryRelation, other.queryRelation) && Objects.equals(this.shape, other.shape) && Objects.equals(this.dataType, other.dataType);
    }

    public ShapeRelation shapeRelation() {
        return switch (this.queryRelation) {
            default -> throw new IncompatibleClassChangeError();
            case ShapeRelation.INTERSECTS -> ShapeRelation.INTERSECTS;
            case ShapeRelation.DISJOINT -> ShapeRelation.DISJOINT;
            case ShapeRelation.WITHIN -> ShapeRelation.WITHIN;
            case ShapeRelation.CONTAINS -> ShapeRelation.CONTAINS;
        };
    }

    private class GeoShapeQueryBuilder
    extends ShapeQueryBuilder {
        public final String NAME = "geo_shape";

        private GeoShapeQueryBuilder() {
            this.NAME = "geo_shape";
        }

        public String getWriteableName() {
            return "GeoShapeQueryBuilder";
        }

        @Override
        Query buildShapeQuery(SearchExecutionContext context, MappedFieldType fieldType) {
            if (!(fieldType instanceof GeoShapeQueryable)) {
                throw new QueryShardException((QueryRewriteContext)context, "Field [" + SpatialRelatesQuery.this.field + "] is of unsupported type [" + fieldType.typeName() + "] for [geo_shape] query", new Object[0]);
            }
            GeoShapeQueryable ft = (GeoShapeQueryable)fieldType;
            return new ConstantScoreQuery(ft.geoShapeQuery(context, fieldType.name(), SpatialRelatesQuery.this.shapeRelation(), SpatialRelatesQuery.this.shape));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.doToXContent("geo_shape", builder, params);
            return builder;
        }
    }

    private class CartesianShapeQueryBuilder
    extends ShapeQueryBuilder {
        private CartesianShapeQueryBuilder() {
        }

        public String getWriteableName() {
            return "CartesianShapeQueryBuilder";
        }

        @Override
        Query buildShapeQuery(SearchExecutionContext context, MappedFieldType fieldType) {
            Query innerQuery = SpatialRelatesQuery.this.dataType == DataType.CARTESIAN_POINT ? CartesianShapeQueryBuilder.pointShapeQuery(SpatialRelatesQuery.this.shape, fieldType.name(), SpatialRelatesQuery.this.queryRelation, context) : CartesianShapeQueryBuilder.shapeShapeQuery(SpatialRelatesQuery.this.shape, fieldType.name(), SpatialRelatesQuery.this.queryRelation, context);
            return new ConstantScoreQuery(innerQuery);
        }

        private static Query pointShapeQuery(Geometry geometry, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            MappedFieldType fieldType = context.getFieldType(fieldName);
            try {
                return XYQueriesUtils.toXYPointQuery((Geometry)geometry, (String)fieldName, (ShapeRelation)relation, (boolean)fieldType.isIndexed(), (boolean)fieldType.hasDocValues());
            }
            catch (IllegalArgumentException e) {
                throw new QueryShardException((QueryRewriteContext)context, "Exception creating query on Field [" + fieldName + "] " + e.getMessage(), (Throwable)e, new Object[0]);
            }
        }

        private static Query shapeShapeQuery(Geometry geometry, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before((VersionId)IndexVersions.V_7_5_0)) {
                throw new QueryShardException((QueryRewriteContext)context, relation + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
            }
            MappedFieldType fieldType = context.getFieldType(fieldName);
            try {
                return XYQueriesUtils.toXYShapeQuery((Geometry)geometry, (String)fieldName, (ShapeRelation)relation, (boolean)fieldType.isIndexed(), (boolean)fieldType.hasDocValues());
            }
            catch (IllegalArgumentException e) {
                throw new QueryShardException((QueryRewriteContext)context, "Exception creating query on Field [" + fieldName + "] " + e.getMessage(), (Throwable)e, new Object[0]);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.doToXContent("cartesian_shape", builder, params);
            return builder;
        }
    }

    public abstract class ShapeQueryBuilder
    implements QueryBuilder {
        protected void doToXContent(String queryName, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject(queryName);
            builder.startObject(SpatialRelatesQuery.this.field);
            builder.field("relation", (Enum)SpatialRelatesQuery.this.queryRelation);
            builder.field("shape");
            GeoJson.toXContent((Geometry)SpatialRelatesQuery.this.shape, (XContentBuilder)builder, (ToXContent.Params)params);
            builder.endObject();
            builder.endObject();
            builder.endObject();
        }

        public TransportVersion getMinimalSupportedVersion() {
            throw new UnsupportedOperationException("Unimplemented: toXContent()");
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("Unimplemented: toXContent()");
        }

        public Query toQuery(SearchExecutionContext context) throws IOException {
            MappedFieldType fieldType = context.getFieldType(SpatialRelatesQuery.this.field);
            if (fieldType == null) {
                throw new QueryShardException((QueryRewriteContext)context, "failed to find type for field [" + SpatialRelatesQuery.this.field + "]", new Object[0]);
            }
            return this.buildShapeQuery(context, fieldType);
        }

        abstract Query buildShapeQuery(SearchExecutionContext var1, MappedFieldType var2);

        public QueryBuilder queryName(String queryName) {
            throw new UnsupportedOperationException("Unimplemented: String");
        }

        public String queryName() {
            throw new UnsupportedOperationException("Unimplemented: queryName");
        }

        public float boost() {
            return 0.0f;
        }

        public QueryBuilder boost(float boost) {
            throw new UnsupportedOperationException("Unimplemented: float");
        }

        public String getName() {
            throw new UnsupportedOperationException("Unimplemented: getName");
        }

        public String fieldName() {
            return SpatialRelatesQuery.this.field;
        }

        public ShapeRelation relation() {
            return SpatialRelatesQuery.this.shapeRelation();
        }

        public Geometry shape() {
            return SpatialRelatesQuery.this.shape;
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }
    }
}

