/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.FailureCollector;
import org.elasticsearch.compute.operator.ResponseHeadersCollector;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.ComputeService;

final class ComputeListener
implements Releasable {
    private static final Logger LOGGER = LogManager.getLogger(ComputeService.class);
    private final RefCountingListener refs;
    private final FailureCollector failureCollector = new FailureCollector();
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final CancellableTask task;
    private final TransportService transportService;
    private final List<DriverProfile> collectedProfiles;
    private final ResponseHeadersCollector responseHeaders;
    private final EsqlExecutionInfo esqlExecutionInfo;
    private final String whereRunning;

    public static ComputeListener create(TransportService transportService, CancellableTask task, ActionListener<ComputeResponse> delegate) {
        return new ComputeListener(transportService, task, null, null, delegate);
    }

    public static ComputeListener create(String clusterAlias, TransportService transportService, CancellableTask task, EsqlExecutionInfo executionInfo, ActionListener<ComputeResponse> delegate) {
        return new ComputeListener(transportService, task, clusterAlias, executionInfo, delegate);
    }

    private ComputeListener(TransportService transportService, CancellableTask task, String clusterAlias, EsqlExecutionInfo executionInfo, ActionListener<ComputeResponse> delegate) {
        this.transportService = transportService;
        this.task = task;
        this.responseHeaders = new ResponseHeadersCollector(transportService.getThreadPool().getThreadContext());
        this.collectedProfiles = Collections.synchronizedList(new ArrayList());
        this.esqlExecutionInfo = executionInfo;
        this.whereRunning = clusterAlias;
        assert (clusterAlias == null && executionInfo == null || clusterAlias != null && executionInfo != null) : "clusterAlias and executionInfo must both be null or both non-null";
        this.refs = new RefCountingListener(1, ActionListener.wrap(ignored -> {
            ComputeResponse result;
            this.responseHeaders.finish();
            if (this.runningOnRemoteCluster()) {
                EsqlExecutionInfo.Cluster cluster = this.esqlExecutionInfo.getCluster(clusterAlias);
                result = new ComputeResponse(this.collectedProfiles.isEmpty() ? List.of() : this.collectedProfiles.stream().toList(), cluster.getTook(), cluster.getTotalShards(), cluster.getSuccessfulShards(), cluster.getSkippedShards(), cluster.getFailedShards());
            } else {
                result = new ComputeResponse(this.collectedProfiles.isEmpty() ? List.of() : this.collectedProfiles.stream().toList());
                if (this.coordinatingClusterIsSearchedInCCS()) {
                    executionInfo.swapCluster("", (k, v) -> {
                        if (v.getStatus() != EsqlExecutionInfo.Cluster.Status.SKIPPED) {
                            return new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL).build();
                        }
                        return v;
                    });
                }
            }
            delegate.onResponse((Object)result);
        }, e -> delegate.onFailure(this.failureCollector.getFailure())));
    }

    private boolean coordinatingClusterIsSearchedInCCS() {
        return this.esqlExecutionInfo != null && this.esqlExecutionInfo.isCrossClusterSearch() && this.esqlExecutionInfo.getCluster("") != null;
    }

    private boolean runningOnRemoteCluster() {
        return this.whereRunning != null && !this.whereRunning.equals("");
    }

    private boolean shouldRecordTookTime() {
        return this.runningOnRemoteCluster() || this.coordinatingClusterIsSearchedInCCS();
    }

    private boolean isCCSListener(String computeClusterAlias) {
        return "".equals(this.whereRunning) && !computeClusterAlias.equals("");
    }

    ActionListener<Void> acquireAvoid() {
        return this.refs.acquire().delegateResponse((l, e) -> {
            this.failureCollector.unwrapAndCollect(e);
            try {
                if (this.cancelled.compareAndSet(false, true)) {
                    LOGGER.debug("cancelling ESQL task {} on failure", new Object[]{this.task});
                    this.transportService.getTaskManager().cancelTaskAndDescendants(this.task, "cancelled on failure", false, ActionListener.noop());
                }
            }
            finally {
                l.onFailure(e);
            }
        });
    }

    ActionListener<ComputeResponse> acquireCompute(@Nullable String computeClusterAlias) {
        assert (computeClusterAlias == null || this.esqlExecutionInfo != null && this.esqlExecutionInfo.getRelativeStartNanos() != null) : "When clusterAlias is provided to acquireCompute, executionInfo and relativeStartTimeNanos must be non-null";
        return this.acquireAvoid().map(resp -> {
            this.responseHeaders.collect();
            List<DriverProfile> profiles = resp.getProfiles();
            if (profiles != null && !profiles.isEmpty()) {
                this.collectedProfiles.addAll(profiles);
            }
            if (computeClusterAlias == null) {
                return null;
            }
            if (this.isCCSListener(computeClusterAlias)) {
                this.updateExecutionInfoWithRemoteResponse(computeClusterAlias, (ComputeResponse)((Object)resp));
            } else if (this.shouldRecordTookTime()) {
                Long relativeStartNanos = this.esqlExecutionInfo.getRelativeStartNanos();
                assert (relativeStartNanos != null) : "queryStartTimeNanos not set properly";
                TimeValue tookTime = new TimeValue(System.nanoTime() - relativeStartNanos, TimeUnit.NANOSECONDS);
                this.esqlExecutionInfo.swapCluster(computeClusterAlias, (k, v) -> {
                    if (v.getStatus() != EsqlExecutionInfo.Cluster.Status.SKIPPED && (v.getTook() == null || v.getTook().nanos() < tookTime.nanos())) {
                        return new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(tookTime).build();
                    }
                    return v;
                });
            }
            return null;
        });
    }

    private void updateExecutionInfoWithRemoteResponse(String computeClusterAlias, ComputeResponse resp) {
        if (resp.getTook() != null) {
            TimeValue remoteExecutionTime = resp.getTook();
            TimeValue planningTookTime = this.esqlExecutionInfo.planningTookTime();
            TimeValue tookOnCluster = new TimeValue(planningTookTime.nanos() + remoteExecutionTime.nanos(), TimeUnit.NANOSECONDS);
            this.esqlExecutionInfo.swapCluster(computeClusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL).setTook(tookOnCluster).setTotalShards(resp.getTotalShards()).setSuccessfulShards(resp.getSuccessfulShards()).setSkippedShards(resp.getSkippedShards()).setFailedShards(resp.getFailedShards()).build());
        } else {
            long remoteTook = System.nanoTime() - this.esqlExecutionInfo.getRelativeStartNanos();
            TimeValue tookOnCluster = new TimeValue(remoteTook, TimeUnit.NANOSECONDS);
            this.esqlExecutionInfo.swapCluster(computeClusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL).setTook(tookOnCluster).build());
        }
    }

    ActionListener<ComputeResponse> acquireCompute() {
        return this.acquireCompute(null);
    }

    public void close() {
        this.refs.close();
    }
}

