/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class TopNExec
extends UnaryExec
implements EstimatesRowSize {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "TopNExec", TopNExec::new);
    private final Expression limit;
    private final List<Order> order;
    private final Integer estimatedRowSize;

    public TopNExec(Source source, PhysicalPlan child, List<Order> order, Expression limit, Integer estimatedRowSize) {
        super(source, child);
        this.order = order;
        this.limit = limit;
        this.estimatedRowSize = estimatedRowSize;
    }

    private TopNExec(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), in.readCollectionAsList(Order::new), (Expression)in.readNamedWriteable(Expression.class), in.readOptionalVInt());
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeCollection(this.order());
        out.writeNamedWriteable((NamedWriteable)this.limit());
        out.writeOptionalVInt(this.estimatedRowSize());
    }

    public String getWriteableName() {
        return TopNExec.ENTRY.name;
    }

    protected NodeInfo<TopNExec> info() {
        return NodeInfo.create((Node)this, TopNExec::new, (Object)((Object)this.child()), this.order, (Object)this.limit, (Object)this.estimatedRowSize);
    }

    @Override
    public TopNExec replaceChild(PhysicalPlan newChild) {
        return new TopNExec(this.source(), newChild, this.order, this.limit, this.estimatedRowSize);
    }

    public Expression limit() {
        return this.limit;
    }

    public List<Order> order() {
        return this.order;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int size = state.consumeAllFields(true);
        return Objects.equals(this.estimatedRowSize, size) ? this : new TopNExec(this.source(), this.child(), this.order, this.limit, size);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order, this.limit, this.estimatedRowSize);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            TopNExec other = (TopNExec)obj;
            equals = Objects.equals(this.order, other.order) && Objects.equals(this.limit, other.limit) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize);
        }
        return equals;
    }
}

