/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class OrderExec
extends UnaryExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "OrderExec", OrderExec::new);
    private final List<Order> order;

    public OrderExec(Source source, PhysicalPlan child, List<Order> order) {
        super(source, child);
        this.order = order;
    }

    private OrderExec(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class), in.readCollectionAsList(Order::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeCollection(this.order());
    }

    public String getWriteableName() {
        return OrderExec.ENTRY.name;
    }

    protected NodeInfo<OrderExec> info() {
        return NodeInfo.create((Node)this, OrderExec::new, (Object)((Object)this.child()), this.order);
    }

    @Override
    public OrderExec replaceChild(PhysicalPlan newChild) {
        return new OrderExec(this.source(), newChild, this.order);
    }

    public List<Order> order() {
        return this.order;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.order, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OrderExec other = (OrderExec)((Object)obj);
        return Objects.equals(this.order, other.order) && Objects.equals((Object)this.child(), (Object)other.child());
    }
}

